/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.jmx.connector.rmi;

import com.sap.ni.NI;
import com.sap.ni.NiException;
import com.sap.ni.NiHandle;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;

public class NIClientSocketFactory
extends RMISocketFactory
implements Serializable {
    private static final Tracer TRACE = new Tracer(class$com$sapmarkets$bam$jmx$connector$rmi$NIClientSocketFactory == null ? (class$com$sapmarkets$bam$jmx$connector$rmi$NIClientSocketFactory = NIClientSocketFactory.class$("com.sapmarkets.bam.jmx.connector.rmi.NIClientSocketFactory")) : class$com$sapmarkets$bam$jmx$connector$rmi$NIClientSocketFactory);
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$jmx$connector$rmi$NIClientSocketFactory == null ? (class$com$sapmarkets$bam$jmx$connector$rmi$NIClientSocketFactory = NIClientSocketFactory.class$("com.sapmarkets.bam.jmx.connector.rmi.NIClientSocketFactory")) : class$com$sapmarkets$bam$jmx$connector$rmi$NIClientSocketFactory);
    private String routerString;
    static /* synthetic */ Class class$com$sapmarkets$bam$jmx$connector$rmi$NIClientSocketFactory;

    public Socket createSocket(String host, int port) throws IOException {
        if (this.routerString == null || this.routerString.length() == 0) {
            this.routerString = "";
        }
        try {
            String route = this.routerString + "/H/" + host + "/S/" + port;
            TRACE.traceDebug("connecting NI handle (route = '" + route + "'.");
            NiHandle hdl = new NiHandle(route, 3, NI.NI_TALK_NATIVE2);
            return hdl.getSocket();
        }
        catch (NiException ex) {
            TRACE.traceError("connecting NI handle failed! " + ex.getMessage());
            LOG.logError("connecting NI handle failed! " + ex.getMessage());
            throw new IOException(ex.toString());
        }
    }

    public void setRouterString(String route) {
        TRACE.traceInfo("Setting routerString to " + route);
        this.routerString = route;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        port = port == 0 ? 26000 : port;
        TRACE.traceInfo(" ClientSocketFactory: >creating ServerSocket on port " + port);
        return new ServerSocket(port);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

