/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.jmx.connector.rmi;

import com.sap.tc.logging.Location;
import com.sap.tc.logging.PropertiesConfigurator;
import com.sapmarkets.bam.j2ee.services.logviewer.LogViewer;
import com.sapmarkets.bam.jmx.connector.ConnectorClient;
import com.sapmarkets.bam.jmx.connector.LVServerFactory;
import com.sapmarkets.bam.jmx.connector.rmi.IntegratedLVServer;
import com.sapmarkets.bam.jmx.connector.rmi.IntegratedServerPropertiesNotFoundException;
import com.sapmarkets.bam.util.BAMConfigurationHandler;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.BAMSysRuntimeException;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.ResourceInFileOrJar;
import com.sapmarkets.bam.util.Tracer;
import com.sapmarkets.bam.view.AbstractLogViewerAppplication;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Properties;

public class IntegratedConnectorClient
implements ConnectorClient {
    public static final String SERVER_PROP = "IntegratedLogViewerServer.properties";
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$jmx$connector$AbstractLVServer == null ? (class$com$sapmarkets$bam$jmx$connector$AbstractLVServer = IntegratedConnectorClient.class$("com.sapmarkets.bam.jmx.connector.AbstractLVServer")) : class$com$sapmarkets$bam$jmx$connector$AbstractLVServer);
    private static final Tracer TRACE = new Tracer(class$com$sapmarkets$bam$jmx$connector$AbstractLVServer == null ? (class$com$sapmarkets$bam$jmx$connector$AbstractLVServer = IntegratedConnectorClient.class$("com.sapmarkets.bam.jmx.connector.AbstractLVServer")) : class$com$sapmarkets$bam$jmx$connector$AbstractLVServer);
    private IntegratedLVServer lvServer_;
    static /* synthetic */ Class class$com$sapmarkets$bam$jmx$connector$AbstractLVServer;

    public IntegratedConnectorClient() {
        TRACE.traceInfo("Integrated Server Initialization begins with properties from IntegratedLogViewerServer.properties");
        Properties configProps = new Properties();
        if (AbstractLogViewerAppplication.isStandalone()) {
            try {
                configProps.load(new ResourceInFileOrJar(SERVER_PROP).getInputStream());
            }
            catch (FileNotFoundException ex) {
                this.logFileNotFoundError(SERVER_PROP, ex);
            }
            catch (IOException ex) {
                this.logFileNotFoundError(SERVER_PROP, ex);
            }
        }
        new BAMConfigurationHandler(configProps);
        PropertiesConfigurator propConfig = new PropertiesConfigurator(BAMConfigurationHandler.getLoggingProperties());
        if (propConfig == null) {
            LOG.logError("Internal error: cannot initialize PropertiesConfigurator");
            return;
        }
        try {
            propConfig.initConfigure();
            configProps = BAMConfigurationHandler.getLogviewerProperties();
            this.lvServer_ = LVServerFactory.getIntegratedLVServer();
            LogViewer.setLVServer(this.lvServer_);
            this.lvServer_.init(configProps);
            TRACE.traceInfo("Log Viewer Integrated Server started!");
        }
        catch (Exception ex) {
            throw new BAMRuntimeException(LOG.getLocation(), ex);
        }
    }

    private void logFileNotFoundError(String propFilename, IOException ex) {
        LOG.logFatal("Property file [" + propFilename + "] could not be found (" + ex.getMessage() + ")! It will not be possible to run the integrated server.");
        LOG.logException(ex);
        throw new IntegratedServerPropertiesNotFoundException(Location.getLocation(this.getClass()), ex);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return this.lvServer_.invoke(method.getName(), method.getParameterTypes(), args);
        }
        catch (RemoteException ex) {
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_INVOKE_METHOD_ON_SERVER", new Object[]{method.getName()}, ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

