/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.jmx.connector;

import com.sapmarkets.bam.jmx.connector.ConnectionProtocol;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.Logger;

public class HostDescriptor {
    private static final Logger mLogger = new Logger(class$com$sapmarkets$bam$jmx$connector$HostDescriptor == null ? (class$com$sapmarkets$bam$jmx$connector$HostDescriptor = HostDescriptor.class$("com.sapmarkets.bam.jmx.connector.HostDescriptor")) : class$com$sapmarkets$bam$jmx$connector$HostDescriptor);
    private String mApplicationName;
    private String mConnectionURL;
    String mHostName;
    String mPortNumber;
    private ConnectionProtocol protocol;
    private boolean connect;
    private boolean connected;
    private String mConnectionErrorMessage = "";
    private String user;
    private String password;
    private String routerString;
    static /* synthetic */ Class class$com$sapmarkets$bam$jmx$connector$HostDescriptor;

    public HostDescriptor(String aHostName, String aPortNumber, ConnectionProtocol protocol, boolean connect, String routerString, String user, String password, String anApplicationName) {
        try {
            int i = Integer.parseInt(aPortNumber);
        }
        catch (NumberFormatException nfe) {
            mLogger.logException(nfe);
            throw new BAMRuntimeException(mLogger.getLocation(), "FAILED_TO_PARSE_PORT_NUMBER", new Object[]{anApplicationName}, nfe);
        }
        StringBuffer connectionURL = new StringBuffer();
        connectionURL.append(aHostName);
        connectionURL.append(":");
        connectionURL.append(aPortNumber);
        this.mConnectionURL = connectionURL.toString();
        this.mHostName = aHostName;
        this.mPortNumber = aPortNumber;
        this.protocol = protocol;
        this.connect = connect;
        this.routerString = routerString;
        this.mApplicationName = anApplicationName;
        this.user = user;
        this.password = password;
    }

    public String getConnectionURL() {
        return this.mConnectionURL;
    }

    public boolean getConnect() {
        return this.connect;
    }

    public String getApplicationName() {
        return this.mApplicationName;
    }

    public String getHostName() {
        return this.mHostName;
    }

    public String getPortNumber() {
        return this.mPortNumber;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.user;
    }

    public int hashCode() {
        int result = 17;
        if (this.mConnectionURL != null) {
            result += 37 * this.mConnectionURL.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            HostDescriptor descriptor = (HostDescriptor)obj;
            if (this.mConnectionURL != null && this.mConnectionURL.equals(descriptor.mConnectionURL)) {
                return true;
            }
        }
        return false;
    }

    public ConnectionProtocol getProtocol() {
        return this.protocol;
    }

    public String getRouterString() {
        return this.routerString;
    }

    public void setRouterString(String routerString) {
        this.routerString = routerString;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String toString() {
        return "[" + this.protocol.toString() + "//" + this.mHostName + ":" + this.mPortNumber + "/" + this.mApplicationName + "]";
    }

    public String getConnectionErrorMessage() {
        return this.mConnectionErrorMessage;
    }

    public void setConnectionErrorMessage(String connectionErrorMessage) {
        this.mConnectionErrorMessage = connectionErrorMessage;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

