/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.jmx.connector;

import com.sapmarkets.bam.communication.SocketMultiServer;
import com.sapmarkets.bam.j2ee.services.logviewer.MBeanRegistrar;
import com.sapmarkets.bam.jmx.connector.LVServer;
import com.sapmarkets.bam.jmx.connector.rmi.RMIConnectorServer;
import com.sapmarkets.bam.jmxadapter.util.LogDirectory;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.util.BAMSysRuntimeException;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public abstract class AbstractLVServer
implements LVServer,
RMIConnectorServer {
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$jmx$connector$AbstractLVServer == null ? (class$com$sapmarkets$bam$jmx$connector$AbstractLVServer = AbstractLVServer.class$("com.sapmarkets.bam.jmx.connector.AbstractLVServer")) : class$com$sapmarkets$bam$jmx$connector$AbstractLVServer);
    private static final Tracer TRACE = new Tracer(class$com$sapmarkets$bam$jmx$connector$AbstractLVServer == null ? (class$com$sapmarkets$bam$jmx$connector$AbstractLVServer = AbstractLVServer.class$("com.sapmarkets.bam.jmx.connector.AbstractLVServer")) : class$com$sapmarkets$bam$jmx$connector$AbstractLVServer);
    public static final String REMOTE_MBEAN_SERVER = "RemoteMBeanServer";
    protected MBeanServer mbeanServer_;
    protected LogDirectory mLogDirectory;
    static /* synthetic */ Class class$com$sapmarkets$bam$jmx$connector$AbstractLVServer;
    static /* synthetic */ Class class$javax$management$MBeanServer;

    public void init(Properties props) {
        MBeanRegistrar mbeanRegistrar = new MBeanRegistrar(this);
        mbeanRegistrar.registerLogControllerFacadeMBean(this.getExpiration(props));
        mbeanRegistrar.registerLogTypes(props);
        mbeanRegistrar.setHandlersAndReaders();
        this.startSocket(props);
    }

    protected long getExpiration(Properties props) {
        String expirationString;
        long expiration = 43200000L;
        if (props != null && (expirationString = (String)((Hashtable)props).get("SessionExpiration")) != null) {
            expiration = Long.parseLong(expirationString) * 1000L;
        }
        return expiration;
    }

    protected void startSocket(Properties properties) {
        int port = -1;
        String socketPortString = properties.getProperty("socketPort");
        if (socketPortString != null) {
            try {
                port = Integer.valueOf(socketPortString);
                new SocketMultiServer(port).start();
            }
            catch (NumberFormatException ex) {
                LOG.logWarning("Specified socket port [" + socketPortString + "] is invalid. Using standard 5465");
            }
            catch (BAMAppException e) {
                LOG.logException((Throwable)((Object)e));
            }
        } else {
            TRACE.traceInfo("No socket port for registering logs was specified in the properties [Logviewer_socketPort]. Therefore no socket connection will be opened.");
        }
    }

    public String getMBeanServerID() {
        if (this.mbeanServer_ == null) {
            return null;
        }
        try {
            ObjectName objectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            ObjectName serverDelegate = this.mbeanServer_.queryNames(objectName, null).iterator().next();
            return this.mbeanServer_.getAttribute(objectName, "MBeanServerId").toString();
        }
        catch (MalformedObjectNameException ex) {
            LOG.logOriginalException(ex);
            throw new BAMSysRuntimeException(TRACE.getLocation(), "UNABLE_TO_GET_MBEAN_SERVER_ID", ex);
        }
        catch (AttributeNotFoundException ex) {
            LOG.logOriginalException(ex);
            throw new BAMSysRuntimeException(TRACE.getLocation(), "INVALID_MBEAN_SERVER_ID", ex);
        }
        catch (InstanceNotFoundException ex) {
            LOG.logOriginalException(ex);
            throw new BAMSysRuntimeException(TRACE.getLocation(), "UNABLE_TO_GET_MBEAN_SERVER_ID", ex);
        }
        catch (MBeanException ex) {
            LOG.logOriginalException(ex);
            throw new BAMSysRuntimeException(TRACE.getLocation(), "UNABLE_TO_GET_MBEAN_SERVER_ID", ex);
        }
        catch (ReflectionException ex) {
            LOG.logOriginalException(ex);
            throw new BAMSysRuntimeException(TRACE.getLocation(), "UNABLE_TO_GET_MBEAN_SERVER_ID", ex);
        }
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer_;
    }

    public abstract int getClusterNodeID();

    public Object invoke(String methodName, Class[] signature, Object[] args) throws RemoteException, InvocationTargetException, IllegalAccessException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (methodName.equals("getMBeanServerID")) {
                return this.getMBeanServerID();
            }
            if (methodName.equals("invoke") && TRACE.isInfoEnabled()) {
                TRACE.traceInfo("Calling Method: " + args[0] + "->" + args[1]);
            }
            Method mbeanServerMethod = (class$javax$management$MBeanServer == null ? (class$javax$management$MBeanServer = AbstractLVServer.class$("javax.management.MBeanServer")) : class$javax$management$MBeanServer).getMethod(methodName, signature);
            Object obj = mbeanServerMethod.invoke((Object)this.mbeanServer_, args);
            if (methodName.equals("invoke") && TRACE.isInfoEnabled()) {
                TRACE.traceInfo("Finished calling method: " + args[0] + "->" + args[1]);
            }
            Thread.currentThread().setContextClassLoader(cl);
            return obj;
        }
        catch (NoSuchMethodException ex) {
            LOG.logOriginalException(ex);
            throw new BAMSysRuntimeException(TRACE.getLocation(), "NO_SUCH_METHOD_DECLARATION", new Object[]{args[0], args[1]}, ex);
        }
        catch (InvocationTargetException ex) {
            LOG.logOriginalException(ex);
            throw ex;
        }
        catch (IllegalAccessException ex) {
            LOG.logOriginalException(ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            LOG.logOriginalException(ex);
            throw ex;
        }
    }

    public LogDirectory getLogDirectory() {
        return this.mLogDirectory;
    }

    public void setLogDirectory(LogDirectory logDirectory) {
        this.mLogDirectory = logDirectory;
    }

    public abstract boolean isStandalone();

    public abstract String getClusterNodeName();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

