/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.j2ee.services.logviewer.gui;

import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.gui.UserNode;
import com.sap.engine.interfaces.visual_administration.AdminEvent;
import com.sap.engine.interfaces.visual_administration.AdminEventListener;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.interfaces.visual_administration.UnsupportedEditorException;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.LocalizationException;
import com.sap.localization.ResourceAccessor;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sapmarkets.bam.application.CompositeLogRegistrationResult;
import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.application.LogRegistrationResult;
import com.sapmarkets.bam.application.MonitorableFileHandler;
import com.sapmarkets.bam.application.User;
import com.sapmarkets.bam.application.logdepot.LogDepotFactory;
import com.sapmarkets.bam.application.logdepot.VALogDepot;
import com.sapmarkets.bam.j2ee.services.logviewer.LogViewerManagement;
import com.sapmarkets.bam.j2ee.services.logviewer.gui.LogViewerRuntimeView;
import com.sapmarkets.bam.jmx.connector.HostDescriptor;
import com.sapmarkets.bam.logcontroller.MetaDataOfReaders;
import com.sapmarkets.bam.util.LogViewerResourceAccessor;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.view.AbstractLogViewerAppplication;
import com.sapmarkets.bam.view.AddFileDialog;
import com.sapmarkets.bam.view.ExceptionDialog;
import com.sapmarkets.bam.view.ILogViewerApplication;
import com.sapmarkets.bam.view.ViewUtil;
import com.sapmarkets.bam.view.config.RemoteViewConfiguration;
import com.sapmarkets.bam.view.config.ViewConfigurationFactory;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.management.ObjectName;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;

public class LogViewerRuntimeLogical
extends LogViewerRuntimeView
implements ILogViewerApplication,
AdminEventListener {
    private static final Logger mLogger = new Logger(class$com$sapmarkets$bam$j2ee$services$logviewer$gui$LogViewerRuntimeLogical == null ? (class$com$sapmarkets$bam$j2ee$services$logviewer$gui$LogViewerRuntimeLogical = LogViewerRuntimeLogical.class$("com.sapmarkets.bam.j2ee.services.logviewer.gui.LogViewerRuntimeLogical")) : class$com$sapmarkets$bam$j2ee$services$logviewer$gui$LogViewerRuntimeLogical);
    private EditorViewManager taskManager = null;
    private static TimeZone userTimeZone = TimeZone.getDefault();
    private static Locale userLocale = Locale.getDefault();
    private static LogViewerResourceAccessor resourceAccessor = LogViewerResourceAccessor.getInstance();
    protected UserNode userNodeRoot;
    protected LogViewerManagement lvri;
    private Frame frame = ViewUtil.getOwnerFrame(this);
    private static final String[] FORMAT_ORDER = new String[]{"ListFormat", "PerfFormatter", "TraceFormat", "SQLTraceFormat", "ASCIIFormat", "XMLFormat"};
    static /* synthetic */ Class class$com$sapmarkets$bam$j2ee$services$logviewer$gui$LogViewerRuntimeLogical;

    public LogViewerRuntimeLogical() {
        Location l = Location.getLocation((String)"com.sapmarkets");
        l.addLog((Log)new FileLog("%t/LogViewer-VA-%u.log"));
        l.setEffectiveSeverity(0);
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Map getLogDepot() {
        return LogDepotFactory.getVALogDepots(this.lvri);
    }

    public void setEnvironment(String editorToolName, Object environment) throws UnsupportedEditorException {
        ((EditorViewManager)environment).setControlCached(true);
        ((EditorViewManager)environment).registerAdminEventListener((AdminEventListener)this, "LogViewer");
        if (!editorToolName.equals("SAPJ2EEEngineVisualAdministrator")) {
            try {
                throw new UnsupportedEditorException(LocalizableTextFormatter.formatString((ResourceAccessor)resourceAccessor, (String)"ADMIN_0", null, (Locale)userLocale, (TimeZone)userTimeZone));
            }
            catch (LocalizationException le) {
                throw new UnsupportedEditorException("admin_0");
            }
        }
    }

    public void show(ManagementInterface runtime) {
        this.setRuntime(runtime);
    }

    public JComponent getRuntimeControlComponent() {
        return this;
    }

    public JButton[] getRuntimeButtons() {
        return LogViewerRuntimeView.mToolbarButtons;
    }

    public JMenu getRuntimeMenu() {
        return null;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void setGlobalRuntime(ManagementInterface ri) {
        this.setRuntime(ri);
    }

    public void setRuntime(ManagementInterface ri) {
        if (AbstractLogViewerAppplication.isInitial) {
            this.lvri = (LogViewerManagement)ri;
            this.initOverview();
        }
    }

    protected void cleanupClient() {
        LogDepotFactory.resetFactory();
        RemoteViewConfiguration.resetView();
        AbstractLogViewerAppplication.isInitial = true;
        LogViewerRuntimeView.isFirstTime = true;
    }

    public void freeResources() {
        this.cleanupClient();
        this.closeAllLog();
    }

    public void setUserTree(UserNode root) {
        this.userNodeRoot = root;
    }

    public void setTaskManager(EditorViewManager manager) {
    }

    protected void createViewConfiguration() throws RemoteException, MalformedURLException, NotBoundException, Exception {
        this.mViewConfiguration = ViewConfigurationFactory.createViewConfiguration(this.lvri);
    }

    protected void addLogFileAction(String clusterID, LogDescriptor logDescriptor) {
        VALogDepot logDepot = LogDepotFactory.getVALogDepot(this.lvri, clusterID);
        MetaDataOfReaders mdor = logDepot.getMetaDataOfReaders();
        List formats = mdor.getFileReadingCapableFormats();
        String[] formatArray = new String[formats.size()];
        int i = 0;
        int j = 0;
        while (i < FORMAT_ORDER.length) {
            if (formats.contains(FORMAT_ORDER[i])) {
                formatArray[j++] = FORMAT_ORDER[i];
            }
            ++i;
        }
        MonitorableFileHandler fileMonitorHandler = new MonitorableFileHandler(logDepot);
        AddFileDialog addFileDialog = new AddFileDialog(this, this.getFrame(), fileMonitorHandler, formatArray);
        addFileDialog.pack();
        addFileDialog.setLocationRelativeTo(this.getFrame());
        addFileDialog.show();
    }

    protected void addLogDirectoryAction(String clusterID, LogDescriptor logDescriptor) {
        File file = null;
        HashSet<ObjectName> objectNames = null;
        CompositeLogRegistrationResult compositeRegistrationResult = null;
        VALogDepot logDepot = LogDepotFactory.getVALogDepot(this.lvri, clusterID);
        MonitorableFileHandler fileMonitorHandler = new MonitorableFileHandler(logDepot);
        JFileChooser fileChooser = new JFileChooser();
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        file = fileChooser.getSelectedFile();
        try {
            objectNames = new HashSet<ObjectName>();
            List registrationResults = fileMonitorHandler.readAndRegisterLogsFromLogDirectory(file.getAbsolutePath(), new User("Tester"));
            compositeRegistrationResult = new CompositeLogRegistrationResult(registrationResults);
            Iterator iterator = registrationResults.iterator();
            while (iterator.hasNext()) {
                LogRegistrationResult result = (LogRegistrationResult)iterator.next();
                if (result == null || result.getStatus() != 0) continue;
                objectNames.add(result.getObjectName());
            }
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
        if (objectNames != null) {
            Iterator iterObjectNames = objectNames.iterator();
            while (iterObjectNames.hasNext()) {
                LogDescriptor ld;
                ObjectName objectName = (ObjectName)iterObjectNames.next();
                if (null == objectName || null == (ld = logDepot.getLogDescriptor(objectName))) continue;
                this.addLogToOverview(ld);
            }
        }
        String title = "LogDirectory Registration Result";
        ExceptionDialog.showMessage(this.frame, compositeRegistrationResult.toString(), compositeRegistrationResult.getSummaryData() + "\nNote: Files will only be registered if their path is in" + "\nthe Logviewer_MonitorablePath property!", title);
    }

    public void unregister(HostDescriptor hostDescriptor, LogDescriptor logDescriptor) {
        VALogDepot logDepot = LogDepotFactory.getVALogDepot(this.lvri, logDescriptor.getClusterNodeID());
        MonitorableFileHandler fileMonitorHandler = new MonitorableFileHandler(logDepot);
        fileMonitorHandler.unregister(logDescriptor.getObjectName());
    }

    public void setConfiguratedConnections(List configuratedConnections) {
        throw new UnsupportedOperationException("this operation is not supported by logviewer client VA version");
    }

    public List getConfiguratedConnections() {
        return null;
    }

    public void adminEventOccured(AdminEvent adminEvent) {
        if (adminEvent == null) {
            return;
        }
        if (adminEvent.getType() == 2) {
            this.cleanupClient();
        }
    }

    public void changeStateOfToolBarAndMenu(boolean state) {
    }

    public void changeStateOfTollBarAndMenuWhenAllFilesClose(boolean state) {
        AbstractLogViewerAppplication.mBtnRefreshLog.setEnabled(state);
        this.mBtnSave.setEnabled(state);
        this.mBtnCopy.setEnabled(state);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

