/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.j2ee.services.logviewer;

import com.sap.jmx.ObjectNameFactory;
import com.sapmarkets.bam.jmx.connector.LVServer;
import com.sapmarkets.bam.jmxadapter.LogTypeConfigurator;
import com.sapmarkets.bam.jmxadapter.util.LogDirectoryConfigurator;
import com.sapmarkets.bam.logcontroller.jmx.LogControllerFacade;
import com.sapmarkets.bam.util.BAMConfigRuntimeException;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.BAMSysRuntimeException;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.ResourceInFileOrJar;
import com.sapmarkets.bam.util.Tracer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class MBeanRegistrar {
    private static final String LOG_TYPE_CONFIG_PROP_FILE = "LogTypeConfig.properties";
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$j2ee$services$logviewer$MBeanRegistrar == null ? (class$com$sapmarkets$bam$j2ee$services$logviewer$MBeanRegistrar = MBeanRegistrar.class$("com.sapmarkets.bam.j2ee.services.logviewer.MBeanRegistrar")) : class$com$sapmarkets$bam$j2ee$services$logviewer$MBeanRegistrar);
    private static final Tracer TRACE = new Tracer(class$com$sapmarkets$bam$j2ee$services$logviewer$MBeanRegistrar == null ? (class$com$sapmarkets$bam$j2ee$services$logviewer$MBeanRegistrar = MBeanRegistrar.class$("com.sapmarkets.bam.j2ee.services.logviewer.MBeanRegistrar")) : class$com$sapmarkets$bam$j2ee$services$logviewer$MBeanRegistrar);
    private Set availableReaders;
    private Set availableHandlers;
    private LogDirectoryConfigurator logDirectoryConfigurator;
    private LVServer server_;
    static /* synthetic */ Class class$com$sapmarkets$bam$j2ee$services$logviewer$MBeanRegistrar;

    public MBeanRegistrar(LVServer server) {
        this.server_ = server;
    }

    protected void registerLogTypeConfigurators(Properties props, Properties propertiesFromJ2EE) {
        this.availableReaders = new HashSet();
        this.availableHandlers = new HashSet();
        try {
            this.logDirectoryConfigurator = new LogDirectoryConfigurator();
            this.logDirectoryConfigurator.configure(props, this.server_, propertiesFromJ2EE);
        }
        catch (MalformedObjectNameException e) {
            this.logregisterLogTypeConfiguratorsException(e);
        }
        catch (MBeanRegistrationException e) {
            this.logregisterLogTypeConfiguratorsException(e);
        }
        catch (NotCompliantMBeanException e) {
            this.logregisterLogTypeConfiguratorsException(e);
        }
        catch (InstanceAlreadyExistsException e) {
            this.logregisterLogTypeConfiguratorsException(e);
        }
        Iterator iter = ((Hashtable)props).keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith("configurator")) continue;
            String logTypeConfiguratorName = (String)((Hashtable)props).get(key);
            try {
                TRACE.traceInfo("registerLogTypeConfigurators: (key=" + key + ", type=" + logTypeConfiguratorName + ")");
                Class<?> clazz = Class.forName(logTypeConfiguratorName);
                LogTypeConfigurator configurator = (LogTypeConfigurator)clazz.newInstance();
                this.availableReaders.addAll(configurator.configure(props, this.server_.getMBeanServer(), propertiesFromJ2EE));
                this.availableHandlers.addAll(configurator.getHandlers());
                TRACE.traceInfo("registerLogTypeConfigurators: availableReaders=" + (this.availableReaders == null ? "(null)" : this.availableReaders.toString()));
            }
            catch (Throwable ex) {
                LOG.logError("Could not add log type configurator " + key + " with class: " + logTypeConfiguratorName + "! Please check you configuration, especially the LogTypeConfig.properties!" + " Error=" + ex.getMessage());
                TRACE.traceDebug("Could not add configurator (see logged error before)! Will log exception and continue.");
                TRACE.logOriginalException(ex);
            }
        }
    }

    private void logregisterLogTypeConfiguratorsException(Exception e) {
        LOG.logError("registerLogTypeConfigurators: Could not configure MBean-server " + this.server_.getMBeanServer().toString() + "! Will log exception and continue!");
        LOG.logOriginalException(e);
    }

    public void registerLogTypes(Properties propertiesFromJ2EE) {
        Properties props = new Properties();
        try {
            InputStream logTypeStream = new ResourceInFileOrJar(LOG_TYPE_CONFIG_PROP_FILE).getInputStream();
            if (null == logTypeStream) {
                throw new BAMRuntimeException(TRACE.getLocation(), "ERROR_READING_FILE", new Object[]{LOG_TYPE_CONFIG_PROP_FILE});
            }
            props.load(logTypeStream);
        }
        catch (FileNotFoundException ex) {
            throw new BAMConfigRuntimeException(LOG.getLocation(), "UNABLE_TO_LOAD_FILE", new Object[]{LOG_TYPE_CONFIG_PROP_FILE}, ex);
        }
        catch (IOException ex) {
            throw new BAMConfigRuntimeException(LOG.getLocation(), "UNABLE_TO_LOAD_FILE", new Object[]{LOG_TYPE_CONFIG_PROP_FILE}, ex);
        }
        this.registerLogTypeConfigurators(props, propertiesFromJ2EE);
    }

    public void registerLogControllerFacadeMBean(long expiration) {
        LogControllerFacade logControllerMBean = new LogControllerFacade(this.server_, expiration);
        ObjectName objectName = null;
        try {
            objectName = ObjectNameFactory.getNameForServerChildPerNode((String)"LogControllerFacadeMBean", (String)"LogControllerFacade", null, null);
            if (!this.server_.getMBeanServer().isRegistered(objectName)) {
                TRACE.traceInfo("Registering LogControllerFacadeMBean: " + objectName);
                this.server_.getMBeanServer().registerMBean(logControllerMBean, objectName);
            }
        }
        catch (MalformedObjectNameException ex) {
            throw new BAMSysRuntimeException(TRACE.getLocation(), "UNABLE_TO_REGISTER_MBEAN", new Object[]{"LogControllerFacadeMBean", ""}, ex);
        }
        catch (InstanceAlreadyExistsException ex) {
            throw new BAMSysRuntimeException(TRACE.getLocation(), "UNABLE_TO_REGISTER_MBEAN", new Object[]{"LogControllerFacadeMBean", objectName}, ex);
        }
        catch (MBeanRegistrationException ex) {
            throw new BAMSysRuntimeException(TRACE.getLocation(), "UNABLE_TO_REGISTER_MBEAN", new Object[]{"LogControllerFacadeMBean", objectName}, ex);
        }
        catch (NotCompliantMBeanException ex) {
            throw new BAMSysRuntimeException(TRACE.getLocation(), "UNABLE_TO_REGISTER_MBEAN", new Object[]{"LogControllerFacadeMBean", objectName}, ex);
        }
    }

    public void setHandlersAndReaders() {
        try {
            ObjectName objectName = ObjectNameFactory.getNameForServerChildPerNode((String)"LogControllerFacadeMBean", (String)"LogControllerFacade", null, null);
            this.server_.getMBeanServer().invoke(objectName, "setHandlersAndReaders", new Object[]{this.availableHandlers, this.availableReaders}, new String[]{"java.util.Set", "java.util.Set"});
            this.logDirectoryConfigurator.registerLogsFromLogDirectory();
        }
        catch (MalformedObjectNameException ex) {
            throw new BAMSysRuntimeException(TRACE.getLocation(), "UNABLE_TO_REGISTER_MBEAN", new Object[]{"LogControllerFacadeMBean"}, ex);
        }
        catch (ReflectionException ex) {
            throw new BAMSysRuntimeException(TRACE.getLocation(), "UNABLE_TO_REGISTER_MBEAN", new Object[]{"LogControllerFacadeMBean"}, ex);
        }
        catch (MBeanRegistrationException ex) {
            throw new BAMSysRuntimeException(TRACE.getLocation(), "UNABLE_TO_REGISTER_MBEAN", new Object[]{"LogControllerFacadeMBean"}, ex);
        }
        catch (MBeanException ex) {
            throw new BAMSysRuntimeException(TRACE.getLocation(), "UNABLE_TO_REGISTER_MBEAN", new Object[]{"LogControllerFacadeMBean"}, ex);
        }
        catch (InstanceNotFoundException ex) {
            throw new BAMSysRuntimeException(TRACE.getLocation(), "UNABLE_TO_REGISTER_MBEAN", new Object[]{"LogControllerFacadeMBean"}, ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

