/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.j2ee.services.logviewer;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.CommunicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.jmx.ObjectNameFactory;
import com.sap.tc.logging.PropertiesConfigurator;
import com.sapmarkets.bam.communication.SocketMultiServer;
import com.sapmarkets.bam.jmx.connector.LVServer;
import com.sapmarkets.bam.jmx.connector.LVServerFactory;
import com.sapmarkets.bam.jmx.connector.StandaloneLVServer;
import com.sapmarkets.bam.jmx.connector.rmi.RMIConnectorServer;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.util.BAMConfigurationHandler;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import com.sapmarkets.bam.util.Version;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.NamingException;

public class LogViewer
implements ApplicationServiceFrame,
CommunicationServiceFrame {
    private static Logger LOG = new Logger(class$com$sapmarkets$bam$j2ee$services$logviewer$LogViewer == null ? (class$com$sapmarkets$bam$j2ee$services$logviewer$LogViewer = LogViewer.class$("com.sapmarkets.bam.j2ee.services.logviewer.LogViewer")) : class$com$sapmarkets$bam$j2ee$services$logviewer$LogViewer);
    private static Tracer TRACE = new Tracer(class$com$sapmarkets$bam$j2ee$services$logviewer$LogViewer == null ? (class$com$sapmarkets$bam$j2ee$services$logviewer$LogViewer = LogViewer.class$("com.sapmarkets.bam.j2ee.services.logviewer.LogViewer")) : class$com$sapmarkets$bam$j2ee$services$logviewer$LogViewer);
    private static LVServer lvServer__;
    public static final Object[] lvServerLock;
    static /* synthetic */ Class class$com$sapmarkets$bam$j2ee$services$logviewer$LogViewer;

    private long getExpiration(Properties props) {
        String expirationString;
        long expiration = 43200000L;
        if (props != null && (expirationString = (String)((Hashtable)props).get("SessionExpiration")) != null) {
            expiration = Long.parseLong(expirationString) * 1000L;
        }
        return expiration;
    }

    public RMIConnectorServer start() {
        TRACE.traceInfo(Version.getVersionString());
        TRACE.traceInfo("Standalone Server Initialization begins with properties.");
        PropertiesConfigurator propConfig = new PropertiesConfigurator(BAMConfigurationHandler.getLoggingProperties());
        if (propConfig == null) {
            LOG.logError("Internal error: cannot initialize PropertiesConfigurator");
            return null;
        }
        try {
            propConfig.initConfigure();
            Properties configProps = BAMConfigurationHandler.getLogviewerProperties();
            boolean useNI = new Boolean(configProps.getProperty("use_NI"));
            StandaloneLVServer server = useNI ? LVServerFactory.getNIStandaloneLVServer(configProps) : LVServerFactory.getStandaloneLVServer(configProps);
            lvServer__ = server;
            Object[] objectArray = lvServerLock;
            synchronized (objectArray) {
                lvServerLock.notifyAll();
            }
            server.init(configProps);
            MBeanServer mbeanServer = server.getMBeanServer();
            System.out.println("Server Started.");
            TRACE.traceInfo("Log Viewer Server started!");
            return server;
        }
        catch (Throwable ex) {
            LOG.logFatal("Log Viewer Server could not start!");
            LOG.logOriginalException(ex);
            ex.printStackTrace();
            return null;
        }
    }

    private void startSocket(Properties properties) {
        int port = -1;
        String socketPortString = properties.getProperty("socketPort");
        if (socketPortString != null) {
            try {
                port = Integer.valueOf(socketPortString);
                new SocketMultiServer(port).start();
            }
            catch (NumberFormatException ex) {
                LOG.logWarning("Specified socket port [" + socketPortString + "] is invalid. Using standard 5465");
            }
            catch (BAMAppException e) {
                LOG.logException((Throwable)((Object)e));
            }
        } else {
            TRACE.traceInfo("No socket port for registering logs was specified in the properties [Logviewer_socketPort]. Therefore no socket connection will be opened.");
        }
    }

    public void start(ApplicationServiceContext serviceContext) throws ServiceException {
        TRACE.traceInfo(Version.getVersionString());
        TRACE.traceInfo("Server Initialization Begins");
        Properties properties = serviceContext.getServiceState().getProperties();
        LogViewer.logProperties(properties);
        new BAMConfigurationHandler(properties);
        Properties props = BAMConfigurationHandler.getLogviewerProperties();
        LogViewer.logProperties(BAMConfigurationHandler.getLogviewerProperties());
        try {
            lvServer__ = LVServerFactory.getServerJ2EELVServer(serviceContext, props);
            lvServer__.init(props);
            Object[] objectArray = lvServerLock;
            synchronized (objectArray) {
                lvServerLock.notifyAll();
            }
            LogViewer.logProperties(BAMConfigurationHandler.getLogviewerProperties());
        }
        catch (NamingException ex) {
            LOG.logException(ex);
        }
        catch (BAMRuntimeException e) {
            LOG.logException((Throwable)((Object)e));
        }
    }

    public void start(CommunicationServiceContext serviceContext) throws ServiceException {
        Properties properties = serviceContext.getServiceState().getProperties();
        LogViewer.logProperties(properties);
        new BAMConfigurationHandler(properties);
        Properties props = BAMConfigurationHandler.getLogviewerProperties();
        LogViewer.logProperties(BAMConfigurationHandler.getLogviewerProperties());
        try {
            lvServer__ = LVServerFactory.getDispatcherJ2EELVServer(serviceContext, props);
            lvServer__.init(props);
            LVServer lVServer = lvServer__;
            synchronized (lVServer) {
                Object[] objectArray = lvServerLock;
                synchronized (objectArray) {
                    lvServerLock.notifyAll();
                }
            }
        }
        catch (BAMRuntimeException ex) {
            LOG.logException((Throwable)((Object)ex));
        }
        TRACE.traceInfo("Log Viewer Server started!");
        LogViewer.logProperties(BAMConfigurationHandler.getLogviewerProperties());
        this.startSocket(BAMConfigurationHandler.getLogviewerProperties());
    }

    public static void logProperties(Properties props) {
        if (props != null) {
            Enumeration enumeration = ((Hashtable)props).keys();
            String propsString = "logviewer properties (Logviewer start):";
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                propsString = propsString + "[" + key + "/" + props.getProperty(key) + "]";
            }
            TRACE.traceInfo(propsString);
        } else {
            TRACE.traceInfo("cannot print properties, because properties is null");
        }
    }

    public void stop() {
        TRACE.traceInfo("Before stopping we have to unregister the LogDirectoryMBean");
        try {
            ObjectName objectName = ObjectNameFactory.getNameForServerChildPerNode((String)"LogDirectoryMBean", (String)"LogDirectory", null, null);
            MBeanServer mBeanServer = lvServer__.getMBeanServer();
            if (mBeanServer != null) {
                if (mBeanServer.isRegistered(objectName)) {
                    TRACE.traceInfo("Unregistering LogDirectoryMBean!");
                    mBeanServer.unregisterMBean(objectName);
                } else {
                    TRACE.traceInfo("Unregistering of LogDirectoryMBean not possible, because it is not registered!");
                }
            } else {
                LOG.logWarning("MBean Server could not be retrieved. Therefore LogDirectoryMBean could not be unregistered!");
            }
        }
        catch (MalformedObjectNameException e) {
            LOG.logException(e);
        }
        catch (InstanceNotFoundException e) {
            LOG.logException(e);
        }
        catch (MBeanRegistrationException e) {
            LOG.logException(e);
        }
        TRACE.traceInfo("Log Viewer Server stopped!");
    }

    public static synchronized LVServer getLVServer() {
        return lvServer__;
    }

    public static synchronized void setLVServer(LVServer lvServer) {
        lvServer__ = lvServer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        lvServerLock = new Object[0];
    }
}

