/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.communication;

import com.sap.sql.trace.SQLTraceXMLFormatter;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.NewLogEvent;
import com.sap.tc.logging.TraceFormatter;
import com.sap.tc.logging.perf.PerfFormatter;
import com.sapmarkets.bam.application.LogRegistrationResult;
import com.sapmarkets.bam.communication.SocketLogRegistrationDispatcher;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import java.io.File;
import java.util.Iterator;
import java.util.StringTokenizer;

public class LogviewerProtocol {
    private static final int WAITING = 0;
    private static final int SENT_REGISTER_OK = 2;
    private static final int SENT_UNREGISTER_OK = 3;
    private static final int SENTKNOCKKNOCK = 1;
    private static final int FINISHED = 3;
    private static Logger mLogger = new Logger(class$com$sapmarkets$bam$communication$LogviewerProtocol == null ? (class$com$sapmarkets$bam$communication$LogviewerProtocol = LogviewerProtocol.class$("com.sapmarkets.bam.communication.LogviewerProtocol")) : class$com$sapmarkets$bam$communication$LogviewerProtocol);
    private static Tracer mTracer = new Tracer(class$com$sapmarkets$bam$communication$LogviewerProtocol == null ? (class$com$sapmarkets$bam$communication$LogviewerProtocol = LogviewerProtocol.class$("com.sapmarkets.bam.communication.LogviewerProtocol")) : class$com$sapmarkets$bam$communication$LogviewerProtocol);
    private int state = 0;
    private SocketLogRegistrationDispatcher socketLogRegistrationDispatcher;
    static /* synthetic */ Class class$com$sapmarkets$bam$communication$LogviewerProtocol;

    public LogviewerProtocol(SocketLogRegistrationDispatcher socketLogRegistrationDispatcher) {
        this.socketLogRegistrationDispatcher = socketLogRegistrationDispatcher;
    }

    public String processInput(String theInput) {
        String theOutput = null;
        if (this.state == 0) {
            theOutput = "READY#Logviewer#6.30";
            mTracer.traceInfo("sending:" + theOutput);
            this.state = 1;
        } else if (this.state == 1) {
            if (theInput.equalsIgnoreCase("register")) {
                theOutput = "ready for registration";
                this.state = 2;
                mTracer.traceInfo("sending:" + theOutput);
            } else if (theInput.equalsIgnoreCase("unregister")) {
                theOutput = "ready for unregistration";
                this.state = 3;
                mTracer.traceInfo("sending:" + theOutput);
            } else {
                theOutput = "ERROR!";
                this.state = 0;
                mLogger.logError("[state=" + this.state + " input=[" + theInput + "] sending:" + theOutput);
            }
        } else if (this.state == 2) {
            StringTokenizer inp = new StringTokenizer(theInput, "#");
            if (inp.countTokens() == 2) {
                String filePath = inp.nextToken();
                String reader = inp.nextToken();
                File file = new File(filePath);
                theOutput = this.registerLog(file, reader);
                this.state = 3;
            } else {
                String response = "";
                response = response + "status= FAILED DUE TO WRONG FORMAT (<FILEPATH> <READER>)\r\n";
                response = response + "objectname:\r\n";
                response = response + "formattype: \r\n";
                theOutput = response = response + "exceptions:";
                mLogger.logError("sending" + theOutput);
                this.state = 0;
            }
        } else if (this.state == 3) {
            theOutput = "ERROR#NotSupportedYet";
            mTracer.traceInfo("unregistering is not supported yet");
            this.state = 3;
        } else if (this.state == 3) {
            theOutput = "finished";
            mTracer.traceInfo("sending" + theOutput);
            this.state = 0;
        }
        return theOutput;
    }

    private String registerLog(File file, String reader) {
        try {
            mTracer.traceInfo("trying to register a log with format [" + reader + "]");
            FileLog fileLog = null;
            if (reader.equalsIgnoreCase(LogTypeEnumeration.SAPJLOG.toString())) {
                fileLog = new FileLog(file.getPath(), (Formatter)new ListFormatter());
                mTracer.traceInfo("perparing to register a SAPJLog (" + file.getPath() + ")");
            } else if (reader.equalsIgnoreCase(LogTypeEnumeration.SAT_TRACE.toString())) {
                fileLog = new FileLog(file.getPath(), (Formatter)new PerfFormatter());
                mTracer.traceInfo("preparing to register a SATTrace (" + file.getPath() + ")");
            } else if (reader.equalsIgnoreCase(LogTypeEnumeration.SQL_TRACE.toString())) {
                fileLog = new FileLog(file.getPath(), (Formatter)new SQLTraceXMLFormatter());
                mTracer.traceInfo("preparing to register a SQLTrace (" + file.getPath() + ")");
            } else if (reader.equalsIgnoreCase("TraceLog") || reader.equalsIgnoreCase(LogTypeEnumeration.ASCII_LOG.toString())) {
                fileLog = new FileLog(file.getPath(), (Formatter)new TraceFormatter());
                mTracer.traceInfo("preparing to register a TraceLog/ASCIILog (" + file.getPath() + ")");
            } else {
                Class<?> clazz = Class.forName(reader);
                Formatter formatter = (Formatter)clazz.newInstance();
                fileLog = new FileLog(file.getPath(), formatter);
            }
            NewLogEvent event = new NewLogEvent((Log)fileLog);
            LogRegistrationResult result = this.socketLogRegistrationDispatcher.handleNewLogEvent(event);
            return this.createResponse(result);
        }
        catch (Exception ex) {
            mLogger.logException(ex);
            mLogger.logError("register failed (" + file.getPath() + ") due to wrong reader specification! Either the formatter is wrong or MBean could not get registered.");
            String response = "";
            response = response + "status: FAILED DUE TO EXCEPTION\r\n";
            response = response + "objectname:\r\n";
            response = response + "formattype: " + reader + " (check if reader is correct) \r\n";
            response = response + "exceptions:";
            response = response + ex.toString() + "\r\n";
            return response;
        }
    }

    private String createResponse(LogRegistrationResult result) {
        String response = "";
        response = response + "status=";
        if (result.getStatus() == 0) {
            response = response + "SUCCESSFUL";
        } else if (result.getStatus() == -1) {
            response = response + "FAILED";
        } else if (result.getStatus() == 1) {
            response = response + "ALREADY REGISTERED";
        } else if (result.getStatus() == 2) {
            response = response + "UNHANDLED";
        }
        response = response + "\r\n";
        String objectname = result.getObjectName().toString();
        objectname = LogviewerProtocol.replace(objectname, "\\", "\\\\");
        response = response + "objectname=" + objectname + "\r\n";
        response = response + "formattype=" + result.getFormatType() + "\r\n";
        response = response + "exceptions=";
        if (result.getExceptions().size() > 0) {
            Iterator itr = result.getExceptions().iterator();
            while (itr.hasNext()) {
                Exception ex = (Exception)itr.next();
                response = response + ex.toString() + "\r\n";
            }
        } else {
            response = response + " NONE\r\n";
        }
        return response;
    }

    private static String replace(String str, String word, String word2) {
        if (str == null || word == null || word2 == null || word.equals("") || word2.equals("") || str.equals("")) {
            return str;
        }
        StringBuffer buff = new StringBuffer(str);
        int lastPosition = 0;
        while (lastPosition > -1) {
            int startIndex = str.indexOf(word, lastPosition);
            if (startIndex == -1) break;
            int len = word.length();
            buff.delete(startIndex, startIndex + len);
            char[] charArray = word2.toCharArray();
            buff.insert(startIndex, charArray);
            str = buff.toString();
            int len2 = startIndex + word2.length();
            lastPosition = str.indexOf(word, len2);
        }
        return buff.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

