/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application.logdepot;

import com.sapmarkets.bam.application.logdepot.HostLogDepot;
import com.sapmarkets.bam.application.logdepot.IntegratedLogDepot;
import com.sapmarkets.bam.application.logdepot.VALogDepot;
import com.sapmarkets.bam.j2ee.services.logviewer.LogViewerManagement;
import com.sapmarkets.bam.jmx.connector.ConnectionProtocol;
import com.sapmarkets.bam.jmx.connector.HostDescriptor;
import com.sapmarkets.bam.jmx.connector.LVMBeanServer;
import com.sapmarkets.bam.jmx.connector.LVMBeanServerFactory;
import com.sapmarkets.bam.util.BAMConfigRuntimeException;
import com.sapmarkets.bam.util.BAMSysRuntimeException;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import java.io.IOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.NamingException;

public class LogDepotFactory {
    private static final Tracer TRACE__ = new Tracer(class$com$sapmarkets$bam$application$logdepot$LogDepotFactory == null ? (class$com$sapmarkets$bam$application$logdepot$LogDepotFactory = LogDepotFactory.class$("com.sapmarkets.bam.application.logdepot.LogDepotFactory")) : class$com$sapmarkets$bam$application$logdepot$LogDepotFactory);
    private static final Logger LOG__ = new Logger(class$com$sapmarkets$bam$application$logdepot$LogDepotFactory == null ? (class$com$sapmarkets$bam$application$logdepot$LogDepotFactory = LogDepotFactory.class$("com.sapmarkets.bam.application.logdepot.LogDepotFactory")) : class$com$sapmarkets$bam$application$logdepot$LogDepotFactory);
    public static final String CLUSTER_NODE_ID_PROPERTY_NAME = "SAP_J2EEClusterNode";
    private static Map hostDepots__ = new HashMap();
    private static Map vaDepots__ = null;
    public static final HostDescriptor INTEGRATED_HOST_DESCRIPTOR__ = new HostDescriptor("localhost", "0", ConnectionProtocol.LOCAL, true, null, null, null, "Local Logs");
    static /* synthetic */ Class class$com$sapmarkets$bam$application$logdepot$LogDepotFactory;

    public static synchronized IntegratedLogDepot getIntegratedLogDepot() {
        return (IntegratedLogDepot)LogDepotFactory.getHostLogDepot(INTEGRATED_HOST_DESCRIPTOR__, "\"\"");
    }

    public static synchronized Map getHostLogDepots(HostDescriptor hd) {
        Map depots = (Map)hostDepots__.get(hd);
        if (depots == null) {
            Set facades = LogDepotFactory.findFacadeObjectNames(hd);
            depots = LogDepotFactory.getDepots(hd, facades);
        }
        return depots;
    }

    public static synchronized HostLogDepot getHostLogDepot(HostDescriptor hd, String clusterNodeID) {
        Map depots = LogDepotFactory.getHostLogDepots(hd);
        return (HostLogDepot)depots.get(clusterNodeID);
    }

    private static Map getDepots(HostDescriptor hd, Set facades) {
        HashMap<String, IntegratedLogDepot> depots = new HashMap<String, IntegratedLogDepot>();
        Iterator itr = facades.iterator();
        while (itr.hasNext()) {
            ObjectName facade = (ObjectName)itr.next();
            String clusterNodeID = facade.getKeyProperty(CLUSTER_NODE_ID_PROPERTY_NAME);
            HostLogDepot logDepot = INTEGRATED_HOST_DESCRIPTOR__.equals(hd) ? new IntegratedLogDepot(hd, "\"\"") : new HostLogDepot(hd, clusterNodeID);
            depots.put(clusterNodeID, (IntegratedLogDepot)logDepot);
        }
        return depots;
    }

    public static synchronized Map getVALogDepots(LogViewerManagement runtime) {
        if (vaDepots__ == null) {
            Set facades = LogDepotFactory.findFacadeObjectNames(runtime);
            vaDepots__ = LogDepotFactory.getVADepots(runtime, facades);
        }
        return vaDepots__;
    }

    public static synchronized VALogDepot getVALogDepot(LogViewerManagement runtime, String clusterNodeID) {
        Map depots = LogDepotFactory.getVALogDepots(runtime);
        return (VALogDepot)depots.get(clusterNodeID);
    }

    private static Map getVADepots(LogViewerManagement runtime, Set facades) {
        HashMap<String, VALogDepot> depots = new HashMap<String, VALogDepot>();
        Iterator itr = facades.iterator();
        while (itr.hasNext()) {
            ObjectName facade = (ObjectName)itr.next();
            String clusterNodeID = facade.getKeyProperty(CLUSTER_NODE_ID_PROPERTY_NAME);
            depots.put(clusterNodeID, new VALogDepot(runtime, clusterNodeID));
        }
        return depots;
    }

    static LVMBeanServer getLVMBeanServer(LogViewerManagement runtime) {
        try {
            return LVMBeanServerFactory.getLVMBeanServer(runtime);
        }
        catch (RemoteException ex) {
            LOG__.logException(ex);
            throw new BAMSysRuntimeException(LOG__.getLocation(), "UNABLE_TO_CREATE_REMOTE_MBEAN_SERVER", ex);
        }
    }

    static LVMBeanServer getLVMBeanServer(HostDescriptor hostDescriptor) {
        try {
            return LVMBeanServerFactory.getLVMBeanServer(hostDescriptor);
        }
        catch (NamingException ex) {
            hostDescriptor.setConnected(false);
            hostDescriptor.setConnectionErrorMessage(ex.getMessage());
            LOG__.logOriginalException(ex);
            throw new BAMConfigRuntimeException(LOG__.getLocation(), "URL_NOT_FOUND", new Object[]{hostDescriptor.getConnectionURL()}, ex);
        }
        catch (IllegalArgumentException e) {
            hostDescriptor.setConnected(false);
            hostDescriptor.setConnectionErrorMessage(e.getMessage());
            LOG__.logOriginalException(e);
            throw new BAMConfigRuntimeException(LOG__.getLocation(), "URL_NOT_FOUND", new Object[]{hostDescriptor.getConnectionURL()}, e);
        }
        catch (IOException ex) {
            hostDescriptor.setConnected(false);
            hostDescriptor.setConnectionErrorMessage(ex.getMessage());
            LOG__.logOriginalException(ex);
            throw new BAMConfigRuntimeException(LOG__.getLocation(), "URL_NOT_FOUND", new Object[]{hostDescriptor.getConnectionURL()}, ex);
        }
        catch (NotBoundException e) {
            hostDescriptor.setConnected(false);
            hostDescriptor.setConnectionErrorMessage(e.getMessage());
            LOG__.logOriginalException(e);
            throw new BAMConfigRuntimeException(LOG__.getLocation(), "URL_NOT_FOUND", new Object[]{hostDescriptor.getConnectionURL()}, e);
        }
    }

    private static Set findFacadeObjectNames(HostDescriptor hostDescriptor) {
        ObjectName objNamePattern;
        String pattern = "*:j2eeType=LogControllerFacadeMBean,*";
        try {
            objNamePattern = new ObjectName(pattern);
        }
        catch (MalformedObjectNameException ex) {
            LOG__.logOriginalException(ex);
            throw new BAMSysRuntimeException(LOG__.getLocation(), "INVALID_LOG_CONTROLLER_FACADE_MBEAN_OBJECT_NAME", new Object[]{pattern}, ex);
        }
        LVMBeanServer mbeanServer = LogDepotFactory.getLVMBeanServer(hostDescriptor);
        Set<ObjectName> names = mbeanServer.queryNames(objNamePattern, null);
        return names;
    }

    private static Set findFacadeObjectNames(LogViewerManagement runtime) {
        String pattern = "*:j2eeType=LogControllerFacadeMBean,*";
        try {
            ObjectName objNamePattern = new ObjectName(pattern);
            LVMBeanServer mbeanServer = LVMBeanServerFactory.getLVMBeanServer(runtime);
            Set<ObjectName> names = mbeanServer.queryNames(objNamePattern, null);
            return names;
        }
        catch (MalformedObjectNameException ex) {
            LOG__.logOriginalException(ex);
            throw new BAMSysRuntimeException(LOG__.getLocation(), "UNABLE_TO_CREATE_LOG_CONTROLLER_FACADE_MBEAN_FROM_OBJECT_NAME", new Object[]{pattern}, ex);
        }
        catch (RemoteException ex) {
            LOG__.logException(ex);
            throw new BAMSysRuntimeException(LOG__.getLocation(), "UNABLE_TO_CREATE_REMOTE_MBEAN_SERVER", ex);
        }
    }

    public static void resetHostLogDepots(HostDescriptor hd) {
        hostDepots__.remove(hd);
        LVMBeanServerFactory.resetLVMBeanServer(hd);
    }

    public static void resetFactory() {
        hostDepots__ = new HashMap();
        vaDepots__ = null;
        LVMBeanServerFactory.resetFactory();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

