/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application.logdepot;

import com.sap.jmx.ObjectNameFactory;
import com.sapmarkets.bam.application.AttributeAssignmentException;
import com.sapmarkets.bam.application.InvalidAttributeException;
import com.sapmarkets.bam.application.InvalidLogDescriptorException;
import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.application.LogQuery;
import com.sapmarkets.bam.application.logdepot.LogDepot;
import com.sapmarkets.bam.jmx.connector.LVMBeanServer;
import com.sapmarkets.bam.logcontroller.DownloadSpecs;
import com.sapmarkets.bam.logcontroller.LogInfo;
import com.sapmarkets.bam.logcontroller.LogQuerySession;
import com.sapmarkets.bam.logcontroller.MetaDataOfReaders;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.BAMSysRuntimeException;
import com.sapmarkets.bam.util.LVVersion;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public abstract class AbstractLogDepot
implements LogDepot {
    private static Logger LOG__ = new Logger(class$com$sapmarkets$bam$application$logdepot$AbstractLogDepot == null ? (class$com$sapmarkets$bam$application$logdepot$AbstractLogDepot = AbstractLogDepot.class$("com.sapmarkets.bam.application.logdepot.AbstractLogDepot")) : class$com$sapmarkets$bam$application$logdepot$AbstractLogDepot);
    private static Tracer TRACE__ = new Tracer(class$com$sapmarkets$bam$application$logdepot$AbstractLogDepot == null ? (class$com$sapmarkets$bam$application$logdepot$AbstractLogDepot = AbstractLogDepot.class$("com.sapmarkets.bam.application.logdepot.AbstractLogDepot")) : class$com$sapmarkets$bam$application$logdepot$AbstractLogDepot);
    protected LVMBeanServer mBeanServer_;
    protected String clusterNodeID_;
    protected MetaDataOfReaders metaData_;
    static /* synthetic */ Class class$com$sapmarkets$bam$application$logdepot$AbstractLogDepot;

    public LVMBeanServer getMBeanServer() {
        return this.mBeanServer_;
    }

    private ObjectName getLogControllerFacadeObjectName() {
        try {
            return ObjectNameFactory.getNameForServerChildPerNode((String)"LogControllerFacadeMBean", (String)"LogControllerFacade", (String)this.clusterNodeID_, null);
        }
        catch (MalformedObjectNameException ex) {
            LOG__.logOriginalException(ex);
            throw new BAMSysRuntimeException(LOG__.getLocation(), "UNABLE_TO_CREATE_LOG_CONTROLLER_FACADE_MBEAN_OBJECT_NAME", ex);
        }
    }

    protected LogTypeEnumeration getLogType(LogInfo logInfo) {
        ObjectName objectName = logInfo.getObjectName();
        String type = objectName.getKeyProperty("j2eeType");
        return LogTypeEnumeration.toType(type);
    }

    public void unRegisterLog(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        if (this.mBeanServer_.isRegistered(name)) {
            if (TRACE__.isInfoEnabled()) {
                TRACE__.traceInfo("Unregistering " + name.toString());
            }
            this.mBeanServer_.unregisterMBean(name);
        }
    }

    public List getLogDescriptors() {
        try {
            Set logInfos = (Set)this.getAttribute(this.getLogControllerFacadeObjectName(), "LogInfos");
            ArrayList<LogDescriptor> logDescriptors = new ArrayList<LogDescriptor>();
            Iterator iter = logInfos.iterator();
            while (iter.hasNext()) {
                LogInfo logInfo = (LogInfo)iter.next();
                LogDescriptor descriptor = this.newLogDescriptor(logInfo);
                logDescriptors.add(descriptor);
            }
            if (TRACE__.isInfoEnabled()) {
                TRACE__.traceInfo("Number of logs: " + logDescriptors.size());
            }
            return logDescriptors;
        }
        catch (BAMAppException ex) {
            throw new BAMSysRuntimeException(LOG__.getLocation(), "UNABLE_TO_QUERY_FOR_LOGDESCRIPTORS", (Throwable)((Object)ex));
        }
    }

    public LogDescriptor getLogDescriptor(ObjectName name) {
        LogInfo logInfo = (LogInfo)this.invokeFacadeMethod("getLogInfo", new Object[]{name}, new String[]{"javax.management.ObjectName"});
        LogDescriptor descriptor = this.newLogDescriptor(logInfo);
        return descriptor;
    }

    public List getLogDescriptors(List names) {
        ArrayList<LogDescriptor> descriptors = new ArrayList<LogDescriptor>();
        List logInfos = (List)this.invokeFacadeMethod("getLogInfos", new Object[]{names}, new String[]{"java.util.List"});
        Iterator itr = logInfos.iterator();
        while (itr.hasNext()) {
            LogInfo logInfo = (LogInfo)itr.next();
            LogDescriptor descriptor = this.newLogDescriptor(logInfo);
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public String getClusterNodeID() {
        return this.clusterNodeID_;
    }

    public LogQuery createLogQuery(List logDescriptors, LogQueryExpression logQueryExpression, DownloadSpecs downloadSpecs) {
        LogQuerySession session = (LogQuerySession)this.invokeFacadeMethod("createLogQuerySession", new Object[]{logDescriptors, logQueryExpression, downloadSpecs}, new String[]{"java.util.List", "com.sapmarkets.bam.queryexpr.LogQueryExpression", "com.sapmarkets.bam.logcontroller.DownloadSpecs"});
        return new LogQuery(this, session, logQueryExpression, downloadSpecs);
    }

    public Object invokeMBeanMethod(ObjectName name, String methodName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (TRACE__.isInfoEnabled()) {
            TRACE__.traceInfo("Calling method: " + name + "->" + methodName);
        }
        Object value = this.mBeanServer_.invoke(name, methodName, params, signature);
        if (TRACE__.isInfoEnabled()) {
            TRACE__.traceInfo("Finished calling method: " + name + "->" + methodName);
        }
        return value;
    }

    private boolean hasNoServerVersioningSupport(UndeclaredThrowableException ex) {
        Throwable throwable = ex.getUndeclaredThrowable();
        if (!(throwable instanceof InvocationTargetException)) {
            return false;
        }
        InvocationTargetException itEx = (InvocationTargetException)throwable;
        Throwable tEx = itEx.getTargetException();
        if (!(tEx instanceof ReflectionException)) {
            return false;
        }
        ReflectionException rEx = (ReflectionException)tEx;
        Exception ex2 = rEx.getTargetException();
        if (!(ex2 instanceof NoSuchMethodException)) {
            return false;
        }
        NoSuchMethodException nsmEx = (NoSuchMethodException)ex2;
        String message = nsmEx.getMessage();
        return message.endsWith("getVersion()");
    }

    public Object invokeFacadeMethod(String methodName, Object[] parameters, String[] signature) {
        try {
            return this.invokeMBeanMethod(this.getLogControllerFacadeObjectName(), methodName, parameters, signature);
        }
        catch (ReflectionException ex) {
            LOG__.logOriginalException(ex);
            throw new BAMSysRuntimeException(LOG__.getLocation(), "UNABLE_TO_INVOKE_LOG_CONTROLLER_FACADE_MBEAN_METHOD", new Object[]{methodName}, ex);
        }
        catch (MBeanException ex) {
            LOG__.logOriginalException(ex);
            throw new BAMRuntimeException(LOG__.getLocation(), "UNABLE_TO_INVOKE_LOG_CONTROLLER_FACADE_MBEAN_METHOD", new Object[]{methodName}, ex);
        }
        catch (InstanceNotFoundException ex) {
            LOG__.logOriginalException(ex);
            throw new BAMRuntimeException(LOG__.getLocation(), "UNABLE_TO_INVOKE_LOG_CONTROLLER_FACADE_MBEAN_METHOD", new Object[]{methodName}, ex);
        }
        catch (UndeclaredThrowableException ex) {
            LOG__.logOriginalException(ex);
            throw new BAMRuntimeException(LOG__.getLocation(), "UNABLE_TO_INVOKE_LOG_CONTROLLER_FACADE_MBEAN_METHOD", new Object[]{methodName}, ex);
        }
    }

    public Object getAttribute(ObjectName name, String attributeName) throws BAMAppException, InvalidAttributeException, InvalidLogDescriptorException {
        TRACE__.traceInfo("Getting attribute: " + name + "->" + attributeName);
        try {
            Object value = this.mBeanServer_.getAttribute(name, attributeName);
            if (TRACE__.isInfoEnabled()) {
                TRACE__.traceInfo("Finished getting attribute: " + name + "->" + attributeName);
            }
            return value;
        }
        catch (MBeanException ex) {
            LOG__.logOriginalException(ex);
            throw new BAMAppException(LOG__.getLocation(), "UNABLE_TO_GET_ATTRIBUTE", new Object[]{name, attributeName}, ex);
        }
        catch (AttributeNotFoundException ex) {
            LOG__.logOriginalException(ex);
            throw new InvalidAttributeException(LOG__.getLocation(), "UNABLE_TO_GET_ATTRIBUTE", new Object[]{name, attributeName}, ex);
        }
        catch (InstanceNotFoundException ex) {
            LOG__.logOriginalException(ex);
            throw new InvalidLogDescriptorException(LOG__.getLocation(), "UNABLE_TO_GET_ATTRIBUTE", new Object[]{name, attributeName}, ex);
        }
        catch (ReflectionException ex) {
            LOG__.logOriginalException(ex);
            throw new InvalidAttributeException(LOG__.getLocation(), "UNABLE_TO_GET_ATTRIBUTE", new Object[]{name, attributeName}, ex);
        }
    }

    public void setAttribute(ObjectName name, String attributeName, Object value) throws BAMAppException, InvalidAttributeException, InvalidLogDescriptorException, AttributeAssignmentException {
        try {
            this.mBeanServer_.setAttribute(name, new Attribute(attributeName, value));
        }
        catch (MBeanException ex) {
            LOG__.logOriginalException(ex);
            throw new BAMAppException(LOG__.getLocation(), "UNABLE_TO_SET_ATTRIBUTE", new Object[]{name, attributeName}, ex);
        }
        catch (AttributeNotFoundException ex) {
            LOG__.logOriginalException(ex);
            throw new InvalidAttributeException(LOG__.getLocation(), "UNABLE_TO_SET_ATTRIBUTE", new Object[]{name, attributeName}, ex);
        }
        catch (InstanceNotFoundException ex) {
            LOG__.logOriginalException(ex);
            throw new InvalidLogDescriptorException(LOG__.getLocation(), "UNABLE_TO_SET_ATTRIBUTE", new Object[]{name, attributeName}, ex);
        }
        catch (ReflectionException ex) {
            LOG__.logOriginalException(ex);
            throw new InvalidAttributeException(LOG__.getLocation(), "UNABLE_TO_SET_ATTRIBUTE", new Object[]{name, attributeName}, ex);
        }
        catch (InvalidAttributeValueException ex) {
            LOG__.logOriginalException(ex);
            throw new AttributeAssignmentException(LOG__.getLocation(), AttributeAssignmentException.UNABLE_TO_SET_ATTRIBUTE, new Object[]{name, attributeName}, ex);
        }
    }

    protected abstract LogDescriptor newLogDescriptor(LogInfo var1);

    public MetaDataOfReaders getMetaDataOfReaders() {
        if (this.metaData_ == null) {
            this.metaData_ = (MetaDataOfReaders)this.invokeFacadeMethod("getMetaDataOfReaders", new Object[0], new String[0]);
        }
        return this.metaData_;
    }

    public void createUnconditionalCCMSTemplate(String destinationDirectory, ObjectName objectName) {
        try {
            Object object = this.invokeMBeanMethod(objectName, "createUnconditionalCCMSTemplate", new Object[]{destinationDirectory}, new String[]{"java.lang.String"});
        }
        catch (InstanceNotFoundException e) {
            TRACE__.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG__.getLocation(), "UNABLE_TO_INVOKE_ADDITIONAL_FILE_MONITORING_UTILITY_METHOD", new Object[]{"createUnconditionalCCMSTemplate"}, e);
        }
        catch (MBeanException e) {
            TRACE__.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG__.getLocation(), "UNABLE_TO_INVOKE_ADDITIONAL_FILE_MONITORING_UTILITY_METHOD", new Object[]{"createUnconditionalCCMSTemplate"}, e);
        }
        catch (ReflectionException e) {
            TRACE__.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG__.getLocation(), "UNABLE_TO_INVOKE_ADDITIONAL_FILE_MONITORING_UTILITY_METHOD", new Object[]{"createUnconditionalCCMSTemplate"}, e);
        }
    }

    public LVVersion getServerVersion() {
        try {
            return (LVVersion)this.getAttribute(this.getLogControllerFacadeObjectName(), "Version");
        }
        catch (BAMRuntimeException ex) {
            return null;
        }
        catch (BAMAppException ex) {
            return null;
        }
    }

    public abstract String getNodeDescription();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

