/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application.logbuffer.event;

import com.sap.engine.lib.util.concurrent.Channel;
import com.sapmarkets.bam.application.logbuffer.LogBufferModel;
import com.sapmarkets.bam.application.logbuffer.LogRecordTransporter;
import com.sapmarkets.bam.application.logbuffer.event.LBMCommand;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;

public class LBMCommandConsumer
implements Runnable {
    private Tracer mTracer = new Tracer(class$com$sapmarkets$bam$application$logbuffer$event$LBMCommandConsumer == null ? (class$com$sapmarkets$bam$application$logbuffer$event$LBMCommandConsumer = LBMCommandConsumer.class$("com.sapmarkets.bam.application.logbuffer.event.LBMCommandConsumer")) : class$com$sapmarkets$bam$application$logbuffer$event$LBMCommandConsumer);
    private Logger mLogger = new Logger(class$com$sapmarkets$bam$application$logbuffer$event$LBMCommandConsumer == null ? (class$com$sapmarkets$bam$application$logbuffer$event$LBMCommandConsumer = LBMCommandConsumer.class$("com.sapmarkets.bam.application.logbuffer.event.LBMCommandConsumer")) : class$com$sapmarkets$bam$application$logbuffer$event$LBMCommandConsumer);
    private Channel mCommandQueue;
    private LogBufferModel mLogBufferModel;
    private boolean mStopped;
    static /* synthetic */ Class class$com$sapmarkets$bam$application$logbuffer$event$LBMCommandConsumer;

    LBMCommandConsumer(Channel commandQueue, LogBufferModel logBufferModel) {
        this.mTracer.traceInfo("New LBMCommandConsumer thread spawned for processing LBMCommands.");
        this.mCommandQueue = commandQueue;
        this.mLogBufferModel = logBufferModel;
    }

    public void run() {
        LogRecordTransporter.TransportedLogQueryResultSet results = null;
        try {
            while (!this.mStopped) {
                LBMCommand command = (LBMCommand)this.mCommandQueue.take();
                if (!this.mStopped) {
                    this.mTracer.traceDebug("LBMCommandConsumer executing cmd= " + command.toString());
                    results = command.execute();
                    this.mTracer.traceDebug("LBMCommandConsumer result = " + results);
                    this.mLogBufferModel.updateStatusAfterCommand(results, command);
                    this.mLogBufferModel.reportResultsFromServer(results, command);
                    while (!command.complete()) {
                        this.mTracer.traceInfo("LBMCommandConsumer continues executing cmd= " + command.toString());
                        results = command.continueExecuting();
                        this.mTracer.traceDebug("LBMCommandConsumer continued result = " + results.toString());
                        this.mLogBufferModel.updateStatusAfterCommand(results, command);
                        this.mLogBufferModel.reportResultsFromServer(results, command);
                    }
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interEx) {
            this.mLogger.logWarning("LBMCommand thread was interrupted [" + interEx.getMessage() + "]");
            throw new BAMRuntimeException(this.mTracer.getLocation(), interEx);
        }
    }

    public void stop() {
        this.mStopped = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

