/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application.logbuffer.event;

import com.sapmarkets.bam.application.logbuffer.LogRecordTransporter;
import com.sapmarkets.bam.application.logbuffer.RequestID;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.BAMSysRuntimeException;

public abstract class LBMCommand {
    private RequestID mRequestID;
    private int mNumberOfRecordsRequested;
    private int mRecordsLeft;
    private long mRequestStarttime;
    private boolean mIsInDownwardDirection;
    private BAMRuntimeException mFatalException;
    private boolean mIsTurnaroundCommand;

    public LBMCommand(int numberOfRecordsRequested, boolean isInDownwardDirection) {
        this.setRecordsInitiallyRequested(numberOfRecordsRequested);
        this.setRecordsRemaining(this.mNumberOfRecordsRequested);
        this.init(isInDownwardDirection);
    }

    public LBMCommand(boolean isInDownwardDirection) {
        this.init(isInDownwardDirection);
        this.mIsTurnaroundCommand = true;
    }

    private void init(boolean isInDownwardDirection) {
        this.mRequestID = new RequestID();
        this.mRequestStarttime = System.currentTimeMillis();
        this.mIsInDownwardDirection = isInDownwardDirection;
        this.mFatalException = null;
    }

    public RequestID getRequestId() {
        return this.mRequestID;
    }

    public abstract LogRecordTransporter.TransportedLogQueryResultSet getInitialResults(int var1);

    public abstract LogRecordTransporter.TransportedLogQueryResultSet getContinuedResults(int var1);

    public LogRecordTransporter.TransportedLogQueryResultSet execute() {
        LogRecordTransporter.TransportedLogQueryResultSet result = null;
        try {
            result = this.getInitialResults(this.mNumberOfRecordsRequested);
        }
        catch (BAMRuntimeException ex) {
            this.fatalErrorHappened(ex);
        }
        this.updateStatus(result);
        return result;
    }

    public LogRecordTransporter.TransportedLogQueryResultSet continueExecuting() {
        LogRecordTransporter.TransportedLogQueryResultSet result = null;
        try {
            result = this.getContinuedResults(this.mRecordsLeft);
        }
        catch (BAMSysRuntimeException ex) {
            this.fatalErrorHappened(ex);
        }
        this.updateStatus(result);
        return result;
    }

    public boolean complete() {
        return this.mRecordsLeft == 0;
    }

    public void markAsComplete() {
        this.mRecordsLeft = 0;
    }

    public boolean IsCommandInDownwardDirection() {
        return this.mIsInDownwardDirection;
    }

    public int updateRecordsLeft(int recordsFetched) {
        this.mRecordsLeft -= recordsFetched;
        return this.mRecordsLeft;
    }

    public String toString() {
        long millis = System.currentTimeMillis() - this.mRequestStarttime;
        return "LBMCommand (" + this.mRequestID + ") req: " + this.mNumberOfRecordsRequested + " remain: " + this.mRecordsLeft + " time spent: " + millis + "ms ]";
    }

    public int getRecordsRemaining() {
        return this.mRecordsLeft;
    }

    public int getRecordsInitiallyRequested() {
        return this.mNumberOfRecordsRequested;
    }

    public void setRecordsInitiallyRequested(int recordsRequested) {
        this.mNumberOfRecordsRequested = recordsRequested;
    }

    public void setRecordsRemaining(int recordsLeft) {
        this.mRecordsLeft = recordsLeft;
    }

    public void updateStatus(LogRecordTransporter.TransportedLogQueryResultSet results) {
        if (this.mFatalException == null) {
            if (results == null) {
                throw new IllegalStateException("results are null in LBMCommand.updateStatus");
            }
            this.updateRecordsLeft(results.size());
            if (results.size() <= this.getRecordsInitiallyRequested() && !results.isTimedOut()) {
                this.markAsComplete();
            }
        } else {
            this.markAsComplete();
        }
    }

    public void fatalErrorHappened(BAMRuntimeException ex) {
        this.mFatalException = ex;
    }

    public boolean hasFatalError() {
        return this.mFatalException != null;
    }

    public BAMRuntimeException getFatalException() {
        return this.mFatalException;
    }

    public boolean isTurnaroundCommand() {
        return this.mIsTurnaroundCommand;
    }
}

