/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application.logbuffer;

import com.sap.exception.BaseException;
import com.sapmarkets.bam.application.logbuffer.LogBufferModel;
import com.sapmarkets.bam.application.logbuffer.LogRecordTransporter;
import com.sapmarkets.bam.application.logbuffer.event.EndOfLogEvent;
import com.sapmarkets.bam.application.logbuffer.event.ExceptionsOccuredEvent;
import com.sapmarkets.bam.application.logbuffer.event.LBMCommand;
import com.sapmarkets.bam.application.logbuffer.event.LogBufferModelListener;
import com.sapmarkets.bam.application.logbuffer.event.LogRecordsArrivedEvent;
import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import java.util.Iterator;
import java.util.List;

public class SyncLogBufferModel {
    private static final Logger mLogger = new Logger(class$com$sapmarkets$bam$application$logbuffer$SyncLogBufferModel == null ? (class$com$sapmarkets$bam$application$logbuffer$SyncLogBufferModel = SyncLogBufferModel.class$("com.sapmarkets.bam.application.logbuffer.SyncLogBufferModel")) : class$com$sapmarkets$bam$application$logbuffer$SyncLogBufferModel);
    private static final Tracer mTracer = new Tracer(class$com$sapmarkets$bam$application$logbuffer$SyncLogBufferModel == null ? (class$com$sapmarkets$bam$application$logbuffer$SyncLogBufferModel = SyncLogBufferModel.class$("com.sapmarkets.bam.application.logbuffer.SyncLogBufferModel")) : class$com$sapmarkets$bam$application$logbuffer$SyncLogBufferModel);
    private List mExceptions;
    LogBufferModel mLBM;
    boolean available;
    LogBufferModelListener listener;
    private boolean mEOL;
    public boolean mIsEOLofSync;
    static /* synthetic */ Class class$com$sapmarkets$bam$application$logbuffer$SyncLogBufferModel;

    public SyncLogBufferModel(LogBufferModel lbm) {
        this.mLBM = lbm;
        this.mEOL = false;
        this.mIsEOLofSync = false;
        this.listener = new LogBufferModelListener(){

            public synchronized void handleLogRecordsArrived(LogRecordsArrivedEvent event) {
                mTracer.traceInfo(">>> handle LR  event: " + event);
            }

            public synchronized void handleEndOfLog(EndOfLogEvent event) {
                SyncLogBufferModel.this.mEOL = true;
                mTracer.traceInfo(">>> handleEndOfLog");
            }

            public synchronized void handleProgress(long t) {
                mTracer.traceInfo(">>> handleProgress  rec#=" + t);
                SyncLogBufferModel.this.available = true;
                this.notifyAll();
            }

            public void handleExceptions(ExceptionsOccuredEvent event) {
                mTracer.traceInfo(">>>>>>>>>!!!!!!!!!!!!!!!!! handleExceptions: " + event.toString());
                Iterator i = event.getExceptions().iterator();
                while (i.hasNext()) {
                    BaseException e = (BaseException)i.next();
                    mLogger.logError(e.toString() + ": " + e.getCause());
                }
                SyncLogBufferModel.this.mExceptions = event.getExceptions();
            }

            public void handleFatalError(LogRecordTransporter.TransportedLogQueryResultSet results, LBMCommand command) {
            }
        };
        this.mLBM.addLogBufferModelListener(this.listener);
    }

    public int resetToTop() {
        mTracer.traceInfo(">>> resetToTop");
        this.mExceptions = null;
        LogBufferModelListener logBufferModelListener = this.listener;
        synchronized (logBufferModelListener) {
            this.available = false;
            int result = this.mLBM.resetToTopIndex();
            while (!this.available) {
                try {
                    this.listener.wait();
                    mTracer.traceInfo(">>> resetToTop wait finished");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            int n = result;
            return n;
        }
    }

    public int resetToBottom() {
        mTracer.traceInfo(">>> resetToBottom");
        this.mExceptions = null;
        LogBufferModelListener logBufferModelListener = this.listener;
        synchronized (logBufferModelListener) {
            this.available = false;
            int result = this.mLBM.resetToBottomIndex();
            while (!this.available) {
                try {
                    this.listener.wait();
                    mTracer.traceInfo(">>> resetToBottom wait finished");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            int n = result;
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LogRecord getRecordAt(int i) {
        mTracer.traceInfo(">>> getRecordAt(" + i);
        this.mExceptions = null;
        this.available = false;
        if (this.mEOL && i > this.mLBM.size()) {
            this.mIsEOLofSync = true;
            return null;
        }
        LogRecord result = this.mLBM.getRecordAt(i);
        if (!this.mLBM.isFakeLogRecord(result)) {
            return result;
        }
        LogBufferModelListener logBufferModelListener = this.listener;
        synchronized (logBufferModelListener) {
            while (!this.available) {
                try {
                    this.listener.wait();
                    mTracer.traceInfo(">>> getRecordAt wait finished");
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            return this.mLBM.getRecordAt(i);
        }
    }

    public int size() {
        return this.mLBM.size();
    }

    public List getExceptions() {
        return this.mExceptions;
    }

    public boolean isEOL() {
        return this.mIsEOLofSync;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

