/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application.logbuffer;

import com.sapmarkets.bam.application.logbuffer.LogBufferModel;
import com.sapmarkets.bam.application.logbuffer.LogRecordTransporterLatestToOldest;
import com.sapmarkets.bam.application.logbuffer.LogRecordTransporterOldestToLatest;
import com.sapmarkets.bam.application.logbuffer.event.LBMCommand;
import com.sapmarkets.bam.logcontroller.LogQueryResultset;
import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.LogRecordDefinition;
import com.sapmarkets.bam.logcontroller.QueryResultBrowser;
import com.sapmarkets.bam.util.CircularBuffer;
import java.util.List;

public abstract class LogRecordTransporter {
    private QueryResultBrowser mQueryResultBrowser;
    private CircularBuffer mCircularBuffer;

    public LogRecordTransporter(QueryResultBrowser queryResultBrowser, CircularBuffer circularBuffer) {
        this.mQueryResultBrowser = queryResultBrowser;
        this.mCircularBuffer = circularBuffer;
    }

    protected LogQueryResultset getPrevious(int numberOfLogRecords) {
        return this.mQueryResultBrowser.getPrevious(numberOfLogRecords);
    }

    protected LogQueryResultset getNext(int numberOfLogRecords) {
        return this.mQueryResultBrowser.getNext(numberOfLogRecords);
    }

    protected LogQueryResultset getLatest(int numberOfLogRecords) {
        return this.mQueryResultBrowser.getLatest(numberOfLogRecords);
    }

    protected LogQueryResultset getOldest(int numberOfLogRecords) {
        return this.mQueryResultBrowser.getOldest(numberOfLogRecords);
    }

    public TransportedLogQueryResultSet getUpward(int numberOfLogRecords, boolean addToBuffer) {
        int lastUserIndex;
        int firstUserIndex = lastUserIndex = this.getUserIndexUpward();
        LogQueryResultset result = this.getUpwardResults(numberOfLogRecords);
        if (!addToBuffer) {
            this.mCircularBuffer.informAboutTurnAbout(false);
            return new TransportedLogQueryResultSet(result, firstUserIndex, firstUserIndex - result.size() + 1);
        }
        if (result.size() > 0) {
            int i = 0;
            while (i < result.size()) {
                this.addUpward((LogRecord)result.getResult().get(i));
                ++i;
            }
            firstUserIndex = this.getUserIndexUpward() + 1;
        } else {
            ++firstUserIndex;
            ++lastUserIndex;
        }
        return new TransportedLogQueryResultSet(result, firstUserIndex, lastUserIndex);
    }

    public TransportedLogQueryResultSet getDownward(int numberOfLogRecords, boolean addToBuffer) {
        int firstUserIndex;
        int lastUserIndex = firstUserIndex = this.getUserIndexDownward();
        LogQueryResultset result = this.getDownwardResults(numberOfLogRecords);
        if (!addToBuffer) {
            this.mCircularBuffer.informAboutTurnAbout(true);
            return new TransportedLogQueryResultSet(result, firstUserIndex, firstUserIndex + result.size() + 1);
        }
        if (result.size() > 0) {
            int i = 0;
            while (i < result.size()) {
                this.addDownward((LogRecord)result.getResult().get(i));
                ++i;
            }
            lastUserIndex = this.getUserIndexDownward() - 1;
        } else {
            --lastUserIndex;
            --firstUserIndex;
        }
        return new TransportedLogQueryResultSet(result, firstUserIndex, lastUserIndex);
    }

    public TransportedLogQueryResultSet getTop(int numberOfLogRecords) {
        int firstUserIndex;
        int lastUserIndex = firstUserIndex = this.getUserIndexDownward();
        LogQueryResultset result = this.getTopResults(numberOfLogRecords);
        if (result.size() > 0) {
            int i = 0;
            while (i < result.size()) {
                this.addDownward((LogRecord)result.getResult().get(i));
                ++i;
            }
            lastUserIndex = this.getUserIndexDownward() - 1;
        }
        return new TransportedLogQueryResultSet(result, firstUserIndex, lastUserIndex);
    }

    TransportedLogQueryResultSet getBottom(int numberOfLogRecords) {
        int firstUserIndex;
        int lastUserIndex = firstUserIndex = this.getUserIndexUpward();
        LogQueryResultset result = this.getBottomResults(numberOfLogRecords);
        if (result.size() > 0) {
            int i = 0;
            while (i < result.size()) {
                this.addUpward((LogRecord)result.getResult().get(i));
                ++i;
            }
            lastUserIndex = this.getUserIndexUpward() + 1;
        }
        return new TransportedLogQueryResultSet(result, firstUserIndex, lastUserIndex);
    }

    abstract LogQueryResultset getUpwardResults(int var1);

    abstract LogQueryResultset getDownwardResults(int var1);

    abstract LogQueryResultset getTopResults(int var1);

    abstract LogQueryResultset getBottomResults(int var1);

    void addDownward(LogRecord aLogRecord) {
        this.mCircularBuffer.addToTail(aLogRecord);
    }

    void addUpward(LogRecord aLogRecord) {
        this.mCircularBuffer.addToHead(aLogRecord);
    }

    int getUserIndexUpward() {
        return this.mCircularBuffer.getHeadUserIndex();
    }

    int getUserIndexDownward() {
        return this.mCircularBuffer.getTailUserIndex();
    }

    public static LogRecordTransporter getInstance(LogBufferModel.Orientation orientation, QueryResultBrowser queryResultBrowser, CircularBuffer circularBuffer) {
        if (orientation.equals(LogBufferModel.Orientation.OLDEST_TO_LATEST)) {
            return new LogRecordTransporterOldestToLatest(queryResultBrowser, circularBuffer);
        }
        return new LogRecordTransporterLatestToOldest(queryResultBrowser, circularBuffer);
    }

    public class TransportedLogQueryResultSet {
        private int mUserIndexOfFirstRecord;
        private int mUserIndexOfLastRecord;
        private LogQueryResultset mLogQueryResultset;
        private long mTotalRecordsRead;

        TransportedLogQueryResultSet(LogQueryResultset results, int firstUserIndex, int lastLastUserIndex) {
            this.mLogQueryResultset = results;
            this.mUserIndexOfFirstRecord = firstUserIndex;
            this.mUserIndexOfLastRecord = lastLastUserIndex;
            this.mTotalRecordsRead = results.getCounterOfRecordsRead();
        }

        public List getResult() {
            return this.mLogQueryResultset.getResult();
        }

        public List getExceptionsDuringReading() {
            return this.mLogQueryResultset.getExceptionsDuringReading();
        }

        public LogRecordDefinition getLogRecordDefinition() {
            return this.mLogQueryResultset.getLogRecordDefinition();
        }

        public boolean hadExceptionsDuringReading() {
            return this.mLogQueryResultset.hadExceptionsDuringReading();
        }

        public int size() {
            return this.mLogQueryResultset.size();
        }

        public boolean isTimedOut() {
            return this.mLogQueryResultset.isTimedOut();
        }

        public int getMUserIndexOfFirstRecord() {
            return this.mUserIndexOfFirstRecord;
        }

        public int getMUserIndexOfLastRecord() {
            return this.mUserIndexOfLastRecord;
        }

        public boolean isEndOfLog(LBMCommand command) {
            return this.size() < command.getRecordsInitiallyRequested() && !this.isTimedOut();
        }

        public String toString() {
            return "TransportedLogQueryResultSet with " + this.size() + " records. user index = [" + this.getMUserIndexOfFirstRecord() + ", " + this.getMUserIndexOfLastRecord() + "] timeout=" + this.isTimedOut() + " exceptions=" + this.getExceptionsDuringReading();
        }

        public long getNumberOfTotalRecordsRead() {
            return this.mTotalRecordsRead;
        }
    }
}

