/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application.logbuffer;

import com.sap.engine.lib.util.concurrent.Channel;
import com.sapmarkets.bam.application.QueryResultBrowserFactory;
import com.sapmarkets.bam.application.logbuffer.LogRecordTransporter;
import com.sapmarkets.bam.application.logbuffer.event.EndOfLogEvent;
import com.sapmarkets.bam.application.logbuffer.event.ExceptionsOccuredEvent;
import com.sapmarkets.bam.application.logbuffer.event.LBMCommand;
import com.sapmarkets.bam.application.logbuffer.event.LBMRequestController;
import com.sapmarkets.bam.application.logbuffer.event.LogBufferModelListener;
import com.sapmarkets.bam.application.logbuffer.event.LogRecordsArrivedEvent;
import com.sapmarkets.bam.logcontroller.DownloadSpecs;
import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.LogRecordDefinition;
import com.sapmarkets.bam.logcontroller.MonitoredData;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.logcontroller.QueryResultBrowser;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.CircularBuffer;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.SUID;
import com.sapmarkets.bam.util.Tracer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class LogBufferModel {
    private boolean mResetDone;
    private final Orientation mOrientation;
    private QueryResultBrowser mQueryResultBrowser;
    public static final int INITIAL_SIZE = 200;
    public static final int GROW_SIZE = 200;
    public static final int TOTAL_SIZE = 1000;
    private int mRequestedStartUserIndex;
    private int mRequestedEndUserIndex;
    private static final Tracer mTracer = new Tracer(class$com$sapmarkets$bam$application$logbuffer$LogBufferModel == null ? (class$com$sapmarkets$bam$application$logbuffer$LogBufferModel = LogBufferModel.class$("com.sapmarkets.bam.application.logbuffer.LogBufferModel")) : class$com$sapmarkets$bam$application$logbuffer$LogBufferModel);
    private static final Logger mLogger = new Logger(class$com$sapmarkets$bam$application$logbuffer$LogBufferModel == null ? (class$com$sapmarkets$bam$application$logbuffer$LogBufferModel = LogBufferModel.class$("com.sapmarkets.bam.application.logbuffer.LogBufferModel")) : class$com$sapmarkets$bam$application$logbuffer$LogBufferModel);
    private Channel mRequestQueue;
    private CircularBuffer mCircularBuffer;
    private LogRecordTransporter mLogRecordTransporter;
    private boolean mCancelAllRequests = false;
    private LogRecord FAKE_LOG_RECORD = null;
    private LogBufferModelListener mLogBufferModelListener;
    private LBMRequestController mLBMRequestController;
    static /* synthetic */ Class class$com$sapmarkets$bam$application$logbuffer$LogBufferModel;

    public LogBufferModel(QueryResultBrowser queryResultBrowser, Orientation orientation) {
        this(new CircularBuffer(1000), queryResultBrowser, orientation);
    }

    public LogBufferModel(CircularBuffer buf, QueryResultBrowser queryResultBrowser, Orientation orientation) {
        mTracer.traceDebug("New LBM with buffer size " + buf.size() + " QRB=" + queryResultBrowser + " Orientation=" + orientation);
        this.mQueryResultBrowser = queryResultBrowser;
        this.mOrientation = orientation;
        this.mLBMRequestController = new LBMRequestController();
        this.mRequestQueue = this.mLBMRequestController.getCommandQueueForLBM(this);
        this.mCircularBuffer = buf;
        this.mLogRecordTransporter = LogRecordTransporter.getInstance(orientation, queryResultBrowser, this.mCircularBuffer);
        this.mRequestedEndUserIndex = -1;
        this.mRequestedStartUserIndex = -1;
        this.mResetDone = true;
        this.FAKE_LOG_RECORD = new LogRecord(this.createMonitoredData(), this.getLogRecordDefinition());
    }

    private List createMonitoredData() {
        ArrayList<MonitoredData> monitoredData = new ArrayList<MonitoredData>();
        Iterator itr = this.getLogRecordDefinition().getMonitoredDataDefinitions().iterator();
        while (itr.hasNext()) {
            MonitoredDataDefinition mdd = (MonitoredDataDefinition)itr.next();
            MonitoredData md = new MonitoredData("", mdd);
            monitoredData.add(md);
        }
        return monitoredData;
    }

    public LogBufferModel(List logDescriptors, LogQueryExpression logQueryExpression, Orientation orientation, DownloadSpecs downloadSpecs) throws BAMAppException {
        this(QueryResultBrowserFactory.getQueryResultBrowser(logDescriptors, logQueryExpression, downloadSpecs), orientation);
    }

    public LogBufferModel(List logDescriptors, LogQueryExpression logQueryExpression, Orientation orientation) throws BAMAppException {
        this(QueryResultBrowserFactory.getQueryResultBrowser(logDescriptors, logQueryExpression, new DownloadSpecs(0L, false)), orientation);
    }

    public void addLogBufferModelListener(LogBufferModelListener logBufferModelListener) {
        this.mLogBufferModelListener = logBufferModelListener;
    }

    public void removeListener(LogBufferModelListener logBufferModelListener) {
        this.mLogBufferModelListener = null;
    }

    public void removeAllListeners() {
        this.mLogBufferModelListener = null;
    }

    public int resetToTopIndex() {
        try {
            this.flushRequestQueue();
            this.mCircularBuffer.empty();
            this.mRequestedStartUserIndex = this.mCircularBuffer.getTailUserIndex();
            this.mRequestedEndUserIndex = this.mRequestedStartUserIndex + 200 - 1;
            LBMCommand l = new LBMCommand(200, false){

                public LogRecordTransporter.TransportedLogQueryResultSet getInitialResults(int size) {
                    LogRecordTransporter.TransportedLogQueryResultSet results = LogBufferModel.this.mLogRecordTransporter.getTop(size);
                    return results;
                }

                public LogRecordTransporter.TransportedLogQueryResultSet getContinuedResults(int size) {
                    LogRecordTransporter.TransportedLogQueryResultSet results = LogBufferModel.this.mLogRecordTransporter.getDownward(size, true);
                    return results;
                }
            };
            this.mRequestQueue.put((Object)l);
            this.mResetDone = true;
            mTracer.traceInfo("resetToTopIndex: new command " + l + " LBM=" + this.toString());
        }
        catch (InterruptedException e) {
            mLogger.logWarning("There was a problem while putting comands on the RequestQueue");
        }
        return 0;
    }

    public int resetToBottomIndex() {
        try {
            this.flushRequestQueue();
            this.mCircularBuffer.empty();
            this.mRequestedStartUserIndex = this.mCircularBuffer.getTailUserIndex();
            this.mRequestedEndUserIndex = this.mRequestedStartUserIndex - 200;
            LBMCommand l = new LBMCommand(200, true){

                public LogRecordTransporter.TransportedLogQueryResultSet getInitialResults(int size) {
                    LogRecordTransporter.TransportedLogQueryResultSet results = LogBufferModel.this.mLogRecordTransporter.getBottom(size);
                    return results;
                }

                public LogRecordTransporter.TransportedLogQueryResultSet getContinuedResults(int size) {
                    LogRecordTransporter.TransportedLogQueryResultSet results = LogBufferModel.this.mLogRecordTransporter.getUpward(size, true);
                    return results;
                }
            };
            this.mRequestQueue.put((Object)l);
            this.mResetDone = true;
            mTracer.traceInfo("resetToBottomIndex: new command " + l + " LBM=" + this.toString());
        }
        catch (InterruptedException e) {
            mLogger.logWarning("There was a problem while putting comands on the RequestQueue (" + e.getMessage() + ")");
        }
        return -1;
    }

    public void flushRequestQueue() {
        try {
            while (this.mRequestQueue.poll(0L) != null) {
            }
        }
        catch (InterruptedException exception) {
            mLogger.logWarning("LBMCommand thread was interrupted [" + exception.getMessage() + "]");
        }
    }

    public int nextLowerIndex(int index) {
        return index + 1;
    }

    public int nextLowerIndex(int index, int offset) {
        return index + offset;
    }

    public int nextHigherIndex(int index) {
        return index - 1;
    }

    public boolean indexLowerThan(int firstIndex, int secondIndex) {
        return firstIndex > secondIndex;
    }

    public boolean indexHigherThan(int firstIndex, int secondIndex) {
        return firstIndex < secondIndex;
    }

    public int nextHigherIndex(int index, int offset) {
        return index - offset;
    }

    public LogRecord getRecordAt(int requestedIdx) throws IllegalStateException {
        if (!this.mResetDone) {
            throw new IllegalStateException("resetTop/Bottom method has not been called! [mRequestedStartUserIndex=" + this.mRequestedStartUserIndex + ", mRequestedEndUserIndex=" + this.mRequestedEndUserIndex);
        }
        if (requestedIdx < this.mCircularBuffer.getTailUserIndex() && requestedIdx > this.mCircularBuffer.getTailUserIndex() - 1 - this.mCircularBuffer.size() || requestedIdx > this.mCircularBuffer.getHeadUserIndex() && requestedIdx < this.mCircularBuffer.getHeadUserIndex() + 1 + this.mCircularBuffer.size()) {
            return (LogRecord)this.mCircularBuffer.get(requestedIdx);
        }
        if (requestedIdx >= this.mCircularBuffer.getTailUserIndex() && requestedIdx > this.mRequestedEndUserIndex) {
            mTracer.traceDebug("LBM [DOWN] GetRecordAt (" + requestedIdx + ") " + this.toString());
            int nrRecordsNeeded = 200 + Math.abs(requestedIdx - this.getLowestUserindexInBuffer());
            this.mRequestedStartUserIndex = this.mCircularBuffer.getTailUserIndex();
            this.mRequestedEndUserIndex += nrRecordsNeeded - 1;
            if (this.mCircularBuffer.getFilePointerUserIndex() == this.mCircularBuffer.getHeadUserIndex()) {
                this.mRequestedStartUserIndex = this.mCircularBuffer.getTailUserIndex();
                this.mRequestedEndUserIndex = this.mRequestedStartUserIndex + nrRecordsNeeded - 1;
                this.putTurnAroundDownLBMCommand();
            }
            this.putDownLBMCommand(nrRecordsNeeded);
            return this.FAKE_LOG_RECORD;
        }
        if (requestedIdx <= this.mCircularBuffer.getHeadUserIndex() && requestedIdx < this.mRequestedEndUserIndex) {
            String statusBefore = "LBM [UP] GetRecordAt (" + requestedIdx + ") " + this.toString();
            int nrRecordsNeeded = 200 + Math.abs(requestedIdx - this.getHighestUserindexInBuffer());
            this.mRequestedStartUserIndex = this.mCircularBuffer.getHeadUserIndex();
            this.mRequestedEndUserIndex -= nrRecordsNeeded;
            if (this.mCircularBuffer.getFilePointerUserIndex() == this.mCircularBuffer.getTailUserIndex()) {
                this.mRequestedStartUserIndex = this.mCircularBuffer.getHeadUserIndex();
                this.mRequestedEndUserIndex = this.mRequestedStartUserIndex - nrRecordsNeeded;
                this.putTurnAroundUpLBMCommand();
            }
            this.putUpLBMCommand(nrRecordsNeeded);
            mTracer.traceDebug(statusBefore + " RQ after put command=[" + this.mRequestedStartUserIndex + ", " + this.mRequestedEndUserIndex + "]");
            return this.FAKE_LOG_RECORD;
        }
        if (this.mRequestedEndUserIndex > this.mRequestedStartUserIndex && requestedIdx >= this.mRequestedStartUserIndex && requestedIdx <= this.mRequestedEndUserIndex || this.mRequestedEndUserIndex < this.mRequestedStartUserIndex && requestedIdx <= this.mRequestedStartUserIndex && requestedIdx >= this.mRequestedEndUserIndex || this.mRequestedEndUserIndex == this.mRequestedStartUserIndex) {
            return this.FAKE_LOG_RECORD;
        }
        mLogger.logError("LBM.getRecordAt (" + requestedIdx + ") does not have the record in buffer and does not issue command! LBM=" + this.toString());
        throw new IllegalStateException("getRecordAt (" + requestedIdx + ") does nothing! LBM=" + this.toString());
    }

    private void putDownLBMCommand(int growSize) {
        try {
            LBMCommand newcommand = new LBMCommand(growSize, true){

                public LogRecordTransporter.TransportedLogQueryResultSet getInitialResults(int size) {
                    LogRecordTransporter.TransportedLogQueryResultSet results = LogBufferModel.this.mLogRecordTransporter.getDownward(size, true);
                    return results;
                }

                public LogRecordTransporter.TransportedLogQueryResultSet getContinuedResults(int size) {
                    LogRecordTransporter.TransportedLogQueryResultSet results = LogBufferModel.this.mLogRecordTransporter.getDownward(size, true);
                    return results;
                }
            };
            this.mRequestQueue.put((Object)newcommand);
            mTracer.traceInfo("LBM: New Down Command " + newcommand + " LBM: " + this.toString());
        }
        catch (InterruptedException e) {
            mLogger.logWarning("There was a problem while putting comands on the RequestQueue [" + e + "]");
        }
    }

    private void putTurnAroundDownLBMCommand() {
        try {
            LBMCommand newcommand = new LBMCommand(true){

                public LogRecordTransporter.TransportedLogQueryResultSet getInitialResults(int size_notneeded) {
                    this.setRecordsInitiallyRequested(LogBufferModel.this.mCircularBuffer.size());
                    this.setRecordsRemaining(LogBufferModel.this.mCircularBuffer.size());
                    LogRecordTransporter.TransportedLogQueryResultSet results = LogBufferModel.this.mLogRecordTransporter.getDownward(this.getRecordsRemaining(), false);
                    this.updateRecordsLeft(results.size());
                    return results;
                }

                public LogRecordTransporter.TransportedLogQueryResultSet getContinuedResults(int size_notneeded) {
                    LogRecordTransporter.TransportedLogQueryResultSet results = LogBufferModel.this.mLogRecordTransporter.getDownward(this.getRecordsRemaining(), false);
                    this.updateRecordsLeft(results.size());
                    return results;
                }

                public void reportResultsFromServer(LogRecordTransporter.TransportedLogQueryResultSet results, LBMCommand command) {
                }
            };
            this.mRequestQueue.put((Object)newcommand);
            mTracer.traceInfo("LBM: New turnaround DOWN command added " + newcommand + " (size=0 because determined at execute() LBM: " + this.toString());
        }
        catch (InterruptedException e) {
            mLogger.logWarning("There was a problem while putting comands on the RequestQueue [" + e + "]");
        }
    }

    private void putUpLBMCommand(int growSize) {
        try {
            LBMCommand newcommand = new LBMCommand(growSize, false){

                public LogRecordTransporter.TransportedLogQueryResultSet getInitialResults(int size) {
                    LogRecordTransporter.TransportedLogQueryResultSet results = LogBufferModel.this.mLogRecordTransporter.getUpward(size, true);
                    return results;
                }

                public LogRecordTransporter.TransportedLogQueryResultSet getContinuedResults(int size) {
                    LogRecordTransporter.TransportedLogQueryResultSet results = LogBufferModel.this.mLogRecordTransporter.getUpward(size, true);
                    return results;
                }
            };
            this.mRequestQueue.put((Object)newcommand);
            mTracer.traceInfo("LBM: New UP Command " + newcommand + " LBM: " + this.toString());
        }
        catch (InterruptedException e) {
            mLogger.logWarning("There was a problem while putting comands on the RequestQueue [" + e + "]");
        }
    }

    private void putTurnAroundUpLBMCommand() {
        try {
            LBMCommand newcommand = new LBMCommand(false){

                public LogRecordTransporter.TransportedLogQueryResultSet getInitialResults(int size_notneeded) {
                    this.setRecordsInitiallyRequested(LogBufferModel.this.mCircularBuffer.size());
                    this.setRecordsRemaining(LogBufferModel.this.mCircularBuffer.size());
                    LogRecordTransporter.TransportedLogQueryResultSet results = LogBufferModel.this.mLogRecordTransporter.getUpward(this.getRecordsRemaining(), false);
                    this.updateRecordsLeft(results.size());
                    return results;
                }

                public LogRecordTransporter.TransportedLogQueryResultSet getContinuedResults(int size_notneeded) {
                    LogRecordTransporter.TransportedLogQueryResultSet results = LogBufferModel.this.mLogRecordTransporter.getUpward(this.getRecordsRemaining(), false);
                    this.updateRecordsLeft(results.size());
                    return results;
                }

                public void reportResultsFromServer(LogRecordTransporter.TransportedLogQueryResultSet results, LBMCommand command) {
                }
            };
            this.mRequestQueue.put((Object)newcommand);
            mTracer.traceInfo("LBM: New turnaround UP command added " + newcommand + " (size=0 because determined at execute() LBM: " + this.toString());
        }
        catch (InterruptedException e) {
            mLogger.logWarning("There was a problem while putting comands on the RequestQueue [" + e + "]");
        }
    }

    public Orientation getOrientation() {
        return this.mOrientation;
    }

    public int getHighestUserindexInBuffer() {
        return this.mCircularBuffer.getHeadUserIndex() + 1;
    }

    public int getLowestUserindexInBuffer() {
        return this.mCircularBuffer.getTailUserIndex() - 1;
    }

    public boolean contains(int index) {
        if (this.mCircularBuffer.size() > 0) {
            if (this.getLowestUserindexInBuffer() < this.getHighestUserindexInBuffer()) {
                return index < this.getHighestUserindexInBuffer() && index > this.getLowestUserindexInBuffer();
            }
            if (this.getLowestUserindexInBuffer() > this.getHighestUserindexInBuffer()) {
                return index > this.getHighestUserindexInBuffer() && index < this.getLowestUserindexInBuffer();
            }
        }
        return false;
    }

    public int contains(LogRecord lr) {
        if (lr != null && this.mCircularBuffer.size() > 0) {
            int start = 0;
            int end = 0;
            if (this.getLowestUserindexInBuffer() < this.getHighestUserindexInBuffer()) {
                start = this.getLowestUserindexInBuffer() - 1;
                end = this.getHighestUserindexInBuffer() + 1;
            } else if (this.getLowestUserindexInBuffer() > this.getHighestUserindexInBuffer()) {
                end = this.getLowestUserindexInBuffer() - 1;
                start = this.getHighestUserindexInBuffer() + 1;
            } else {
                throw new IllegalStateException("Buffer size==0 but tailindex == headindex!");
            }
            int i = start;
            while (i < end && !this.mCircularBuffer.get(i).equals(lr)) {
                ++i;
            }
            if (i < end) {
                return i;
            }
        }
        return Integer.MIN_VALUE;
    }

    public void cancelAllrequests() {
        mTracer.traceDebug("LBM cancelAllrequests");
        this.mCancelAllRequests = true;
    }

    private void reportLRArrived(LogRecordTransporter.TransportedLogQueryResultSet r) {
        if (this.mLogBufferModelListener != null) {
            mTracer.traceDebug("LBM handleLogRecordsArrived event");
            this.mLogBufferModelListener.handleLogRecordsArrived(new LogRecordsArrivedEvent(r, r.getMUserIndexOfFirstRecord(), r.getMUserIndexOfLastRecord()));
        }
    }

    private void reportProgress(LogRecordTransporter.TransportedLogQueryResultSet r) {
        if (this.mLogBufferModelListener != null) {
            mTracer.traceDebug("LBM handleProgress event");
            this.mLogBufferModelListener.handleProgress(r != null ? r.getNumberOfTotalRecordsRead() : 0L);
        }
    }

    private void reportEOL(LogRecordTransporter.TransportedLogQueryResultSet r, boolean isEndAtBottom) {
        if (this.mLogBufferModelListener != null) {
            mTracer.traceDebug("LBM handleEndOfLog event (1st=" + r.getMUserIndexOfFirstRecord() + ", last=" + r.getMUserIndexOfLastRecord() + ")");
            this.mLogBufferModelListener.handleEndOfLog(new EndOfLogEvent(r.getMUserIndexOfFirstRecord(), r.getMUserIndexOfLastRecord(), isEndAtBottom));
        }
    }

    private void reportExceptions(LogRecordTransporter.TransportedLogQueryResultSet r) {
        if (this.mLogBufferModelListener != null) {
            mTracer.traceDebug("LBM handleExceptions event");
            this.mLogBufferModelListener.handleExceptions(new ExceptionsOccuredEvent(r.getExceptionsDuringReading()));
        }
    }

    public void updateStatusAfterCommand(LogRecordTransporter.TransportedLogQueryResultSet results, LBMCommand command) {
        if (!command.isTurnaroundCommand()) {
            this.mRequestedStartUserIndex = !command.complete() ? this.mCircularBuffer.calculateRequestedStartUserindex(this.mRequestedStartUserIndex, results.size()) : (this.mCircularBuffer.isLastAddedAtTail() ? this.getLowestUserindexInBuffer() : this.getHighestUserindexInBuffer());
        }
        if (results != null && results.isEndOfLog(command)) {
            this.mRequestedEndUserIndex = this.mCircularBuffer.isLastAddedAtTail() ? this.getLowestUserindexInBuffer() : this.getHighestUserindexInBuffer();
            this.mRequestedStartUserIndex = this.mRequestedEndUserIndex;
        }
        if (this.mCancelAllRequests) {
            this.mCancelAllRequests = false;
        }
    }

    public void reportResultsFromServer(LogRecordTransporter.TransportedLogQueryResultSet results, LBMCommand command) {
        if (results == null || command.hasFatalError()) {
            this.reportCommandCrash(results, command);
        } else {
            if (results.size() > 0) {
                this.reportLRArrived(results);
            }
            if (results.hadExceptionsDuringReading()) {
                this.reportExceptions(results);
            }
            if (results.isEndOfLog(command)) {
                this.reportEOL(results, command.IsCommandInDownwardDirection());
            }
        }
        this.reportProgress(results);
    }

    private void reportExceptions(BAMRuntimeException fatalException) {
        if (this.mLogBufferModelListener != null) {
            mTracer.traceDebug("LBM handleExceptions event");
            this.mLogBufferModelListener.handleExceptions(new ExceptionsOccuredEvent(Arrays.asList(new Object[]{fatalException})));
        }
    }

    private void reportCommandCrash(LogRecordTransporter.TransportedLogQueryResultSet results, LBMCommand command) {
        this.mLogBufferModelListener.handleFatalError(results, command);
    }

    public LogRecord getFakeLogRecord() {
        return this.FAKE_LOG_RECORD;
    }

    public boolean isFakeLogRecord(LogRecord r) {
        return this.FAKE_LOG_RECORD == r;
    }

    public LogRecordDefinition getLogRecordDefinition() {
        return this.mQueryResultBrowser.getLogRecordDefinition();
    }

    public int size() {
        return this.mCircularBuffer.size();
    }

    public String toString() {
        return " Requested Start/End=[" + this.mRequestedStartUserIndex + ", " + this.mRequestedEndUserIndex + "] " + this.mCircularBuffer + " orientation=" + this.mOrientation.toString();
    }

    public void close() {
        this.mQueryResultBrowser.close();
        this.mLBMRequestController.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Orientation {
        public static final long serialVersionUID = SUID.getID();
        public static final Orientation OLDEST_TO_LATEST = new Orientation(true);
        public static final Orientation LATEST_TO_OLDEST = new Orientation(false);
        private final boolean mOrientation;

        public Orientation(boolean orientation) {
            this.mOrientation = orientation;
        }

        public String toString() {
            return this.mOrientation ? "OLDEST_TO_LATEST" : "LATEST_TO_OLDEST";
        }

        public boolean getOrientation() {
            return this.mOrientation;
        }

        public boolean equals(Object obj) {
            Orientation orientation;
            if (this == obj) {
                return true;
            }
            return obj != null && this.getClass() == obj.getClass() && this.mOrientation == (orientation = (Orientation)obj).getOrientation();
        }

        public int hashCode() {
            return 77964 + (this.mOrientation ? 0 : 1);
        }
    }
}

