/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application;

import com.sapmarkets.bam.application.LinkedListCell;
import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.LogRecordComparator;
import com.sapmarkets.bam.logcontroller.MonitoredData;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SATRecordOrganizer {
    private List mOrganizedSATRecords = new ArrayList();
    private List mOrphanList = new ArrayList();
    private LinkedListCell lastAddedCell;

    public List organize(List unOrganizedSATRecords) throws ParseException {
        Collections.sort(unOrganizedSATRecords, new LogRecordComparator());
        LinkedListCell rootNode = new LinkedListCell("");
        Integer integer = new Integer(0);
        String dsrTransactionId = "0";
        String sessionId = "0";
        int recordCoutner = 0;
        while (recordCoutner < unOrganizedSATRecords.size()) {
            LogRecord lr = (LogRecord)unOrganizedSATRecords.get(recordCoutner);
            int tempRecType = Integer.parseInt(lr.getMonitoredData("rectype").getValue().toString());
            if (lr.getMonitoredData("rectype").getValue() == null || lr.getMonitoredData("rectype").getValue().equals("")) {
                this.handleNonSATRecord(lr);
            } else {
                LinkedListCell llRequest;
                LinkedListCell llTransaction;
                LinkedListCell llSession;
                int recType;
                String threadId = lr.getMonitoredData("thread").getValue().toString();
                MonitoredData md = lr.getMonitoredData("dsrTransaction");
                if (md.getValue() != null && md.getValue().toString().equals("")) {
                    dsrTransactionId = md.getValue().toString();
                }
                if ((md = lr.getMonitoredData("sessionId")).getValue() != null && md.getValue().toString().equals("")) {
                    sessionId = md.getValue().toString();
                }
                if ((recType = Integer.parseInt(lr.getMonitoredData("rectype").getValue().toString())) == 10) {
                    if (rootNode.getCell(dsrTransactionId) == null) {
                        LinkedListCell transaction = new LinkedListCell(dsrTransactionId);
                        llSession = new LinkedListCell(sessionId);
                        this.lastAddedCell = new LinkedListCell(lr, threadId, recType);
                        llSession.addSubRecords(this.lastAddedCell);
                        transaction.addSubRecords(llSession);
                        rootNode.addSubRecords(transaction);
                    } else {
                        llTransaction = rootNode.getCell(dsrTransactionId);
                        llSession = llTransaction.getCell(sessionId);
                        if (llSession == null) {
                            llSession = new LinkedListCell(sessionId);
                            this.lastAddedCell = new LinkedListCell(lr, threadId, recType);
                            llSession.addSubRecords(this.lastAddedCell);
                            llTransaction.addSubRecords(llSession);
                        } else {
                            this.lastAddedCell = new LinkedListCell(lr, threadId, recType);
                            llSession.addSubRecords(this.lastAddedCell);
                        }
                    }
                } else if (recType == 11) {
                    llTransaction = rootNode.getCell(dsrTransactionId);
                    if (llTransaction == null) {
                        this.mOrphanList.add(lr);
                    } else {
                        llSession = llTransaction.getCell(sessionId);
                        if (llSession == null) {
                            this.mOrphanList.add(lr);
                        } else {
                            llRequest = llSession.getLastCell(threadId);
                            if (llRequest == null) {
                                this.mOrphanList.add(lr);
                            } else {
                                this.lastAddedCell = new LinkedListCell(lr, threadId, recType);
                                llRequest.addSubRecords(this.lastAddedCell);
                            }
                        }
                    }
                } else if (recType == 12) {
                    llTransaction = rootNode.getCell(dsrTransactionId);
                    if (llTransaction == null) {
                        this.mOrphanList.add(lr);
                    } else {
                        llSession = llTransaction.getCell(sessionId);
                        if (llSession == null) {
                            this.mOrphanList.add(lr);
                        } else {
                            llRequest = llSession.getLastCell(threadId);
                            if (llRequest == null) {
                                this.mOrphanList.add(lr);
                            } else {
                                List components = llRequest.getSubRecords();
                                LinkedListCell llCellComponent = (LinkedListCell)components.get(components.size() - 1);
                                this.lastAddedCell = new LinkedListCell(lr, threadId, recType);
                                llCellComponent.addSubRecords(this.lastAddedCell);
                            }
                        }
                    }
                }
            }
            ++recordCoutner;
        }
        this.mOrganizedSATRecords = this.flattenTheTree(rootNode);
        this.mOrganizedSATRecords.addAll(this.mOrphanList);
        return this.mOrganizedSATRecords;
    }

    private List flattenTheTree(LinkedListCell theRootNode) {
        ArrayList<LogRecord> organizedRecords = new ArrayList<LogRecord>();
        List transactions = theRootNode.getSubRecords();
        Iterator iterTransactions = transactions.iterator();
        while (iterTransactions.hasNext()) {
            List sessions = ((LinkedListCell)iterTransactions.next()).getSubRecords();
            Iterator iterSessions = sessions.iterator();
            while (iterSessions.hasNext()) {
                List requests = ((LinkedListCell)iterSessions.next()).getSubRecords();
                Iterator iterRequests = requests.iterator();
                while (iterRequests.hasNext()) {
                    LinkedListCell llRequest = (LinkedListCell)iterRequests.next();
                    organizedRecords.add(llRequest.getLogRecord());
                    Iterator iterComponents = llRequest.getSubRecords().iterator();
                    while (iterComponents.hasNext()) {
                        LinkedListCell llComponent = (LinkedListCell)iterComponents.next();
                        organizedRecords.add(llComponent.getLogRecord());
                        Iterator iterActions = llComponent.getSubRecords().iterator();
                        while (iterActions.hasNext()) {
                            LinkedListCell llCellAction = (LinkedListCell)iterActions.next();
                            organizedRecords.add(llCellAction.getLogRecord());
                            Iterator iterNonSATRecord = llCellAction.getSubRecords().iterator();
                            while (iterNonSATRecord.hasNext()) {
                                LinkedListCell nonSATRecord = (LinkedListCell)iterNonSATRecord.next();
                                organizedRecords.add(nonSATRecord.getLogRecord());
                            }
                        }
                    }
                }
            }
        }
        return organizedRecords;
    }

    private void handleNonSATRecord(LogRecord lr) {
        if (this.lastAddedCell != null) {
            this.lastAddedCell.addSubRecords(new LinkedListCell(lr, "", 0));
            this.lastAddedCell = null;
        } else {
            this.mOrphanList.add(lr);
        }
    }
}

