/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application;

import com.sapmarkets.bam.application.RecordSource;
import com.sapmarkets.bam.logcontroller.LogQueryResultset;
import com.sapmarkets.bam.logcontroller.LogRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class RecordBuffer {
    public static final int LATEST = 0;
    public static final int OLDEST = 1;
    public static final int NEXT = 2;
    public static final int PREVIOUS = 3;
    private static final int mBufferSize = 50;
    private RecordSource recordSource;
    private List someLogRecords;
    private int mPointer;
    private List caughtExceptions;
    private long counter;
    private boolean isTimedOut = false;
    private int lastPointer;
    private int mDirection;
    private boolean latestEOF;
    private boolean oldestEOF;
    private int lastCall;
    private int lastCallSize;
    private LogRecord oldLogRecord;

    public RecordBuffer(RecordSource recordSource, int startDirection) {
        this.recordSource = recordSource;
        this.mDirection = startDirection;
        this.oldLogRecord = null;
        this.latestEOF = false;
        this.oldestEOF = false;
        this.lastCall = 99;
        this.lastCallSize = -1;
        this.lastPointer = -1;
        this.caughtExceptions = new ArrayList();
        this.counter = 0L;
        this.isTimedOut = false;
        this.fillBuffer();
    }

    public void setDirection(int direction) {
        if (this.mDirection == 2 && direction == 3) {
            if (this.lastPointer != -1 && this.lastPointer < this.someLogRecords.size()) {
                this.mPointer = this.lastPointer;
            } else {
                this.mDirection = direction;
                this.fillBuffer();
            }
        } else if (this.mDirection == 3 && direction == 2) {
            if (this.lastPointer != -1) {
                this.mPointer = this.lastPointer;
            } else {
                this.mDirection = direction;
                this.fillBuffer();
            }
        }
        if (this.isTimedOut && (this.someLogRecords == null || this.someLogRecords.size() == 0)) {
            this.fillBuffer();
        }
        this.mDirection = direction;
    }

    public LogRecord getNext() {
        LogRecord lr = null;
        if (this.someLogRecords != null && this.mPointer >= 0 && this.mPointer < this.someLogRecords.size()) {
            this.oldLogRecord = lr = (LogRecord)this.someLogRecords.get(this.mPointer);
        }
        return lr;
    }

    public LogRecord getPrevious() {
        LogRecord lr = null;
        if (this.someLogRecords != null && this.mPointer >= 0 && this.mPointer < this.someLogRecords.size()) {
            this.oldLogRecord = lr = (LogRecord)this.someLogRecords.get(this.mPointer);
        }
        return lr;
    }

    public void resetBufferPointer(LogRecord chosenLR) {
        if (chosenLR == this.oldLogRecord) {
            this.lastPointer = this.mPointer++;
            if (this.mDirection != 2) {
                --this.mPointer;
            }
            this.checkBuffer();
        }
    }

    private List tempSort(List unordered) {
        Collections.reverse(unordered);
        return unordered;
    }

    private void addCaughtExceptions(List LQRSCaughtExceptions) {
        Iterator itr = LQRSCaughtExceptions.iterator();
        while (itr.hasNext()) {
            Throwable e = (Throwable)itr.next();
            if (this.caughtExceptions.contains(e)) continue;
            this.caughtExceptions.add(e);
        }
    }

    private void fillBuffer() {
        LogQueryResultset lqrs = null;
        List tempSortRS = null;
        if (this.mDirection == 1) {
            lqrs = this.recordSource.getOldest(50);
            this.mDirection = 2;
            this.mPointer = 0;
            tempSortRS = new ArrayList(lqrs.getResult());
        } else if (this.mDirection == 0) {
            lqrs = this.recordSource.getLatest(50);
            this.mDirection = 3;
            this.mPointer = lqrs.getResult().size() - 1;
            tempSortRS = new ArrayList(lqrs.getResult());
            tempSortRS = this.tempSort(tempSortRS);
        } else if (this.mDirection == 2 && !this.latestEOF) {
            this.reverseLastCall();
            lqrs = this.recordSource.getNext(50);
            this.mPointer = 0;
            tempSortRS = new ArrayList(lqrs.getResult());
        } else if (this.mDirection == 3 && !this.oldestEOF) {
            this.reverseLastCall();
            lqrs = this.recordSource.getPrevious(50);
            this.mPointer = lqrs.getResult().size() - 1;
            tempSortRS = new ArrayList(lqrs.getResult());
            tempSortRS = this.tempSort(tempSortRS);
        }
        if (lqrs != null) {
            if (lqrs.getResult().size() > 0) {
                this.addCaughtExceptions(lqrs.getExceptionsDuringReading());
                this.lastCall = this.mDirection;
                this.lastCallSize = lqrs.getResult().size();
                this.someLogRecords = tempSortRS;
                this.lastPointer = -1;
                this.counter += lqrs.getCounterOfRecordsRead();
                this.isTimedOut = lqrs.isTimedOut();
                if (lqrs.getResult().size() < 50 && !this.isTimedOut) {
                    this.latestEOF = lqrs.isLatest();
                    this.oldestEOF = lqrs.isOldest();
                }
            } else {
                this.addCaughtExceptions(lqrs.getExceptionsDuringReading());
                this.counter = lqrs.getCounterOfRecordsRead();
                this.isTimedOut = lqrs.isTimedOut();
                if (!this.isTimedOut) {
                    this.latestEOF = lqrs.isLatest();
                    this.oldestEOF = lqrs.isOldest();
                }
                this.mPointer = -1;
            }
        }
    }

    private void checkBuffer() {
        if (this.mPointer >= this.someLogRecords.size() || this.mPointer < 0) {
            this.fillBuffer();
        }
    }

    private void reverseLastCall() {
        if (this.mDirection == 3 && this.lastCall == 2) {
            this.recordSource.getPrevious(this.lastCallSize - 1);
        } else if (this.mDirection == 2 && this.lastCall == 3) {
            this.recordSource.getNext(this.lastCallSize - 1);
        }
    }

    public List getCaughtExceptionsFromBuffer() {
        return this.caughtExceptions;
    }

    public long getLogRecordCounter() {
        return this.counter;
    }

    public void setLogRecordCounter(int i) {
        this.counter = 0L;
    }

    public boolean isTimedOut() {
        return this.isTimedOut;
    }
}

