/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application;

import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.LocalizationException;
import com.sap.localization.ResourceAccessor;
import com.sapmarkets.bam.application.AsyncQueryResultBrowser;
import com.sapmarkets.bam.application.ContinuousAsyncResultBrowser;
import com.sapmarkets.bam.application.DefaultAsyncResultBrowser;
import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.application.LogQuery;
import com.sapmarkets.bam.application.MultiServerBrowser;
import com.sapmarkets.bam.application.SingleServerBrowser;
import com.sapmarkets.bam.application.logdepot.LogDepot;
import com.sapmarkets.bam.logcontroller.DownloadSpecs;
import com.sapmarkets.bam.logcontroller.QueryResultBrowser;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.util.LogViewerResourceAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class QueryResultBrowserFactory {
    private static TimeZone userTimeZone = TimeZone.getDefault();
    private static Locale userLocale = Locale.getDefault();
    private static LogViewerResourceAccessor resourceAccessor = LogViewerResourceAccessor.getInstance();

    public static QueryResultBrowser getQueryResultBrowser(List logDescriptors, LogQueryExpression aLogQueryExpression, DownloadSpecs downloadSpecs) throws BAMAppException {
        Map someServersLogDescriptors = QueryResultBrowserFactory.createLogDescServerMap(logDescriptors);
        Set servers = someServersLogDescriptors.keySet();
        QueryResultBrowser queryResultBrowser = null;
        if (servers.size() == 0) {
            try {
                throw new IllegalArgumentException(LocalizableTextFormatter.formatString((ResourceAccessor)resourceAccessor, (String)"NO_SERVERS_PASSED_TO_QUERY_RESULT_BROWSER_FACTORY", null, (Locale)userLocale, (TimeZone)userTimeZone));
            }
            catch (LocalizationException le) {
                throw new IllegalArgumentException("No servers passed to the QueryResultBrowser Factory");
            }
        }
        if (servers.size() == 1) {
            String hostName = (String)servers.iterator().next();
            queryResultBrowser = QueryResultBrowserFactory.createSingleLogQueryResultset((List)someServersLogDescriptors.get(hostName), aLogQueryExpression, downloadSpecs);
        } else if (servers.size() > 1) {
            Iterator serverItr = servers.iterator();
            ArrayList<SingleServerBrowser> singleLogQueryResultsets = new ArrayList<SingleServerBrowser>();
            while (serverItr.hasNext()) {
                String hostName = (String)serverItr.next();
                singleLogQueryResultsets.add(QueryResultBrowserFactory.createSingleLogQueryResultset((List)someServersLogDescriptors.get(hostName), aLogQueryExpression, downloadSpecs));
            }
            queryResultBrowser = new MultiServerBrowser(singleLogQueryResultsets);
        }
        return queryResultBrowser;
    }

    public static AsyncQueryResultBrowser getDefaultAsyncResultBrowser(List logDescriptors, LogQueryExpression logQueryExpression, DownloadSpecs downloadSpecs) throws BAMAppException {
        return new DefaultAsyncResultBrowser(logDescriptors, logQueryExpression, downloadSpecs);
    }

    public static AsyncQueryResultBrowser getContinuousAsyncResultBrowser(List logDescriptors, LogQueryExpression logQueryExpression, DownloadSpecs downloadSpecs) throws BAMAppException {
        return new ContinuousAsyncResultBrowser(logDescriptors, logQueryExpression, downloadSpecs);
    }

    private static Map createLogDescServerMap(List pLogDescriptors) {
        HashMap logDescriptorServers = new HashMap();
        Iterator itrLogDescriptors = pLogDescriptors.iterator();
        while (itrLogDescriptors.hasNext()) {
            LogDescriptor logDescriptor = (LogDescriptor)itrLogDescriptors.next();
            String hostName = logDescriptor.getHostName() + ":" + logDescriptor.getPort() + ":" + logDescriptor.getClusterNodeID();
            if (!logDescriptorServers.containsKey(hostName)) {
                ArrayList<LogDescriptor> logDescriptors = new ArrayList<LogDescriptor>();
                logDescriptors.add(logDescriptor);
                logDescriptorServers.put(hostName, logDescriptors);
                continue;
            }
            ((List)logDescriptorServers.get(hostName)).add(logDescriptor);
        }
        return logDescriptorServers;
    }

    static SingleServerBrowser createSingleLogQueryResultset(List logDescriptors, LogQueryExpression logQueryExpression, DownloadSpecs downloadSpecs) {
        LogDescriptor logDescriptor = (LogDescriptor)logDescriptors.get(0);
        LogDepot logDepot = logDescriptor.getLogDepot();
        LogQuery logQuery = logDepot.createLogQuery(logDescriptors, logQueryExpression, downloadSpecs);
        return new SingleServerBrowser(logQuery);
    }
}

