/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application;

import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.LocalizationException;
import com.sap.localization.ResourceAccessor;
import com.sapmarkets.bam.application.MergeEngine;
import com.sapmarkets.bam.application.SingleServerBrowser;
import com.sapmarkets.bam.logcontroller.LogQueryResultset;
import com.sapmarkets.bam.logcontroller.LogRecordDefinition;
import com.sapmarkets.bam.logcontroller.MetaDataOfReaders;
import com.sapmarkets.bam.logcontroller.QueryResultBrowser;
import com.sapmarkets.bam.util.LogViewerResourceAccessor;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class MultiServerBrowser
implements QueryResultBrowser {
    private List singleServerBrowsers;
    private MergeEngine mergeEngine;
    private static TimeZone userTimeZone = TimeZone.getDefault();
    private static Locale userLocale = Locale.getDefault();
    private static LogViewerResourceAccessor resourceAccessor = LogViewerResourceAccessor.getInstance();

    public MultiServerBrowser(List singleServerBrowser) {
        this.singleServerBrowsers = singleServerBrowser;
        this.mergeEngine = new MergeEngine(singleServerBrowser);
    }

    public LogQueryResultset getLatest(int numRecords) {
        return this.mergeEngine.getLatest(numRecords);
    }

    public LogQueryResultset getNext(int numRecords) {
        return this.mergeEngine.getNext(numRecords);
    }

    public LogQueryResultset getPrevious(int numRecords) {
        return this.mergeEngine.getPrevious(numRecords);
    }

    public LogQueryResultset getOldest(int numRecords) {
        return this.mergeEngine.getOldest(numRecords);
    }

    public void close() {
        Iterator iter = this.singleServerBrowsers.iterator();
        while (iter.hasNext()) {
            SingleServerBrowser singleServer = (SingleServerBrowser)iter.next();
            singleServer.close();
        }
    }

    public MetaDataOfReaders getMetaDataOfReaders() {
        try {
            throw new UnsupportedOperationException(LocalizableTextFormatter.formatString((ResourceAccessor)resourceAccessor, (String)"PASSED_IN_MORE_THAN_ONE_SERVER", null, (Locale)userLocale, (TimeZone)userTimeZone));
        }
        catch (LocalizationException le) {
            throw new UnsupportedOperationException("Please Pass in only one server to get the dataDefinition.");
        }
    }

    public void stopBrowsing() {
        this.mergeEngine.stopBrowsing();
    }

    public LogRecordDefinition getLogRecordDefinition() {
        return this.mergeEngine.getLogRecordDefinition();
    }
}

