/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application;

import com.sap.jmx.ObjectNameFactory;
import com.sapmarkets.bam.application.LogRegistrationResult;
import com.sapmarkets.bam.application.User;
import com.sapmarkets.bam.application.logdepot.LogDepot;
import com.sapmarkets.bam.jmxadapter.util.LogDirectory;
import com.sapmarkets.bam.util.BAMSysRuntimeException;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class MonitorableFileHandler {
    private static final Logger LOG = new Logger(class$com$sapmarkets$bam$application$MonitorableFileHandler == null ? (class$com$sapmarkets$bam$application$MonitorableFileHandler = MonitorableFileHandler.class$("com.sapmarkets.bam.application.MonitorableFileHandler")) : class$com$sapmarkets$bam$application$MonitorableFileHandler);
    private static final Tracer TRACE = new Tracer(class$com$sapmarkets$bam$application$MonitorableFileHandler == null ? (class$com$sapmarkets$bam$application$MonitorableFileHandler = MonitorableFileHandler.class$("com.sapmarkets.bam.application.MonitorableFileHandler")) : class$com$sapmarkets$bam$application$MonitorableFileHandler);
    private LogDepot logDepot_;
    static /* synthetic */ Class class$com$sapmarkets$bam$application$MonitorableFileHandler;

    public MonitorableFileHandler(LogDepot logDepot) {
        this.logDepot_ = logDepot;
    }

    public List getMonitorableFiles(String query) {
        try {
            ObjectName objectName = ObjectNameFactory.getNameForServerChildPerNode((String)"LogDirectoryMBean", (String)"LogDirectory", (String)this.logDepot_.getClusterNodeID(), null);
            return (List)this.logDepot_.invokeMBeanMethod(objectName, "getMonitorableFiles", new Object[]{query}, new String[]{"java.lang.String"});
        }
        catch (MalformedObjectNameException e) {
            TRACE.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_CREATE_ADDITIONAL_FILE_MONITORING_UTILITY_MBEAN", e);
        }
        catch (InstanceNotFoundException e) {
            TRACE.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_INVOKE_ADDITIONAL_FILE_MONITORING_UTILITY_METHOD", new Object[]{"getMonitorableFiles"}, e);
        }
        catch (MBeanException e) {
            TRACE.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_INVOKE_ADDITIONAL_FILE_MONITORING_UTILITY_METHOD", new Object[]{"getMonitorableFiles"}, e);
        }
        catch (ReflectionException e) {
            TRACE.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_INVOKE_ADDITIONAL_FILE_MONITORING_UTILITY_METHOD", new Object[]{"getMonitorableFiles"}, e);
        }
    }

    public String getFormatterType(String logFileName) {
        try {
            ObjectName objectName = ObjectNameFactory.getNameForServerChildPerNode((String)"LogDirectoryMBean", (String)"LogDirectory", (String)this.logDepot_.getClusterNodeID(), null);
            return (String)this.logDepot_.invokeMBeanMethod(objectName, "getFormatterType", new Object[]{logFileName}, new String[]{"java.lang.String"});
        }
        catch (MalformedObjectNameException e) {
            TRACE.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_CREATE_ADDITIONAL_FILE_MONITORING_UTILITY_MBEAN", e);
        }
        catch (InstanceNotFoundException e) {
            TRACE.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_INVOKE_ADDITIONAL_FILE_MONITORING_UTILITY_METHOD", new Object[]{"getMonitorableFiles"}, e);
        }
        catch (MBeanException e) {
            TRACE.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_INVOKE_ADDITIONAL_FILE_MONITORING_UTILITY_METHOD", new Object[]{"getMonitorableFiles"}, e);
        }
        catch (ReflectionException e) {
            TRACE.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_INVOKE_ADDITIONAL_FILE_MONITORING_UTILITY_METHOD", new Object[]{"getMonitorableFiles"}, e);
        }
    }

    public boolean isMonitorable(String fileName) {
        try {
            List files = this.getMonitorableFiles(fileName);
            return files != null && files.size() == 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    public LogRegistrationResult registerToMonitor(String file, String format, User user) {
        return this.registerToMonitor(file, format, 0, 0, user);
    }

    public LogRegistrationResult registerToMonitor(String file, String format, int limit, int count, User user) {
        try {
            ObjectName objectName = ObjectNameFactory.getNameForServerChildPerNode((String)"LogDirectoryMBean", (String)"LogDirectory", (String)this.logDepot_.getClusterNodeID(), null);
            LogRegistrationResult result = (LogRegistrationResult)this.logDepot_.invokeMBeanMethod(objectName, "registerToMonitor", new Object[]{file, format, new Integer(limit), new Integer(count), this.logDepot_.getClusterNodeID(), user}, new String[]{"java.lang.String", "java.lang.String", "int", "int", "java.lang.String", "com.sapmarkets.bam.application.User"});
            return result;
        }
        catch (MalformedObjectNameException e) {
            TRACE.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_CREATE_ADDITIONAL_FILE_MONITORING_UTILITY_MBEAN", e);
        }
        catch (InstanceNotFoundException e) {
            TRACE.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_INVOKE_ADDITIONAL_FILE_MONITORING_UTILITY_METHOD", new Object[]{"registerToMonitor"}, e);
        }
        catch (MBeanException e) {
            TRACE.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_INVOKE_ADDITIONAL_FILE_MONITORING_UTILITY_METHOD", new Object[]{"registerToMonitor"}, e);
        }
        catch (ReflectionException e) {
            TRACE.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_INVOKE_ADDITIONAL_FILE_MONITORING_UTILITY_METHOD", new Object[]{"registerToMonitor"}, e);
        }
    }

    public boolean unregister(ObjectName name) {
        try {
            this.logDepot_.unRegisterLog(name);
            return true;
        }
        catch (InstanceNotFoundException e) {
            LOG.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_UNREGISTER", new Object[]{name}, e);
        }
        catch (MBeanException e) {
            LOG.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_UNREGISTER", new Object[]{name}, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List readAndRegisterLogsFromLogDirectory(String fileName, User user) throws IOException {
        List list;
        RandomAccessFile raf = new RandomAccessFile(fileName, "r");
        byte[] logDirectory = new byte[(int)raf.length()];
        raf.read(logDirectory);
        try {
            try {
                List result;
                ObjectName objectName = ObjectNameFactory.getNameForServerChildPerNode((String)"LogDirectoryMBean", (String)"LogDirectory", (String)this.logDepot_.getClusterNodeID(), null);
                String ld = LogDirectory.appendTags(new String(logDirectory));
                list = result = (List)this.logDepot_.invokeMBeanMethod(objectName, "parseAndRegisterLogsFromLogDirectory", new Object[]{ld, this.logDepot_.getClusterNodeID(), user}, new String[]{"java.lang.String", "java.lang.String", "com.sapmarkets.bam.application.User"});
                Object var10_13 = null;
            }
            catch (MalformedObjectNameException e) {
                LOG.logOriginalException(e);
                throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_CREATE_ADDITIONAL_FILE_MONITORING_UTILITY_MBEAN", e);
            }
            catch (InstanceNotFoundException e) {
                LOG.logOriginalException(e);
                throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_INVOKE_ADDITIONAL_FILE_MONITORING_UTILITY_METHOD", new Object[]{"registerToMonitor"}, e);
            }
            catch (MBeanException e) {
                LOG.logOriginalException(e);
                throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_INVOKE_ADDITIONAL_FILE_MONITORING_UTILITY_METHOD", new Object[]{"registerToMonitor"}, e);
            }
            catch (ReflectionException e) {
                LOG.logOriginalException(e);
                throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_INVOKE_ADDITIONAL_FILE_MONITORING_UTILITY_METHOD", new Object[]{"registerToMonitor"}, e);
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            raf.close();
            throw throwable;
        }
        raf.close();
        return list;
    }

    public List getMonitorablePaths() {
        try {
            ObjectName objectName = ObjectNameFactory.getNameForServerChildPerNode((String)"LogDirectoryMBean", (String)"LogDirectory", (String)this.logDepot_.getClusterNodeID(), null);
            return (List)this.logDepot_.invokeMBeanMethod(objectName, "getMonitorablePaths", new Object[0], new String[0]);
        }
        catch (MalformedObjectNameException e) {
            TRACE.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_CREATE_ADDITIONAL_FILE_MONITORING_UTILITY_MBEAN", e);
        }
        catch (InstanceNotFoundException e) {
            TRACE.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_INVOKE_ADDITIONAL_FILE_MONITORING_UTILITY_METHOD", new Object[]{"getMonitorableFiles"}, e);
        }
        catch (MBeanException e) {
            TRACE.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_INVOKE_ADDITIONAL_FILE_MONITORING_UTILITY_METHOD", new Object[]{"getMonitorableFiles"}, e);
        }
        catch (ReflectionException e) {
            TRACE.logOriginalException(e);
            throw new BAMSysRuntimeException(LOG.getLocation(), "UNABLE_TO_INVOKE_ADDITIONAL_FILE_MONITORING_UTILITY_METHOD", new Object[]{"getMonitorableFiles"}, e);
        }
    }

    public LogDepot getLogDepot() {
        return this.logDepot_;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

