/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application;

import com.sap.exception.BaseException;
import com.sapmarkets.bam.application.LogRecordModelComparator;
import com.sapmarkets.bam.application.RecordBuffer;
import com.sapmarkets.bam.application.RecordSource;
import com.sapmarkets.bam.logcontroller.DownloadSpecs;
import com.sapmarkets.bam.logcontroller.LogQueryResultset;
import com.sapmarkets.bam.logcontroller.LogRecord;
import com.sapmarkets.bam.logcontroller.LogRecordDefinition;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.util.LogViewerResourceAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class MergeEngine {
    private List recordSources;
    private boolean isOldest;
    private boolean isLatest;
    private boolean isTimedOut;
    private LogRecordDefinition combinedLogRecordDefintion;
    private int direction;
    private long durationForExecution;
    boolean stop;
    private static TimeZone userTimeZone = TimeZone.getDefault();
    private static Locale userLocale = Locale.getDefault();
    private static LogViewerResourceAccessor resourceAccessor = LogViewerResourceAccessor.getInstance();
    private List someRecordBuffers;
    private static final int OLDEST = 1;
    private static final int LATEST = 0;
    private static final int PREVIOUS = 3;
    private static final int NEXT = 2;
    private DownloadSpecs downloadSpecs;

    public MergeEngine(List recordSources, DownloadSpecs downloadSpecs) {
        this.recordSources = recordSources;
        this.someRecordBuffers = new ArrayList();
        this.isOldest = false;
        this.isLatest = false;
        this.isTimedOut = false;
        this.combinedLogRecordDefintion = this.createCombinedLogRecordDefinition();
        this.downloadSpecs = downloadSpecs;
        if (downloadSpecs.shouldApplyDownloadSpecs()) {
            this.durationForExecution = downloadSpecs.getTimeBeforeServerReturns();
        }
    }

    public MergeEngine(List recordSources) {
        this(recordSources, new DownloadSpecs(0L, false));
    }

    private LogRecordDefinition createCombinedLogRecordDefinition() {
        ArrayList<MonitoredDataDefinition> combinedMDD = new ArrayList<MonitoredDataDefinition>();
        Iterator i = this.recordSources.iterator();
        while (i.hasNext()) {
            RecordSource recordSource = (RecordSource)i.next();
            Iterator itr = recordSource.getLogRecordDefinition().getMonitoredDataDefinitions().iterator();
            while (itr.hasNext()) {
                MonitoredDataDefinition mdd = (MonitoredDataDefinition)itr.next();
                if (combinedMDD.contains(mdd)) continue;
                combinedMDD.add(mdd);
            }
        }
        return new LogRecordDefinition(combinedMDD);
    }

    private void reverseDirection(int direction) {
        Iterator it = this.someRecordBuffers.iterator();
        this.isTimedOut = false;
        while (it.hasNext()) {
            RecordBuffer buffer = (RecordBuffer)it.next();
            buffer.setLogRecordCounter(0);
            buffer.setDirection(direction);
        }
    }

    private void initRecordBuffers(int direction) {
        this.isTimedOut = false;
        this.someRecordBuffers.clear();
        Iterator it = this.recordSources.iterator();
        while (it.hasNext()) {
            this.someRecordBuffers.add(new RecordBuffer((RecordSource)it.next(), direction));
        }
    }

    public LogQueryResultset getLatest(int numRecords) {
        this.direction = 0;
        this.isLatest = true;
        this.initRecordBuffers(this.direction);
        LogQueryResultset logQueryResultset = this.getResultFromBuffers(numRecords);
        this.isOldest = logQueryResultset.getResult().size() < numRecords && !this.isTimedOut;
        logQueryResultset.setLatest(this.isLatest);
        logQueryResultset.setOldest(this.isOldest);
        return logQueryResultset;
    }

    public LogQueryResultset getNext(int numRecords) {
        this.direction = 2;
        this.reverseDirection(this.direction);
        LogQueryResultset logQueryResultset = this.getResultFromBuffers(numRecords);
        boolean bl = this.isLatest = logQueryResultset.getResult().size() < numRecords && !this.isTimedOut;
        if (logQueryResultset.getResult().size() > 0) {
            this.isOldest = false;
        }
        logQueryResultset.setLatest(this.isLatest);
        logQueryResultset.setOldest(this.isOldest);
        return logQueryResultset;
    }

    public LogQueryResultset getPrevious(int numRecords) {
        this.direction = 3;
        this.reverseDirection(this.direction);
        LogQueryResultset logQueryResultset = this.getResultFromBuffers(numRecords);
        boolean bl = this.isOldest = logQueryResultset.getResult().size() < numRecords && !this.isTimedOut;
        if (logQueryResultset.getResult().size() > 0) {
            this.isLatest = false;
        }
        logQueryResultset.setLatest(this.isLatest);
        logQueryResultset.setOldest(this.isOldest);
        return logQueryResultset;
    }

    public LogQueryResultset getOldest(int numRecords) {
        this.direction = 1;
        this.isOldest = true;
        this.initRecordBuffers(this.direction);
        LogQueryResultset logQueryResultset = this.getResultFromBuffers(numRecords);
        this.isLatest = logQueryResultset.getResult().size() < numRecords && !this.isTimedOut;
        logQueryResultset.setLatest(this.isLatest);
        logQueryResultset.setOldest(this.isOldest);
        return logQueryResultset;
    }

    private LogRecord getFromTempResultSet(List orderedResults) {
        Collections.sort(orderedResults, new LogRecordModelComparator());
        LogRecord addLogRecord = null;
        if (this.direction == 1 || this.direction == 2) {
            int i = 0;
            while (addLogRecord == null && i < orderedResults.size()) {
                addLogRecord = (LogRecord)orderedResults.get(i);
                ++i;
            }
        } else if (orderedResults.size() > 0 && orderedResults.get(orderedResults.size() - 1) != null) {
            addLogRecord = (LogRecord)orderedResults.get(orderedResults.size() - 1);
        }
        return addLogRecord;
    }

    private void resetBufferPointers(LogRecord resultLogRecord) {
        Iterator it = this.someRecordBuffers.iterator();
        while (it.hasNext()) {
            RecordBuffer buffer = (RecordBuffer)it.next();
            buffer.resetBufferPointer(resultLogRecord);
        }
    }

    private LogQueryResultset getResultFromBuffers(int numRecords) {
        this.stop = false;
        long startTime = System.currentTimeMillis();
        LogQueryResultset finalLogQueryResultset = new LogQueryResultset(this.combinedLogRecordDefintion);
        while (finalLogQueryResultset.size() < numRecords && !this.stop && !this.isTimedOut) {
            ArrayList<LogRecord> tempResultSet = new ArrayList<LogRecord>();
            Iterator it = this.someRecordBuffers.iterator();
            while (it.hasNext()) {
                RecordBuffer buffer = (RecordBuffer)it.next();
                LogRecord logrecord = null;
                logrecord = this.direction == 0 || this.direction == 3 ? buffer.getPrevious() : buffer.getNext();
                if (logrecord == null) continue;
                tempResultSet.add(logrecord);
            }
            LogRecord resultLR = this.getFromTempResultSet(tempResultSet);
            if (resultLR == null) {
                this.stop = true;
            } else {
                if (!this.contains(finalLogQueryResultset, resultLR)) {
                    finalLogQueryResultset.appendLogrecord(new LogRecord(resultLR, this.combinedLogRecordDefintion));
                }
                this.resetBufferPointers(resultLR);
            }
            if (!this.downloadSpecs.shouldApplyDownloadSpecs() || System.currentTimeMillis() <= startTime + this.durationForExecution) continue;
            this.stop = true;
            this.isTimedOut = true;
            finalLogQueryResultset.setTimedOut(true);
        }
        long combinedCounter = 0L;
        Iterator i = this.someRecordBuffers.iterator();
        while (i.hasNext()) {
            RecordBuffer buffer = (RecordBuffer)i.next();
            Iterator iter = buffer.getCaughtExceptionsFromBuffer().iterator();
            while (iter.hasNext()) {
                BaseException ex = (BaseException)iter.next();
                finalLogQueryResultset.addBaseException(ex);
            }
            combinedCounter += buffer.getLogRecordCounter();
            if (!buffer.isTimedOut()) continue;
            this.isTimedOut = true;
            finalLogQueryResultset.setTimedOut(true);
        }
        finalLogQueryResultset.setCounterOfRecordsRead(combinedCounter);
        return finalLogQueryResultset;
    }

    private boolean contains(LogQueryResultset finalLogQueryResultset, LogRecord resultLR) {
        Iterator itr = finalLogQueryResultset.getResult().iterator();
        while (itr.hasNext()) {
            LogRecord lr = (LogRecord)itr.next();
            if (!lr.equals(resultLR)) continue;
            return true;
        }
        return false;
    }

    public void stopBrowsing() {
        this.stop = true;
    }

    public LogRecordDefinition getLogRecordDefinition() {
        return this.combinedLogRecordDefintion;
    }
}

