/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application;

import com.sapmarkets.bam.util.SUID;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;

public class LogRegistrationResult
implements Serializable {
    public static final long serialVersionUID = SUID.getID();
    public static final int FAILED = -1;
    public static final int SUCCESSFUL = 0;
    public static final int PREREGISTERED = 1;
    public static final int UNHANDLED = 2;
    public static final int UNMONITORABLE = 3;
    private int status;
    private List exceptions = new ArrayList();
    private ObjectName objectName;
    private String pattern;
    private String formatType;

    public LogRegistrationResult(ObjectName objectName, int status, String pattern, String formatType) {
        this.objectName = objectName;
        this.status = status;
        this.pattern = pattern;
        this.formatType = formatType;
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public void addException(Throwable t) {
        if (t != null) {
            this.exceptions.add(t);
        }
    }

    public String getFormatType() {
        return this.formatType;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusAsString() {
        switch (this.status) {
            case -1: {
                return "Failed";
            }
            case 0: {
                return "Successful";
            }
            case 1: {
                return "Preregistered";
            }
            case 2: {
                return "Unhandled";
            }
            case 3: {
                return "Unmonitorable";
            }
        }
        return "The status is unknown";
    }

    public String toString() {
        return "Status=" + this.getStatusAsString() + "; exceptions=" + this.getExceptions() + " pattern=" + this.getPattern() + " format=" + this.getFormatType() + " object name=" + this.getObjectName();
    }
}

