/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application;

import com.sap.exception.standard.SAPIllegalArgumentException;
import com.sap.tc.logging.FormatterType;
import com.sap.tc.logging.Location;
import com.sapmarkets.bam.application.LogAttributeDescriptor;
import com.sapmarkets.bam.application.LogId;
import com.sapmarkets.bam.application.User;
import com.sapmarkets.bam.application.logdepot.LogDepot;
import com.sapmarkets.bam.logcontroller.LogRecordDefinition;
import com.sapmarkets.bam.logcontroller.MDDNotFoundException;
import com.sapmarkets.bam.logcontroller.MonitoredDataDefinition;
import com.sapmarkets.bam.util.LogTypeEnumeration;
import com.sapmarkets.bam.util.SUID;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;

public class LogDescriptor
implements Serializable,
Cloneable {
    public static final long serialVersionUID = SUID.getID();
    private ObjectName mObjectName;
    private String mDisplayName;
    private String mLogName;
    private LogId mlogId;
    private LogTypeEnumeration mType;
    private int mPort;
    private String mHostName;
    private String mApplicationName;
    private Set mAttributeDescriptors;
    private String mBeanServerID;
    private String clusterNodeID;
    private String clusterNodeName;
    private FormatterType formatterType;
    private String mSpecificLogType;
    private User user;
    private LogRecordDefinition logrecordDefinition;
    private transient LogDepot logDepot_;
    private Map attributes;
    static /* synthetic */ Class class$com$sapmarkets$bam$application$LogDescriptor;

    public LogDepot getLogDepot() {
        return this.logDepot_;
    }

    public LogDescriptor(ObjectName objectName, String displayName, String logName, LogTypeEnumeration type, String hostName, int port, String mbeanServerID, String serverNodeName, FormatterType formatterType, String specificLogType, User user, LogDepot logDepot, Map attributes) {
        this.mObjectName = objectName;
        this.mDisplayName = displayName;
        this.mType = type;
        this.mPort = port;
        this.mHostName = hostName;
        this.mBeanServerID = mbeanServerID;
        this.clusterNodeID = objectName.getKeyProperty("SAP_J2EEClusterNode");
        this.clusterNodeName = serverNodeName;
        this.formatterType = formatterType;
        this.mSpecificLogType = specificLogType;
        this.user = user;
        this.mlogId = new LogId(this.clusterNodeID, logName);
        this.mLogName = this.mlogId.toString();
        this.attributes = attributes;
        this.logDepot_ = logDepot;
    }

    public String toString() {
        return "[" + this.getDisplayName() + " " + this.getSpecificLogType() + " " + this.getFormatterType().toString() + "]";
    }

    public User getUser() {
        return this.user;
    }

    public String getMBeanServerID() {
        return this.mBeanServerID;
    }

    public LogRecordDefinition getLogRecordDefinition() {
        return this.logrecordDefinition;
    }

    public void setLogRecordDefinition(LogRecordDefinition alrd) {
        this.logrecordDefinition = alrd;
    }

    public String getApplicationName() {
        return this.mApplicationName;
    }

    public void setApplicationName(String anApplicationName) {
        this.mApplicationName = anApplicationName;
    }

    public ObjectName getObjectName() {
        return this.mObjectName;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public LogTypeEnumeration getType() {
        return this.mType;
    }

    public String getLogName() {
        return this.mLogName;
    }

    public LogId getLogId() {
        return this.mlogId;
    }

    public String getURI() {
        return this.mlogId.getURI();
    }

    public String getName() {
        String mName = "";
        int idx = this.mLogName.lastIndexOf("\\");
        mName = this.mLogName.substring(idx + 1);
        return mName;
    }

    public Date getLastModified() {
        Object o = this.getAttribute("LastModified");
        if (o == null) {
            return new Date(0L);
        }
        return new Date((Long)o);
    }

    public String getLastModifiedString() {
        Date d;
        SimpleDateFormat df = new SimpleDateFormat();
        Object o = this.getAttribute("LastModified");
        String result = o == null ? "N/A" : ((d = new Date((Long)o)).getTime() == 0L ? "N/A" : df.format(d));
        return result;
    }

    public String getArchiveLastModifiedString() {
        Date d;
        SimpleDateFormat df = new SimpleDateFormat();
        Object o = this.getAttribute("ArchiveLastModified");
        String result = o == null ? "N/A" : ((d = new Date((Long)o)).getTime() == 0L ? "N/A" : df.format(d));
        return result;
    }

    public String getSpecificLogType() {
        return this.mSpecificLogType;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getHostName() {
        return this.mHostName;
    }

    public void setLogAttributeDescriptors(Set attributeDescriptors) {
        this.mAttributeDescriptors = attributeDescriptors;
    }

    public Set getLogAttributeDescriptors() {
        return this.mAttributeDescriptors;
    }

    public LogAttributeDescriptor getLogAttributeDescriptor(String attributeName) {
        if (attributeName == null) {
            throw new SAPIllegalArgumentException(Location.getLocation((Class)(class$com$sapmarkets$bam$application$LogDescriptor == null ? (class$com$sapmarkets$bam$application$LogDescriptor = LogDescriptor.class$("com.sapmarkets.bam.application.LogDescriptor")) : class$com$sapmarkets$bam$application$LogDescriptor)), "com.sap.exception.standard_0001", new Object[]{"attributeName"});
        }
        Iterator itr = this.mAttributeDescriptors.iterator();
        while (itr.hasNext()) {
            LogAttributeDescriptor attribute = (LogAttributeDescriptor)itr.next();
            if (!attributeName.equals(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    public boolean isMergableWith(LogDescriptor descriptor) {
        LogRecordDefinition lrd1 = this.getLogRecordDefinition();
        LogRecordDefinition lrd2 = descriptor.getLogRecordDefinition();
        if (lrd1 != null && lrd2 != null) {
            try {
                MonitoredDataDefinition sequence1 = lrd1.getSequence();
                MonitoredDataDefinition sequence2 = lrd2.getSequence();
                if (sequence1 != null && sequence2 != null && sequence1.getMonitoredDataDefinitionType().equalsIgnoreCase(sequence2.getMonitoredDataDefinitionType())) {
                    return true;
                }
            }
            catch (MDDNotFoundException ex) {
                // empty catch block
            }
        }
        return false;
    }

    public FormatterType getFormatterType() {
        return this.formatterType;
    }

    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
        }
        return obj;
    }

    public int hashCode() {
        int result = 17;
        result = this.mObjectName != null ? 37 * result + this.mObjectName.hashCode() : result;
        result = 37 * result + this.mPort;
        result = this.mHostName != null ? 37 * result + this.mHostName.hashCode() : result;
        result = this.clusterNodeID != null ? 37 * result + this.clusterNodeID.hashCode() : result;
        return result;
    }

    public static boolean equals(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj1.equals(obj2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            LogDescriptor descriptor = (LogDescriptor)obj;
            if (LogDescriptor.equals(this.mObjectName, descriptor.mObjectName) && this.mPort == descriptor.mPort && LogDescriptor.equals(this.mHostName, descriptor.mHostName) && LogDescriptor.equals(this.clusterNodeID, descriptor.clusterNodeID)) {
                return true;
            }
        }
        return false;
    }

    public String getClusterNodeID() {
        return this.clusterNodeID;
    }

    public String getClusterNodeName() {
        return this.clusterNodeName;
    }

    public Object getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public Map getAllAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

