/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application;

import com.sapmarkets.bam.application.AbstractFilterSearch;
import com.sapmarkets.bam.application.Filter;
import com.sapmarkets.bam.application.LogDescriptor;
import com.sapmarkets.bam.application.Search;
import com.sapmarkets.bam.queryexpr.CompositeQueryExpression;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.queryexpr.LogQueryExpressionDescriptor;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.util.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FilterAndSearchHandler {
    private static final Logger mLogger = new Logger(class$com$sapmarkets$bam$application$FilterAndSearchHandler == null ? (class$com$sapmarkets$bam$application$FilterAndSearchHandler = FilterAndSearchHandler.class$("com.sapmarkets.bam.application.FilterAndSearchHandler")) : class$com$sapmarkets$bam$application$FilterAndSearchHandler);
    private List filterAndSearches = new ArrayList();
    static /* synthetic */ Class class$com$sapmarkets$bam$application$FilterAndSearchHandler;
    static /* synthetic */ Class class$com$sapmarkets$bam$application$Search;

    public FilterAndSearchHandler(FilterAndSearchHandler aFilterAndSearchHandler) {
        Iterator itr = aFilterAndSearchHandler.getFiltersAndSearches().iterator();
        while (itr.hasNext()) {
            AbstractFilterSearch fs = (AbstractFilterSearch)itr.next();
            try {
                this.filterAndSearches.add(fs.getClone());
            }
            catch (CloneNotSupportedException e) {
                mLogger.logError("DefaultFilter or Search could not be cloned. Therefore this filter/search will be missing!");
                mLogger.logException(e);
            }
        }
    }

    public FilterAndSearchHandler() {
    }

    private void removeAllSearches() {
        ArrayList newFilterAndSearches = new ArrayList();
        Iterator itr = this.filterAndSearches.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (o.getClass().equals(class$com$sapmarkets$bam$application$Search == null ? FilterAndSearchHandler.class$("com.sapmarkets.bam.application.Search") : class$com$sapmarkets$bam$application$Search)) continue;
            newFilterAndSearches.add(o);
        }
        this.filterAndSearches = newFilterAndSearches;
    }

    public void addFilterOrSearch(AbstractFilterSearch f) {
        this.removeAllSearches();
        this.filterAndSearches.add(f);
    }

    public void addFiltersOrSearches(List f) {
        this.removeAllSearches();
        List tobeAdded = this.analyzeFilters(f);
        this.filterAndSearches.addAll(tobeAdded);
    }

    private List analyzeFilters(List f) {
        ArrayList<AbstractFilterSearch> tobeadded = new ArrayList<AbstractFilterSearch>();
        Iterator itr = f.iterator();
        while (itr.hasNext()) {
            AbstractFilterSearch o = (AbstractFilterSearch)itr.next();
            if (this.filterAndSearches.contains(o)) continue;
            tobeadded.add(o);
        }
        return tobeadded;
    }

    public void removeFilterOrSearch(AbstractFilterSearch f) {
        this.filterAndSearches.remove(f);
    }

    public LogQueryExpression generateLogQueryExpression(List logdescriptors) throws BAMAppException {
        return this.generateExpression(this.filterAndSearches, logdescriptors);
    }

    private LogQueryExpression generateExpression(List filtersAndSearches, List logDescriptors) throws BAMAppException {
        LogQueryExpressionDescriptor andDescriptor = new LogQueryExpressionDescriptor("com.sapmarkets.bam.queryexpr.AndExpression");
        CompositeQueryExpression andExpression = andDescriptor.makeQueryExpression();
        ArrayList<AbstractFilterSearch> used = new ArrayList<AbstractFilterSearch>();
        Iterator itr = filtersAndSearches.iterator();
        while (itr.hasNext()) {
            AbstractFilterSearch afs = (AbstractFilterSearch)itr.next();
            if (used.contains(afs) || !afs.isActive() || !this.supportsExpression(afs, logDescriptors)) continue;
            LogQueryExpression ex = afs.getLogQueryExpression();
            LogQueryExpressionDescriptor orDescriptor = new LogQueryExpressionDescriptor("com.sapmarkets.bam.queryexpr.OrExpression");
            CompositeQueryExpression orExpression = orDescriptor.makeQueryExpression();
            orExpression.addChild(ex);
            used.add(afs);
            Iterator orItr = this.filterAndSearches.iterator();
            while (orItr.hasNext()) {
                AbstractFilterSearch orAFS = (AbstractFilterSearch)orItr.next();
                LogQueryExpression orEx = orAFS.getLogQueryExpression();
                if (!orAFS.isActive() || orAFS.equals(afs) || orEx.getqueryType() != ex.getqueryType() || orEx.getqueryType() == 30 || orAFS.getClass().equals(class$com$sapmarkets$bam$application$Search == null ? FilterAndSearchHandler.class$("com.sapmarkets.bam.application.Search") : class$com$sapmarkets$bam$application$Search) || used.contains(orAFS)) continue;
                orExpression.addChild(orEx);
                used.add(orAFS);
            }
            andExpression.addChild(orExpression);
        }
        return andExpression;
    }

    private boolean supportsExpression(AbstractFilterSearch afs, List logDescriptors) {
        Iterator itr = logDescriptors.iterator();
        while (itr.hasNext()) {
            LogDescriptor ld = (LogDescriptor)itr.next();
            if (!ld.getLogRecordDefinition().getMonitoredDataDefinitions().contains(afs.getColumn())) continue;
            return true;
        }
        return false;
    }

    public LogQueryExpression generateLogQueryExpressionForFilters(List logdescriptors) throws BAMAppException {
        return this.generateExpression(this.getFilters(), logdescriptors);
    }

    public List getFiltersAndSearches() {
        return this.filterAndSearches;
    }

    public List getFilters() {
        ArrayList filters = new ArrayList();
        Iterator itr = this.filterAndSearches.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof Filter)) continue;
            filters.add(o);
        }
        return filters;
    }

    public List getNonGlobalFilters() {
        ArrayList<Filter> nonGlobal = new ArrayList<Filter>();
        Iterator itr = this.getFilters().iterator();
        while (itr.hasNext()) {
            Filter f = (Filter)itr.next();
            if (f.isGlobal()) continue;
            nonGlobal.add(f);
        }
        return nonGlobal;
    }

    public int getNonGlobalFilterCount() {
        return this.getNonGlobalFilters().size();
    }

    public int getFilterCount() {
        return this.getFilters().size();
    }

    public int getFilterAndSearchCount() {
        return this.filterAndSearches.size();
    }

    public String toString() {
        String result = "";
        Iterator itr = this.filterAndSearches.iterator();
        while (itr.hasNext()) {
            AbstractFilterSearch fs = (AbstractFilterSearch)itr.next();
            result = result + fs.toString();
        }
        return result;
    }

    public void removeAllFiltersAndSearches() {
        this.filterAndSearches = new ArrayList();
    }

    public void addAdditionalSearch(Search search) {
        this.filterAndSearches.add(search);
    }

    public void addGlobalFilters(List list) {
        ArrayList newFiltersAndSearches = new ArrayList();
        Iterator itr = this.filterAndSearches.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof Filter) || ((Filter)o).isGlobal()) continue;
            newFiltersAndSearches.add(o);
        }
        newFiltersAndSearches.addAll(list);
        this.filterAndSearches = newFiltersAndSearches;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

