/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application;

import com.sapmarkets.bam.application.AsyncQueryResultBrowser;
import com.sapmarkets.bam.application.BrowsingCommand;
import com.sapmarkets.bam.application.BrowsingThread;
import com.sapmarkets.bam.application.QueryResultBrowserFactory;
import com.sapmarkets.bam.application.QueryResultListener;
import com.sapmarkets.bam.logcontroller.DownloadSpecs;
import com.sapmarkets.bam.logcontroller.LogQueryResultset;
import com.sapmarkets.bam.logcontroller.QueryResultBrowser;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.util.ReadLogRecordException;
import com.sapmarkets.bam.util.Tracer;
import java.util.List;

public class DefaultAsyncResultBrowser
implements AsyncQueryResultBrowser {
    private static final Tracer LOG = new Tracer(class$com$sapmarkets$bam$application$DefaultAsyncResultBrowser == null ? (class$com$sapmarkets$bam$application$DefaultAsyncResultBrowser = DefaultAsyncResultBrowser.class$("com.sapmarkets.bam.application.DefaultAsyncResultBrowser")) : class$com$sapmarkets$bam$application$DefaultAsyncResultBrowser);
    private QueryResultBrowser resultBrowser;
    private BrowsingThread browsingThread;
    private Thread browsingWorkerThread;
    static /* synthetic */ Class class$com$sapmarkets$bam$application$DefaultAsyncResultBrowser;

    public DefaultAsyncResultBrowser(List logDescriptors, LogQueryExpression logQueryExpression, DownloadSpecs downloadSpecs) throws BAMAppException {
        this.resultBrowser = QueryResultBrowserFactory.getQueryResultBrowser(logDescriptors, logQueryExpression, downloadSpecs);
        this.browsingThread = new BrowsingThread(this.resultBrowser, 0L);
        this.browsingWorkerThread = new Thread(this.browsingThread);
        this.browsingWorkerThread.start();
    }

    public void getNext(QueryResultListener listener, int blockSize) {
        this.browsingThread.addCommand(new BrowsingCommand(this.resultBrowser, listener, blockSize){

            protected LogQueryResultset createResultSet() throws ReadLogRecordException {
                LOG.traceInfo("GetOneNextBlock");
                LogQueryResultset result = DefaultAsyncResultBrowser.this.resultBrowser.getNext(this.getBlockSize());
                this.stopCommand();
                return result;
            }
        });
    }

    public void getAllNext(QueryResultListener listener, int blockSize) {
        this.browsingThread.addCommand(new BrowsingCommand(this.resultBrowser, listener, blockSize){

            protected LogQueryResultset createResultSet() throws ReadLogRecordException {
                LOG.traceInfo("GetAllNext");
                LogQueryResultset result = DefaultAsyncResultBrowser.this.resultBrowser.getNext(this.getBlockSize());
                if (result.size() == 0) {
                    LOG.traceInfo("GetNext isLatest");
                    this.stopCommand();
                }
                return result;
            }
        });
    }

    public void getPrevious(QueryResultListener listener, int blockSize) {
        this.browsingThread.addCommand(new BrowsingCommand(this.resultBrowser, listener, blockSize){

            protected LogQueryResultset createResultSet() throws ReadLogRecordException {
                LOG.traceInfo("GetOnePreviousBlock");
                LogQueryResultset result = DefaultAsyncResultBrowser.this.resultBrowser.getPrevious(this.getBlockSize());
                this.stopCommand();
                return result;
            }
        });
    }

    public void getAllPrevious(QueryResultListener listener, int blockSize) {
        this.browsingThread.addCommand(new BrowsingCommand(this.resultBrowser, listener, blockSize){

            protected LogQueryResultset createResultSet() throws ReadLogRecordException {
                LOG.traceInfo("GetAllPreviousBlock");
                LogQueryResultset result = DefaultAsyncResultBrowser.this.resultBrowser.getPrevious(this.getBlockSize());
                if (result.isOldest()) {
                    LOG.traceInfo("GetPrevious isOldest");
                    this.stopCommand();
                }
                return result;
            }
        });
    }

    public void getOldest(QueryResultListener listener, int blockSize) {
        this.browsingThread.addCommand(new BrowsingCommand(this.resultBrowser, listener, blockSize){

            protected LogQueryResultset createResultSet() throws ReadLogRecordException {
                LOG.traceInfo("GetOldest");
                LogQueryResultset result = DefaultAsyncResultBrowser.this.resultBrowser.getOldest(this.getBlockSize());
                this.stopCommand();
                return result;
            }
        });
    }

    public void getLatest(QueryResultListener listener, int blockSize) {
        this.browsingThread.addCommand(new BrowsingCommand(this.resultBrowser, listener, blockSize){

            protected LogQueryResultset createResultSet() throws ReadLogRecordException {
                LOG.traceInfo("GetLatest");
                LogQueryResultset result = DefaultAsyncResultBrowser.this.resultBrowser.getLatest(this.getBlockSize());
                this.stopCommand();
                return result;
            }
        });
    }

    public void stopBrowsing() {
        this.browsingThread.stopBrowsing();
    }

    public boolean isBrowsingStopped() {
        return this.browsingThread.isStopped();
    }

    public void join() throws InterruptedException {
        this.browsingWorkerThread.join();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

