/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application;

import com.sapmarkets.bam.application.AsyncQueryResultBrowser;
import com.sapmarkets.bam.application.BrowsingCommand;
import com.sapmarkets.bam.application.BrowsingThread;
import com.sapmarkets.bam.application.QueryResultBrowserFactory;
import com.sapmarkets.bam.application.QueryResultListener;
import com.sapmarkets.bam.logcontroller.DownloadSpecs;
import com.sapmarkets.bam.logcontroller.LogQueryResultset;
import com.sapmarkets.bam.logcontroller.QueryResultBrowser;
import com.sapmarkets.bam.queryexpr.LogQueryExpression;
import com.sapmarkets.bam.util.BAMAppException;
import com.sapmarkets.bam.util.ReadLogRecordException;
import com.sapmarkets.bam.util.Tracer;
import java.util.List;

public class ContinuousAsyncResultBrowser
implements AsyncQueryResultBrowser {
    private static final Tracer LOG = new Tracer(class$com$sapmarkets$bam$application$ContinuousAsyncResultBrowser == null ? (class$com$sapmarkets$bam$application$ContinuousAsyncResultBrowser = ContinuousAsyncResultBrowser.class$("com.sapmarkets.bam.application.ContinuousAsyncResultBrowser")) : class$com$sapmarkets$bam$application$ContinuousAsyncResultBrowser);
    private static final long COMMAND_INTERVAL = 3000L;
    private QueryResultBrowser resultBrowser;
    private BrowsingThread browsingThread;
    private Thread browsingWorkerThread;
    static /* synthetic */ Class class$com$sapmarkets$bam$application$ContinuousAsyncResultBrowser;

    public ContinuousAsyncResultBrowser(List logDescriptors, LogQueryExpression logQueryExpression, DownloadSpecs downloadSpecs) throws BAMAppException {
        this.resultBrowser = QueryResultBrowserFactory.getQueryResultBrowser(logDescriptors, logQueryExpression, downloadSpecs);
        this.browsingThread = new BrowsingThread(this.resultBrowser, 3000L);
        this.browsingWorkerThread = new Thread(this.browsingThread);
        this.browsingWorkerThread.start();
    }

    public void getNext(QueryResultListener listener, int blockSize) {
        this.getAllNext(listener, blockSize);
    }

    public void getAllNext(QueryResultListener listener, int blockSize) {
        this.browsingThread.addCommand(new BrowsingCommand(this.resultBrowser, listener, blockSize){

            protected LogQueryResultset createResultSet() throws ReadLogRecordException {
                LOG.traceInfo("GetNext");
                LogQueryResultset result = ContinuousAsyncResultBrowser.this.resultBrowser.getNext(this.getBlockSize());
                return result;
            }
        });
    }

    public void getPrevious(QueryResultListener listener, int blockSize) {
        this.getAllPrevious(listener, blockSize);
    }

    public void getAllPrevious(QueryResultListener listener, int blockSize) {
        this.browsingThread.addCommand(new BrowsingCommand(this.resultBrowser, listener, blockSize){

            protected LogQueryResultset createResultSet() throws ReadLogRecordException {
                LOG.traceInfo("GetPreviousBlock");
                LogQueryResultset result = ContinuousAsyncResultBrowser.this.resultBrowser.getPrevious(this.getBlockSize());
                if (result.size() == 0) {
                    LOG.traceInfo("GetPrevious isOldest");
                    this.stopCommand();
                }
                return result;
            }
        });
    }

    public void getOldest(QueryResultListener listener, int blockSize) {
        this.browsingThread.addCommand(new BrowsingCommand(this.resultBrowser, listener, blockSize){

            protected LogQueryResultset createResultSet() throws ReadLogRecordException {
                LOG.traceInfo("GetOldest");
                LogQueryResultset result = ContinuousAsyncResultBrowser.this.resultBrowser.getOldest(this.getBlockSize());
                return result;
            }
        });
    }

    public void getLatest(QueryResultListener listener, int blockSize) {
        this.browsingThread.addCommand(new BrowsingCommand(this.resultBrowser, listener, blockSize){

            protected LogQueryResultset createResultSet() throws ReadLogRecordException {
                LOG.traceInfo("GetLatest");
                LogQueryResultset result = ContinuousAsyncResultBrowser.this.resultBrowser.getLatest(this.getBlockSize());
                return result;
            }
        });
    }

    public void stopBrowsing() {
        this.browsingThread.stopBrowsing();
    }

    public boolean isBrowsingStopped() {
        return this.browsingThread.isStopped();
    }

    public void join() throws InterruptedException {
        this.browsingWorkerThread.join();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

