/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application;

import com.sapmarkets.bam.application.LogRegistrationResult;
import java.util.Iterator;
import java.util.List;

public class CompositeLogRegistrationResult {
    private final String SPACE = " =>     ";
    List mAllResults;
    StringBuffer strBufSuccessful = new StringBuffer();
    StringBuffer strBufPreRegistered = new StringBuffer();
    StringBuffer strBufUnmonitorable = new StringBuffer();
    StringBuffer strBufFailed = new StringBuffer();
    StringBuffer strBufSuccessfulUnhandled = new StringBuffer();
    int mSuccess;
    int mPreRegistered;
    int mErrorsRegistering;

    public CompositeLogRegistrationResult(List logRegistrationResults) {
        this.mAllResults = logRegistrationResults;
        Iterator iter = this.mAllResults.iterator();
        while (iter.hasNext()) {
            LogRegistrationResult result = (LogRegistrationResult)iter.next();
            if (result.getStatus() == 0) {
                this.strBufSuccessful.append(result.getPattern() + " =>     " + result.getStatusAsString() + "\n");
                ++this.mSuccess;
            }
            if (result.getStatus() == -1) {
                this.strBufFailed.append(result.getPattern() + " =>     " + result.getStatusAsString() + "\n");
                ++this.mErrorsRegistering;
            }
            if (result.getStatus() == 1) {
                this.strBufPreRegistered.append(result.getPattern() + " =>     " + result.getStatusAsString() + "\n");
                ++this.mPreRegistered;
            }
            if (result.getStatus() == 2) {
                this.strBufSuccessfulUnhandled.append(result.getPattern() + " =>     " + result.getStatusAsString() + "\n");
                ++this.mErrorsRegistering;
            }
            if (result.getStatus() != 3) continue;
            this.strBufUnmonitorable.append(result.getPattern() + " =>     " + result.getStatusAsString() + "\n");
            ++this.mErrorsRegistering;
        }
    }

    boolean wereAllSuccessful() {
        int successfulCount = 0;
        Iterator iter = this.mAllResults.iterator();
        while (iter.hasNext()) {
            LogRegistrationResult result = (LogRegistrationResult)iter.next();
            if (result.getStatus() != 0) continue;
            ++successfulCount;
        }
        return successfulCount == this.mAllResults.size();
    }

    public String toString() {
        return this.strBufFailed.toString() + this.strBufPreRegistered.toString() + this.strBufSuccessfulUnhandled.toString() + this.strBufUnmonitorable.toString() + this.strBufSuccessful.toString();
    }

    public String getDetails() {
        return this.strBufFailed.toString() + this.strBufPreRegistered.toString() + this.strBufSuccessfulUnhandled.toString() + this.strBufUnmonitorable.toString() + this.strBufSuccessful.toString();
    }

    public String getSummaryData() {
        return "Logs Successfully Registered \t= " + this.mSuccess + "\nLogs Already registered      \t= " + this.mPreRegistered + "\nError During Registration    \t= " + this.mErrorsRegistering;
    }
}

