/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application;

import com.sapmarkets.bam.application.BAMConfiguration;
import com.sapmarkets.bam.application.logdepot.LogDepot;
import com.sapmarkets.bam.application.logdepot.LogDepotFactory;
import com.sapmarkets.bam.jmx.connector.HostDescriptor;
import com.sapmarkets.bam.util.Callable;
import com.sapmarkets.bam.util.Executor;
import com.sapmarkets.bam.util.FutureResult;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.PooledExecutor;
import com.sapmarkets.bam.util.Tracer;
import com.sapmarkets.bam.view.ViewProperty;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClientController {
    private static final Logger LOG__ = new Logger(class$com$sapmarkets$bam$application$ClientController == null ? (class$com$sapmarkets$bam$application$ClientController = ClientController.class$("com.sapmarkets.bam.application.ClientController")) : class$com$sapmarkets$bam$application$ClientController);
    private static final Tracer TRACE__ = new Tracer(class$com$sapmarkets$bam$application$ClientController == null ? (class$com$sapmarkets$bam$application$ClientController = ClientController.class$("com.sapmarkets.bam.application.ClientController")) : class$com$sapmarkets$bam$application$ClientController);
    public static final int CLIENT_VERSION__ = 2;
    private Executor pool = new PooledExecutor(ViewProperty.getInstance().getInt(ViewProperty.CONNECTION_THREAD_POOL_SIZE) == 0 ? 8 : ViewProperty.getInstance().getInt(ViewProperty.CONNECTION_THREAD_POOL_SIZE));
    BAMConfiguration mBAMConfiguration;
    private static ClientController mClientController;
    static /* synthetic */ Class class$com$sapmarkets$bam$application$ClientController;

    private ClientController(BAMConfiguration bamConfig) {
        this.mBAMConfiguration = bamConfig;
    }

    private ClientController() {
        this.mBAMConfiguration = new BAMConfiguration();
    }

    private ClientController(String aFileName) {
        this.mBAMConfiguration = new BAMConfiguration(aFileName);
    }

    public static synchronized ClientController getClientController(BAMConfiguration bamConfig) {
        if (null == mClientController) {
            mClientController = new ClientController(bamConfig);
        }
        return mClientController;
    }

    public static synchronized ClientController getClientController() {
        if (null == mClientController) {
            mClientController = new ClientController();
        }
        return mClientController;
    }

    static synchronized ClientController getClientController(String aFileName) {
        if (null == mClientController) {
            mClientController = new ClientController(aFileName);
        }
        return mClientController;
    }

    public List getHostDescriptors() {
        return this.mBAMConfiguration.getHostDescriptors();
    }

    public void deleteAllHostDescriptors() {
        this.mBAMConfiguration.deleteAll();
    }

    public void addHostDescriptor(HostDescriptor aHostDescriptor) {
        this.mBAMConfiguration.addHostDescriptor(aHostDescriptor);
    }

    public void deleteHostDescriptor(HostDescriptor aHostDescriptor) {
        this.mBAMConfiguration.deleteHostDescriptor(aHostDescriptor);
    }

    public void addAllHostDescriptors(List aList) {
        this.mBAMConfiguration.addAll(aList);
    }

    public void deleteAllHostDescriptors(List aList) {
        this.mBAMConfiguration.deleteAll(aList);
    }

    public void saveConfiguration(Frame aFrame) {
        this.mBAMConfiguration.saveConfiguration(aFrame);
    }

    public Set getLogDescriptors(List errors) {
        List hostDescriptors = this.mBAMConfiguration.getHostDescriptors();
        return this.getLogDescriptors(hostDescriptors, errors);
    }

    public Set getLogDescriptors(List hostDescriptors, List errors) {
        ArrayList<FutureResult> descriptorResults = new ArrayList<FutureResult>();
        int i = 0;
        while (i < hostDescriptors.size()) {
            HostDescriptor hostdescr = (HostDescriptor)hostDescriptors.get(i);
            if (hostdescr.getConnect()) {
                try {
                    FutureResult[] results = this.retrieveLogDescriptors(hostdescr);
                    descriptorResults.addAll(Arrays.asList(results));
                }
                catch (Throwable ex) {
                    LOG__.logException(ex);
                    if (hostdescr.getConnectionErrorMessage() == null) {
                        hostdescr.setConnectionErrorMessage(ex.getMessage());
                    }
                    errors.add(ex);
                }
            }
            ++i;
        }
        HashSet logDescriptors = new HashSet();
        Iterator iter = descriptorResults.iterator();
        while (iter.hasNext()) {
            FutureResult result = (FutureResult)iter.next();
            try {
                logDescriptors.addAll((List)result.get());
            }
            catch (Throwable ex) {
                LOG__.logException(ex);
                errors.add(ex);
            }
        }
        return logDescriptors;
    }

    private FutureResult[] retrieveLogDescriptors(final HostDescriptor descriptor) throws InterruptedException {
        Map logDepots = LogDepotFactory.getHostLogDepots(descriptor);
        FutureResult[] results = new FutureResult[logDepots.size()];
        int nrResults = 0;
        Iterator iter = logDepots.values().iterator();
        while (iter.hasNext()) {
            final LogDepot logDepot = (LogDepot)iter.next();
            results[nrResults] = new FutureResult();
            Runnable command = results[nrResults].setter(new Callable(){

                public Object call() {
                    TRACE__.traceInfo("Getting LDs from node: " + logDepot.getNodeDescription());
                    List logs = logDepot.getLogDescriptors();
                    TRACE__.traceDebug("Retrieved LDs: " + logs);
                    descriptor.setConnected(true);
                    descriptor.setConnectionErrorMessage("");
                    return logs;
                }
            });
            TRACE__.traceInfo("Execute for: " + logDepot.getNodeDescription());
            this.pool.execute(command);
            ++nrResults;
        }
        return results;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

