/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application;

import com.sapmarkets.bam.application.BrowsingCommand;
import com.sapmarkets.bam.logcontroller.QueryResultBrowser;
import com.sapmarkets.bam.util.Tracer;
import java.util.LinkedList;
import java.util.List;

class BrowsingThread
implements Runnable {
    private static final Tracer LOG = new Tracer(class$com$sapmarkets$bam$application$BrowsingThread == null ? (class$com$sapmarkets$bam$application$BrowsingThread = BrowsingThread.class$("com.sapmarkets.bam.application.BrowsingThread")) : class$com$sapmarkets$bam$application$BrowsingThread);
    private List commands = new LinkedList();
    private boolean stopIt;
    private BrowsingCommand currentCommand;
    private QueryResultBrowser resultBrowser;
    private long commandInterval;
    static /* synthetic */ Class class$com$sapmarkets$bam$application$BrowsingThread;

    public BrowsingThread(QueryResultBrowser resultBrowser, long commandInterval) {
        this.resultBrowser = resultBrowser;
        this.commandInterval = commandInterval;
    }

    public synchronized void addCommand(BrowsingCommand command) {
        LOG.traceInfo("BrowsingThread.add");
        this.commands.add(command);
        this.notifyAll();
    }

    public synchronized void stopCurrentCommand() {
        this.currentCommand.stopCommand();
    }

    public synchronized void stopBrowsing() {
        LOG.traceInfo("BrowsingThread.stopBrowsing");
        this.stopIt = true;
        this.stopCurrentCommand();
        this.resultBrowser.stopBrowsing();
    }

    public synchronized boolean isStopped() {
        return this.stopIt;
    }

    public void run() {
        while (!this.isStopped()) {
            BrowsingThread browsingThread = this;
            synchronized (browsingThread) {
                LOG.traceInfo("BrowsingThread.run: Inside synchronized");
                while (this.commands.size() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        LOG.logException(ex);
                    }
                }
                LOG.traceInfo("BrowsingThread.run: Get command");
                this.currentCommand = (BrowsingCommand)this.commands.remove(0);
            }
            if (this.currentCommand == null) continue;
            try {
                LOG.traceInfo("BrowsingThread.run: browse loop");
                int i = 0;
                while (!this.currentCommand.isCommandStopped()) {
                    LOG.traceInfo("BrowsingThread.run: browse block " + i++);
                    this.currentCommand.browse();
                    try {
                        Thread.sleep(this.commandInterval);
                    }
                    catch (InterruptedException ex) {
                        LOG.logException(ex);
                    }
                }
            }
            catch (Throwable ex) {
                this.currentCommand.handleException(ex);
            }
            this.currentCommand.handleCommandStopped();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

