/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application;

import com.sapmarkets.bam.application.AsyncQueryResultSet;
import com.sapmarkets.bam.application.QueryResultListener;
import com.sapmarkets.bam.logcontroller.LogQueryResultset;
import com.sapmarkets.bam.logcontroller.QueryResultBrowser;
import com.sapmarkets.bam.util.ReadLogRecordException;

abstract class BrowsingCommand {
    QueryResultListener listener;
    private boolean stopIt;
    private int blockSize;
    private QueryResultBrowser resultBrowser;
    private long counterRecordsRead;

    public BrowsingCommand(QueryResultBrowser resultBrowser, QueryResultListener listener, int blockSize) {
        this.resultBrowser = resultBrowser;
        this.listener = listener;
        this.blockSize = blockSize;
        this.counterRecordsRead = 0L;
    }

    public void stopCommand() {
        this.stopIt = true;
    }

    public boolean isCommandStopped() {
        return this.stopIt;
    }

    public void handleException(Throwable ex) {
        this.listener.handleException(ex);
    }

    public void handleCommandStopped() {
        this.listener.handleCommandStopped();
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    protected abstract LogQueryResultset createResultSet() throws ReadLogRecordException;

    public void browse() throws ReadLogRecordException {
        LogQueryResultset queryResultSet = this.createResultSet();
        AsyncQueryResultSet result = new AsyncQueryResultSet(queryResultSet, queryResultSet.isOldest(), queryResultSet.isLatest());
        this.counterRecordsRead += queryResultSet.getCounterOfRecordsRead();
        if (this.listener != null) {
            this.listener.handleResult(result);
        }
    }
}

