/*
 * Decompiled with CFR 0.152.
 */
package com.sapmarkets.bam.application;

import com.sap.tc.logging.Location;
import com.sapmarkets.bam.jmx.connector.ConnectionProtocol;
import com.sapmarkets.bam.jmx.connector.HostDescriptor;
import com.sapmarkets.bam.util.BAMConfigurationHandler;
import com.sapmarkets.bam.util.BAMRuntimeException;
import com.sapmarkets.bam.util.Logger;
import com.sapmarkets.bam.util.Tracer;
import com.sapmarkets.bam.util.XMLHelper;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BAMConfiguration {
    private static final Logger mLogger = new Logger(class$com$sapmarkets$bam$application$BAMConfiguration == null ? (class$com$sapmarkets$bam$application$BAMConfiguration = BAMConfiguration.class$("com.sapmarkets.bam.application.BAMConfiguration")) : class$com$sapmarkets$bam$application$BAMConfiguration);
    private static final Tracer mTracer = new Tracer(class$com$sapmarkets$bam$application$BAMConfiguration == null ? (class$com$sapmarkets$bam$application$BAMConfiguration = BAMConfiguration.class$("com.sapmarkets.bam.application.BAMConfiguration")) : class$com$sapmarkets$bam$application$BAMConfiguration);
    private File mBAMConfigFile;
    private Element mRoot = null;
    private Document mDocument = null;
    static /* synthetic */ Class class$com$sapmarkets$bam$application$BAMConfiguration;

    public BAMConfiguration(String aFileName) {
        this.mBAMConfigFile = new File(BAMConfigurationHandler.getFilePath(aFileName));
        mTracer.traceInfo("Loading BAMConfiguration (" + this.mBAMConfigFile + ")");
        if (this.mBAMConfigFile.exists() && this.mBAMConfigFile.isFile()) {
            try {
                this.mDocument = XMLHelper.buildDOMFromXML(new FileInputStream(this.mBAMConfigFile));
            }
            catch (Exception e) {
                mLogger.logException(e);
                throw new BAMRuntimeException(mLogger.getLocation(), "ERROR_READING_BAMCONFIG", new Object[]{this.mBAMConfigFile, e.getMessage()}, e);
            }
            this.mRoot = this.mDocument.getDocumentElement();
        } else {
            this.mDocument = XMLHelper.buildDOMFromScratch();
        }
    }

    public BAMConfiguration() {
        this("BAMConfiguration.xml");
    }

    public List getHostDescriptors() {
        return this.readHostDescriptors();
    }

    public void addHostDescriptor(HostDescriptor aHostDescriptor) {
        String connectionURL = aHostDescriptor.getConnectionURL();
        String connectionType = aHostDescriptor.getProtocol().toString();
        String routerString = aHostDescriptor.getRouterString();
        String userName = aHostDescriptor.getUser();
        String applicationName = aHostDescriptor.getApplicationName();
        boolean connect = aHostDescriptor.getConnect();
        Text url = this.mDocument.createTextNode(connectionURL);
        Element serverName = this.mDocument.createElement("ServerName");
        Text connectionText = this.mDocument.createTextNode(connectionType);
        Element ct = this.mDocument.createElement("ConnectionType");
        Text routerStringText = this.mDocument.createTextNode(routerString);
        Element rs = this.mDocument.createElement("RouterString");
        Text userText = this.mDocument.createTextNode(userName);
        Element user = this.mDocument.createElement("User");
        Element application = this.mDocument.createElement("Application");
        serverName.appendChild(url);
        ct.appendChild(connectionText);
        ct.setAttribute("Connect", String.valueOf(connect));
        rs.appendChild(routerStringText);
        user.appendChild(userText);
        application.appendChild(serverName);
        application.appendChild(ct);
        application.appendChild(rs);
        application.appendChild(user);
        application.setAttribute("Name", applicationName);
        if (null == this.mRoot) {
            this.mRoot = this.mDocument.createElement("Applications");
            this.mDocument.appendChild(this.mRoot);
        }
        this.mRoot.appendChild(application);
    }

    public void addAll(List aHostDescriptorList) {
        if (aHostDescriptorList == null || aHostDescriptorList.isEmpty()) {
            if (null == this.mRoot) {
                this.mRoot = this.mDocument.createElement("Applications");
                this.mDocument.appendChild(this.mRoot);
            }
            return;
        }
        Iterator i = aHostDescriptorList.iterator();
        while (i.hasNext()) {
            this.addHostDescriptor((HostDescriptor)i.next());
        }
    }

    public void deleteAll() {
        NodeList nodelist = this.mDocument.getChildNodes();
        int i = nodelist.getLength() - 1;
        while (i >= 0) {
            this.mDocument.removeChild(nodelist.item(i--));
        }
        this.mRoot = this.mDocument.createElement("Applications");
        this.mDocument.appendChild(this.mRoot);
    }

    public void deleteHostDescriptor(HostDescriptor aHostDescriptor) {
        List applications = XMLHelper.getSignificantChildNodes(this.mRoot);
        String applicationName = aHostDescriptor.getApplicationName();
        int i = applications.size() - 1;
        while (i >= 0) {
            Node node = (Node)applications.get(i);
            String name = XMLHelper.getAttributeValue(node, "Name");
            if (applicationName == name) {
                Node n = this.mRoot.removeChild(node);
                n = null;
                break;
            }
            --i;
        }
    }

    public void deleteAll(List aHostDescriptorList) {
        if (aHostDescriptorList == null) {
            return;
        }
        int i = 0;
        while (i < aHostDescriptorList.size()) {
            HostDescriptor hostDescriptor = (HostDescriptor)aHostDescriptorList.get(i);
            this.deleteHostDescriptor(hostDescriptor);
            ++i;
        }
    }

    public void saveConfiguration(Frame aFrame) throws BAMRuntimeException {
        try {
            List hostDescriptors = this.readHostDescriptors();
            mTracer.traceInfo("Writing " + hostDescriptors.size() + " hosts to <" + this.mBAMConfigFile + ">");
            XMLHelper.printDocumentToFile(this.mRoot, this.mBAMConfigFile);
        }
        catch (IOException exception) {
            throw new BAMRuntimeException(Location.getLocation(this.getClass()), "ERROR_READING_BAMCONFIG", new Object[]{this.mBAMConfigFile.getAbsolutePath(), exception.getMessage()}, exception);
        }
    }

    private List readHostDescriptors() {
        List list = XMLHelper.getSignificantChildNodes(this.mRoot);
        ArrayList<HostDescriptor> result = new ArrayList<HostDescriptor>(list.size());
        int i = 0;
        while (i < list.size()) {
            Node userNode;
            Node routerStringNode;
            Node connectionTypeNode;
            int indexOfColon;
            String URL2;
            String hostName = null;
            String portNumber = null;
            String routerString = null;
            String user = null;
            Object password = null;
            String connectionType = null;
            boolean connect = true;
            Node node = (Node)list.get(i);
            String name = XMLHelper.getAttributeValue(node, "Name");
            Node urlNode = XMLHelper.getChildNodeByTag(node, "ServerName");
            if (urlNode != null && (URL2 = XMLHelper.getTextBetweenTags(urlNode)).length() != 0 && (indexOfColon = URL2.indexOf(":")) >= 0) {
                hostName = URL2.substring(0, indexOfColon);
                portNumber = URL2.substring(indexOfColon + 1);
            }
            if ((connectionTypeNode = XMLHelper.getChildNodeByTag(node, "ConnectionType")) != null) {
                XMLHelper.getTextBetweenTags(connectionTypeNode);
                Properties p = XMLHelper.getAttributes(connectionTypeNode);
                connect = "true".equals(p.getProperty("Connect"));
                connectionType = XMLHelper.getTextBetweenTags(connectionTypeNode);
            }
            if ((routerStringNode = XMLHelper.getChildNodeByTag(node, "RouterString")) != null) {
                routerString = XMLHelper.getTextBetweenTags(routerStringNode);
            }
            if ((userNode = XMLHelper.getChildNodeByTag(node, "User")) != null) {
                user = XMLHelper.getTextBetweenTags(userNode);
            }
            hostName = hostName == null || "".equals(hostName) ? "localhost" : hostName;
            portNumber = portNumber == null || "".equals(portNumber) ? "1099" : portNumber;
            connectionType = connectionType == null || "".equals(connectionType) ? "standalone" : connectionType;
            routerString = routerString == null || "".equals(routerString) ? null : routerString;
            user = user == null || "".equals(user) ? null : user;
            HostDescriptor hostDescriptor = new HostDescriptor(hostName, portNumber, ConnectionProtocol.getProtocol(connectionType), connect, routerString, user, null, name);
            result.add(hostDescriptor);
            ++i;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

