/*
 * Decompiled with CFR 0.152.
 */
package com.sap.monitoring.logviewer;

import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.Severity;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;

public class LogDump {
    private static final String LISTFORMATTER_VERSION_TAG = "#1.5";
    private static final boolean debug = false;
    private final ListFormatter formatter = new ListFormatter();
    private static final SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd.MM.yyyy");
    private static final String SPACE = " ";
    private static final String DEFAULT_SERVER_LOGDIR = "/usr/sap/C11/JC00/j2ee/cluster/server0/log";
    private static File logDirectory = new File("/usr/sap/C11/JC00/j2ee/cluster/server0/log");
    private RandomAccessFile file;
    private long currentFilePos;
    private boolean isListFormatted = false;
    private static Map threadIds = new HashMap();
    private static Map allFiles = new HashMap();
    private static int nextThreadID = 0;
    private static boolean printLocation = false;
    private static boolean writeDirectory = false;
    private static boolean printCompleteFile = false;
    private static boolean isBatchMode = false;
    private static boolean printDate = false;
    private static String severityStr = null;
    private static final Short SHORT_ZERO = new Short("0");
    private static int minSeverity = 0;
    private static PrintWriter out = new PrintWriter(new BufferedOutputStream(System.out));
    private static final Location console = Location.getLocation((String)"std");
    private boolean isStdOut = false;
    private boolean isStdError = false;

    public LogDump(String fileName) throws IOException {
        this.file = new RandomAccessFile(fileName, "r");
        if (writeDirectory) {
            String nextLine = this.file.readLine();
            this.isListFormatted = nextLine.startsWith(LISTFORMATTER_VERSION_TAG);
        } else {
            this.currentFilePos = this.file.length();
            if (!printCompleteFile) {
                this.file.seek(this.currentFilePos);
            }
            File aFile = new File(fileName);
            this.isStdOut = aFile.getName().equalsIgnoreCase("output.log");
            this.isStdError = aFile.getName().equalsIgnoreCase("error.log");
        }
    }

    static void printString(String value, int width) {
        LogDump.printString(value, width, false);
    }

    static void printString(String value, int width, boolean leftPadding) {
        if (!leftPadding) {
            out.print(value);
        }
        int pad = width - value.length();
        int i = 0;
        while (i < pad) {
            out.print(SPACE);
            ++i;
        }
        if (leftPadding) {
            out.print(value);
        }
    }

    static ThreadInfo getThreadInfo(String threadName) {
        ThreadInfo ti = (ThreadInfo)threadIds.get(threadName);
        if (ti == null) {
            ti = new ThreadInfo(nextThreadID);
            ++nextThreadID;
            threadIds.put(threadName, ti);
        }
        return ti;
    }

    static String formatMessage(String msgClear, List params) {
        String result;
        try {
            result = MessageFormat.format(msgClear, params.toArray());
        }
        catch (Throwable th) {
            result = "msg [" + msgClear + "]  params [" + params + "]";
        }
        return result;
    }

    void printRecord(LogRecord record) {
        Date date = record.getTime();
        boolean printRec = true;
        if (severityStr != null && record.getSeverity() < minSeverity) {
            printRec = false;
        }
        if (printRec) {
            if (printDate) {
                out.print(dateFormatter.format(date));
                out.print(SPACE);
            }
            out.print(timeFormatter.format(date));
            out.print(SPACE);
        }
        ThreadInfo ti = LogDump.getThreadInfo(record.getThreadName());
        if (printRec) {
            LogDump.printString(ti.getThreadID(), 4, true);
            out.print(SPACE);
            String severity = Severity.toString((int)record.getSeverity()).toUpperCase();
            LogDump.printString(severity, 7);
            out.print(SPACE);
            if (printLocation) {
                LogDump.printString(record.getLocation(), 35);
                out.print(SPACE);
            }
        }
        int indent = record.getIndent();
        long time = 0L;
        if (indent == -1) {
            time = ti.decIndentLevel(date.getTime());
        }
        int currentIndent = ti.getIndentLevel();
        if (indent == 1) {
            ti.incIndentLevel(date.getTime());
        }
        if (printRec) {
            int i = 0;
            while (i < currentIndent) {
                out.print(SPACE);
                out.print(SPACE);
                ++i;
            }
            String msg = null;
            if (indent == 0) {
                String msgClear = record.getMsgClear();
                List list = record.getArgs();
                msg = !list.isEmpty() ? "(" + record.getId().toString() + ")" + LogDump.formatMessage(msgClear, list) : "(" + record.getId().toString() + ")" + msgClear;
            } else {
                String loc = record.getLocation();
                int lastDot = loc.lastIndexOf(46);
                if (lastDot > 0) {
                    lastDot = loc.lastIndexOf(46, lastDot - 1);
                }
                msg = loc.substring(++lastDot);
                if (indent == 1) {
                    msg = "entering " + msg;
                    List list = record.getArgs();
                    if (!list.isEmpty()) {
                        Iterator iterator = list.iterator();
                        msg = msg + "(";
                        int i2 = 0;
                        while (iterator.hasNext()) {
                            Object nextObj = iterator.next();
                            msg = msg + "{" + i2 + "}";
                            if (iterator.hasNext()) {
                                msg = msg + ", ";
                            }
                            ++i2;
                        }
                        msg = msg + ")";
                        msg = LogDump.formatMessage(msg, list);
                    }
                } else {
                    msg = "exiting " + msg + " (" + time + " ms)";
                }
            }
            out.println(msg);
        }
        out.flush();
    }

    static Short extractGUIDShort(String guidStr) {
        int lastIndex = guidStr.lastIndexOf(58);
        String shortStr = "0";
        if (lastIndex > 0) {
            shortStr = guidStr.substring(lastIndex + 1);
        }
        Short result = SHORT_ZERO;
        try {
            result = Short.valueOf(shortStr, 16);
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    void readNewRecords(TreeMap recordMap) throws IOException {
        StringBuffer prevLine = new StringBuffer();
        StringBuffer nextLine = new StringBuffer();
        while (this.file.getFilePointer() < this.file.length()) {
            boolean isEnd;
            nextLine.setLength(0);
            nextLine.append(this.file.readLine());
            String nextLineString = nextLine.toString();
            boolean isStart = nextLineString.indexOf(LISTFORMATTER_VERSION_TAG) == 0;
            boolean bl = isEnd = nextLineString.indexOf("\\#", nextLineString.length() - 4) == -1 && nextLineString.indexOf("#", nextLineString.length() - 2) != -1;
            if (isStart) {
                if (prevLine.length() > 0) {
                    this.parseMSG(recordMap, prevLine.toString(), true);
                }
                prevLine.setLength(0);
                prevLine.append((Object)nextLine);
                continue;
            }
            if (isEnd) {
                prevLine.append("\n");
                prevLine.append((Object)nextLine);
                this.parseMSG(recordMap, prevLine.toString(), true);
                prevLine.setLength(0);
                continue;
            }
            if (prevLine.length() > 0) {
                prevLine.append("\n");
                prevLine.append((Object)nextLine);
                continue;
            }
            this.parseMSG(recordMap, nextLine.toString(), false);
        }
        if (prevLine.length() > 0) {
            this.parseMSG(recordMap, prevLine.toString(), true);
        }
    }

    private void parseMSG(TreeMap recordMap, String msg, boolean isLoggingAPI) {
        if (msg.length() == 0) {
            return;
        }
        this.isListFormatted = isLoggingAPI;
        try {
            LogRecord record = null;
            if (isLoggingAPI) {
                record = this.formatter.parseMsg(msg);
                isLoggingAPI = false;
            } else {
                record = this.isStdOut ? console.infoT("[stdout] " + msg) : (this.isStdError ? console.errorT("[stderr] " + msg) : console.infoT("[std] " + msg));
            }
            long time = record.getTime().getTime();
            Long longVal = new Long(time *= 100000L);
            this.printRecord(record);
        }
        catch (ParseException ex) {
            System.out.println("Error: Could not parse line " + msg);
            ex.printStackTrace();
        }
    }

    void printAllRecords(TreeMap recordMap) {
        Iterator iterator = recordMap.values().iterator();
        while (iterator.hasNext()) {
            LogRecord record = (LogRecord)iterator.next();
            this.printRecord(record);
        }
    }

    static int processArguments(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-h")) {
                LogDump.usage();
            } else if (args[i].equals("-l") || args[i].equals("-location")) {
                printLocation = true;
            } else if (args[i].equals("-dir")) {
                writeDirectory = true;
            } else if (args[i].equals("-d") || args[i].equals("-date")) {
                printDate = true;
            } else if (args[i].equals("-c") || args[i].equals("-complete")) {
                printCompleteFile = true;
            } else if (args[i].equals("-o") || args[i].equals("-outfile")) {
                String fileName;
                if ((fileName = args[++i]) != null) {
                    try {
                        out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                    }
                    catch (Throwable th) {
                        System.out.println("invalid outfile option '" + fileName + "'");
                        LogDump.usage();
                    }
                }
                printCompleteFile = true;
                isBatchMode = true;
            } else if (args[i].equals("-p") || args[i].equals("-path")) {
                File logDirFile;
                if (!(logDirFile = new File(args[++i])).exists()) {
                    System.out.println("Error: invalid path/filename to server log . Directory/file does not exist.");
                    LogDump.usage();
                } else {
                    logDirectory = logDirFile;
                }
            } else if (args[i].equals("-s") || args[i].equals("-severity")) {
                severityStr = args[++i];
                try {
                    minSeverity = Severity.parse((String)severityStr);
                }
                catch (Throwable th) {
                    System.out.println("invalid severity option '" + args[i] + "'");
                    LogDump.usage();
                }
            } else {
                System.out.println("invalid option '" + args[i] + "'");
                LogDump.usage();
            }
            ++i;
        }
        return 0;
    }

    static void usage() {
        System.out.println("usage: java com.sap.util.LogDump [options]");
        System.out.println("options:");
        System.out.println("   -l[ocation]           print the source location of the message");
        System.out.println("   -d[ate]               print the date of the message");
        System.out.println("   -s[severity] <value>  MIN|DEBUG|PATH|INFO|WARNING|ERROR|FATAL");
        System.out.println("                         display only records with severity >= value");
        System.out.println("   -o[utfile] <filename> the filename where to write the output. Always writes");
        System.out.println("                         the complete file and terminates automatic.");
        System.out.println("   -c[omplete]           read complete file(s). Starts with the file header.");
        System.out.println("   -p[ath] <dir or logfile>  path to the server log directory or single file. If dir, contents of all files under dir are dumped");
        System.out.println("                         default path is : '/usr/sap/C11/JC00/j2ee/cluster/server0/log'");
        System.out.println("   -h[elp]               print help");
        System.exit(1);
    }

    static void addFileNameToView(String fName) throws IOException {
        File file = new File(fName);
        if (file.exists()) {
            String fileName = file.getPath();
            LogDump viewer = (LogDump)allFiles.get(fileName);
            if (viewer == null) {
                viewer = new LogDump(fileName);
                allFiles.put(fileName, viewer);
            }
        } else {
            System.out.println("File does not exist: " + fName);
        }
    }

    static void readAllNewRecords(TreeMap recordMap) throws IOException {
        Iterator iterator = allFiles.values().iterator();
        while (iterator.hasNext()) {
            LogDump viewer = (LogDump)iterator.next();
            viewer.readNewRecords(recordMap);
        }
    }

    static void getAllFileNamesFromDirectory(File dirFile) throws IOException {
        if (dirFile.isFile()) {
            LogDump.addFileNameToView(dirFile.getPath());
            return;
        }
        File[] fileArray = dirFile.listFiles(new FileFilter(){

            public boolean accept(File file) {
                try {
                    if (file.isDirectory()) {
                        LogDump.getAllFileNamesFromDirectory(file);
                    } else {
                        LogDump.addFileNameToView(file.getPath());
                    }
                }
                catch (IOException ex) {
                    System.err.println("Cannot read " + ex.getMessage());
                }
                return true;
            }
        });
    }

    public static void main(String[] args) {
        block6: {
            LogDump.processArguments(args);
            try {
                LogDump.getAllFileNamesFromDirectory(logDirectory);
                if (writeDirectory) {
                    Iterator i = allFiles.values().iterator();
                    while (i.hasNext()) {
                        LogDump l = (LogDump)i.next();
                        System.out.println(l.file.toString() + SPACE + (l.isListFormatted ? "List" : "ASCII"));
                    }
                    break block6;
                }
                while (true) {
                    TreeMap recordMap = new TreeMap();
                    LogDump.readAllNewRecords(recordMap);
                    if (isBatchMode) {
                        System.exit(0);
                    }
                    Thread.sleep(400L);
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    static {
        console.setEffectiveSeverity(300);
        console.addLog((Log)new FileLog("%t/logviewtrace.%g.log", 800000, 10, (Formatter)new ListFormatter()));
    }

    static class ThreadInfo {
        int tid;
        int indent;
        Stack times = new Stack();

        ThreadInfo(int value) {
            this.tid = value;
            this.indent = 0;
        }

        String getThreadID() {
            return "" + this.tid;
        }

        long decIndentLevel(long currentTime) {
            --this.indent;
            long diffTime = 0L;
            if (!this.times.isEmpty()) {
                Long time = (Long)this.times.pop();
                diffTime = currentTime - time;
            }
            return diffTime;
        }

        void incIndentLevel(long time) {
            this.times.push(new Long(time));
            ++this.indent;
        }

        int getIndentLevel() {
            return this.indent;
        }
    }
}

