/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.util.collections;

import java.util.EmptyStackException;

public class IntStack {
    private int[] intArray;
    private int currentPos = -1;
    private int initialCapacity;

    public IntStack() {
        this(10);
    }

    public IntStack(int initialCapacity) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("capacity must be at least 1");
        }
        this.initialCapacity = initialCapacity;
        this.intArray = new int[initialCapacity];
    }

    public int peek() {
        if (this.currentPos == -1) {
            throw new EmptyStackException();
        }
        return this.intArray[this.currentPos];
    }

    public int pop() {
        if (this.currentPos == -1) {
            throw new EmptyStackException();
        }
        return this.intArray[this.currentPos--];
    }

    public void push(int value) {
        if (this.currentPos == this.intArray.length - 1) {
            this.doubleCapacity();
        }
        this.intArray[++this.currentPos] = value;
    }

    private void doubleCapacity() {
        int[] temp = new int[this.intArray.length * 2];
        System.arraycopy(this.intArray, 0, temp, 0, this.intArray.length);
        this.intArray = temp;
    }

    public boolean isEmpty() {
        return this.currentPos == -1;
    }

    public void clear() {
        this.intArray = new int[this.initialCapacity];
        this.currentPos = -1;
    }
}

