/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.util.collections;

import java.util.EmptyStackException;

public class FloatStack {
    private float[] floatArray;
    private int currentPos = -1;
    private int initialCapacity;

    public FloatStack() {
        this(10);
    }

    public FloatStack(int initialCapacity) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("capacity must be at least 1");
        }
        this.initialCapacity = initialCapacity;
        this.floatArray = new float[initialCapacity];
    }

    public float peek() {
        if (this.currentPos == -1) {
            throw new EmptyStackException();
        }
        return this.floatArray[this.currentPos];
    }

    public float pop() {
        if (this.currentPos == -1) {
            throw new EmptyStackException();
        }
        return this.floatArray[this.currentPos--];
    }

    public void push(float value) {
        if (this.currentPos == this.floatArray.length - 1) {
            this.doubleCapacity();
        }
        this.floatArray[++this.currentPos] = value;
    }

    private void doubleCapacity() {
        float[] temp = new float[this.floatArray.length * 2];
        System.arraycopy(this.floatArray, 0, temp, 0, this.floatArray.length);
        this.floatArray = temp;
    }

    public boolean isEmpty() {
        return this.currentPos == -1;
    }

    public void clear() {
        this.floatArray = new float[this.initialCapacity];
        this.currentPos = -1;
    }
}

