/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.archive;

import com.sap.engine.services.log_configurator.archive.ArchivingTask;
import com.sap.engine.services.log_configurator.archive.Buffer;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ArchivingThread
implements Runnable {
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$log_configurator$archive$ArchivingThread == null ? (class$com$sap$engine$services$log_configurator$archive$ArchivingThread = ArchivingThread.class$("com.sap.engine.services.log_configurator.archive.ArchivingThread")) : class$com$sap$engine$services$log_configurator$archive$ArchivingThread));
    private static final int BUFFER_LENGTH = 10000;
    private Buffer buffer;
    String dirName;
    static /* synthetic */ Class class$com$sap$engine$services$log_configurator$archive$ArchivingThread;

    public ArchivingThread(Buffer buffer, String dirName) {
        this.buffer = buffer;
        this.dirName = dirName;
    }

    public void run() {
        while (true) {
            ArchivingTask task;
            if ((task = this.buffer.getTask()) == null) {
                continue;
            }
            this.archiveTask(task);
            this.buffer.removeTask(task);
        }
    }

    /*
     * Loose catch block
     */
    public void archiveTask(ArchivingTask task) {
        block16: {
            location.logT(100, " === THREAD ::: starts archiving of task No. [" + task.getNumber() + "]");
            location.logT(100, " === THREAD ::: task ---> " + task);
            ZipOutputStream zout = null;
            ZipEntry zipEntry = null;
            byte[] buffer = new byte[10000];
            String plainPattern = URLEncoder.encode(task.getPattern());
            String zipFileName = this.dirName + plainPattern + System.currentTimeMillis() + ".zip";
            zout = new ZipOutputStream(new FileOutputStream(zipFileName));
            String fileName = task.getNextFile();
            while (fileName != null) {
                String fullFileName;
                String zipEntryName;
                if (fileName.startsWith("_&&&_.")) {
                    String[] names = this.getRealFileName(task.getPattern(), fileName);
                    zipEntryName = this.getSimpleFileName(names[0]);
                    fullFileName = names[1];
                } else {
                    zipEntryName = this.getSimpleFileName(fileName);
                    fullFileName = fileName;
                }
                zipEntry = new ZipEntry(zipEntryName);
                long lastModified = new File(fullFileName).lastModified();
                zipEntry.setTime(lastModified);
                zout.putNextEntry(zipEntry);
                FileInputStream in = new FileInputStream(fullFileName);
                while (in.available() != 0) {
                    int readed = in.read(buffer);
                    if (readed <= 0) continue;
                    zout.write(buffer, 0, readed);
                }
                in.close();
                ((FilterOutputStream)zout).flush();
                ((FilterOutputStream)zout).flush();
                zout.closeEntry();
                fileName = task.getNextFile();
            }
            Object var15_17 = null;
            try {
                task.finish();
                zout.finish();
                zout.close();
            }
            catch (IOException e) {
                location.logT(400, " Can't close zipfile '" + zipFileName + "'.");
            }
            break block16;
            {
                catch (FileNotFoundException fnfex) {
                    location.logT(500, " Can't find file = " + fnfex.getMessage());
                    fnfex.printStackTrace();
                    Object var15_18 = null;
                    try {
                        task.finish();
                        zout.finish();
                        zout.close();
                    }
                    catch (IOException e) {
                        location.logT(400, " Can't close zipfile '" + zipFileName + "'.");
                    }
                    break block16;
                }
                catch (IOException ioex) {
                    location.logT(500, " IOException = " + ioex.getMessage());
                    ioex.printStackTrace();
                    Object var15_19 = null;
                    try {
                        task.finish();
                        zout.finish();
                        zout.close();
                    }
                    catch (IOException e) {
                        location.logT(400, " Can't close zipfile '" + zipFileName + "'.");
                    }
                    break block16;
                }
                catch (Exception ex) {
                    location.logT(500, " Exception = " + ex.getMessage());
                    ex.printStackTrace();
                    Object var15_20 = null;
                    try {
                        task.finish();
                        zout.finish();
                        zout.close();
                    }
                    catch (IOException e) {
                        location.logT(400, " Can't close zipfile '" + zipFileName + "'.");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_21 = null;
                try {
                    task.finish();
                    zout.finish();
                    zout.close();
                }
                catch (IOException e) {
                    location.logT(400, " Can't close zipfile '" + zipFileName + "'.");
                }
                throw throwable;
            }
        }
    }

    public String[] getRealFileName(String pattern, String fileName) {
        String fullFileName;
        String zipEntryName;
        String[] names = new String[2];
        StringTokenizer tok = new StringTokenizer(fileName, ".");
        String[] elements = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            elements[i] = tok.nextToken();
            ++i;
        }
        int num = Integer.parseInt(elements[2]);
        int count = Integer.parseInt(elements[3]);
        List fileNames = (List)FileLog.calculateFileNames((String)pattern, (int)count);
        names[0] = zipEntryName = fileNames.get(num).toString();
        names[1] = fullFileName = this.buffer.getTmpDir() + fileName;
        return names;
    }

    private String getSimpleFileName(String name) {
        return name.substring(name.lastIndexOf("\\") + 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

