/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.shell;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogControllerDescriptor;
import com.sap.engine.lib.logging.descriptors.LogDestinationDescriptor;
import com.sap.engine.lib.logging.descriptors.LogFormatterDescriptor;
import com.sap.engine.services.log_configurator.admin.LogConfigurator;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public final class LogRemoveCommand
implements Command {
    public static final String COMMAND_NAME = "LOG_REMOVE";
    public static final String COMMAND_GROUP = "LOG";
    public static final String HELP_MESSAGE = "\nRemoves previously configured objects from the logging service.\n\nUsage: LOG_REMOVE [-? | -H]  [-C | -D | -F OID]\n\n  -? | -H          Displays this Help Message.\n  -C | -D | -F     Specifies the type of the object that is going\n                   to be removed as log(C)ontroler, log (D)estination\n                   or (F)ormatter respectively.\n  OID              ID of the object that is going to be removed.\n\nThe OID identifier must represent a valid Name for the logging service.\nOne can use the LOG_LIST command to retrieve the necessary information.\nNote that only \"named\" objects can be removed (name is case sensitive)\nand that this operation will affect all the users of the corresponding\nobject.\n";
    private LogConfigurator logConfigurator = null;

    public LogRemoveCommand(LogConfigurator logConfigurator) {
        this.logConfigurator = logConfigurator;
    }

    public String getName() {
        return COMMAND_NAME;
    }

    public String getGroup() {
        return COMMAND_GROUP;
    }

    public String getHelpMessage() {
        return HELP_MESSAGE;
    }

    public String[] getSupportedShellProviderNames() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os, true);
        PrintStream err = new PrintStream(env.getErrorStream(), true);
        switch (params.length) {
            case 1: {
                String argument = params[0].toUpperCase();
                if (argument.equals("-?") || argument.equals("-H")) {
                    out.println(HELP_MESSAGE);
                    return;
                }
                if (!(argument.equals("-C") || argument.equals("-D") || argument.equals("-F"))) {
                    err.println();
                    err.println("LOG_REMOVE command is used with incorrect argument: " + params[0] + " !!!");
                    err.println("Use: LOG_REMOVE -? for Help.");
                    err.println();
                    return;
                }
                err.println();
                err.println("Required argument is missing !!!");
                err.println("Use: LOG_REMOVE -? for Help.");
                err.println();
                return;
            }
            case 2: {
                try {
                    String argument = params[0].toUpperCase();
                    LogConfiguration cfg = new LogConfiguration();
                    BufferedReader in = new BufferedReader(new InputStreamReader(is));
                    if (argument.equals("-C")) {
                        LogControllerDescriptor existingController = this.logConfigurator.getLogControllerDescriptor(params[1]);
                        if (existingController == null) {
                            err.println();
                            err.println("A log controller with name \"" + params[1] + "\" does NOT exist !!!");
                            err.println("Use: LOG_REMOVE -? for Help.");
                            err.println();
                            return;
                        }
                        cfg.addLogController(existingController);
                    } else if (argument.equals("-D")) {
                        LogDestinationDescriptor existingDestination = this.logConfigurator.getLogDescriptor(params[1]);
                        if (existingDestination == null) {
                            err.println();
                            err.println("A log destination with name \"" + params[1] + "\" does NOT exist !!!");
                            err.println("Use: LOG_REMOVE -? for Help.");
                            err.println();
                            return;
                        }
                        cfg.addLogDestination(existingDestination);
                    } else {
                        if (!argument.equals("-F")) {
                            err.println();
                            err.println("LOG_REMOVE command is used with incorrect argument: " + params[0] + " !!!");
                            err.println("Use: LOG_REMOVE -? for Help.");
                            err.println();
                            return;
                        }
                        LogFormatterDescriptor existingFormatter = this.logConfigurator.getFormatterDescriptor(params[1]);
                        if (existingFormatter == null) {
                            err.println();
                            err.println("A log formatter with name \"" + params[1] + "\" does NOT exist !!!");
                            err.println("Use: LOG_REMOVE -? for Help.");
                            err.println();
                            return;
                        }
                        cfg.addLogFormatter(existingFormatter);
                    }
                    out.println();
                    out.println("Store this configuration for future use ? (Y/N)");
                    out.println();
                    if (in.readLine().trim().equalsIgnoreCase("n")) {
                        this.logConfigurator.applyConfiguration(null, cfg);
                    } else {
                        this.logConfigurator.applyAndStoreConfiguration(null, cfg);
                    }
                    out.println();
                    out.println("The operation completed successfully.");
                    out.println();
                    return;
                }
                catch (Exception exc) {
                    err.println();
                    err.println("  The following Exception has occurred: " + exc.toString());
                    err.println();
                }
                return;
            }
        }
        err.println();
        err.println("LOG_REMOVE command is used with incorrect number of arguments !!!");
        err.println("Use: LOG_REMOVE -? for Help.");
        err.println();
    }
}

