/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.shell;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.log_configurator.admin.LogConfigurator;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;

public final class LogListCommand
implements Command {
    public static final String COMMAND_NAME = "LOG_LIST";
    public static final String COMMAND_GROUP = "LOG";
    public static final String HELP_MESSAGE = "\nShows information about the currently configured objects in the logging service.\n\nUsage: LOG_LIST [-? | -H]  [-T]  [-C | -D | -F [OID | -T]]\n\n  -? | -H          Displays this Help Message.\n  -C | -D | -F     Specifies the type of the object(s) that is(are) going\n                   to be listed as log(C)ontroler, log (D)estination\n                   or (F)ormatter respectively.\n  -T               Specifies that a (T)horough info should be provided.\n  OID              ID of the object that is going to be inspected.\n\nThe OID identifier must represent a valid Name for the logging service.\nNote that only \"named\" objects can be displayed (name is case sensitive).\nIf the command is used without arguments it provides a complete listing\nof all the registered objects' names sorted by their corresponding types.\nIf it is executed with a type specifier but with NO object identifier\nthen this command lists the name of each and every object of the respective\ntype that is configured with the logging service. The -T switch can be used\nas a single argument or after a preceding type specifier argument (i.e. -C,\n-D, or -F). In this case the command behaves as described above (i.e. as if\nNO -T was present) with the slight difference that a detailed information\nwill be provided for the appropriate objects instead of simple listing of\ntheir names. The object identifier (i.e. the name of an object as printed\nby this command) is intended for displaying of thorough information about\nthe settings of a particular object only. It must be used with a preceding\ntype specifier but WITHOUT the -T switch. The -T switch might be used only\nwhen NO object ID is given.\n";
    private LogConfigurator logConfigurator = null;

    public LogListCommand(LogConfigurator logConfigurator) {
        this.logConfigurator = logConfigurator;
    }

    public String getName() {
        return COMMAND_NAME;
    }

    public String getGroup() {
        return COMMAND_GROUP;
    }

    public String getHelpMessage() {
        return HELP_MESSAGE;
    }

    public String[] getSupportedShellProviderNames() {
        return null;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os, true);
        PrintStream err = new PrintStream(env.getErrorStream(), true);
        switch (params.length) {
            case 0: {
                LogConfigurator logConfigurator = this.logConfigurator;
                synchronized (logConfigurator) {
                    out.println("\n-----------------------------------------------------------------------------");
                    out.println("             Logging Information on " + new Date().toString());
                    out.println("-----------------------------------------------------------------------------");
                    this.logConfigurator.listLogControllersNames(out);
                    this.logConfigurator.listLogsNames(out);
                    this.logConfigurator.listFormattersNames(out);
                    out.println("-----------------------------------------------------------------------------\n");
                }
                return;
            }
            case 1: {
                String argument = params[0].toUpperCase();
                if (argument.equals("-?") || argument.equals("-H")) {
                    out.println(HELP_MESSAGE);
                } else if (argument.equals("-C")) {
                    out.println("\n-----------------------------------------------------------------------------");
                    out.println("             Logging Information on " + new Date().toString());
                    out.println("-----------------------------------------------------------------------------");
                    this.logConfigurator.listLogControllersNames(out);
                    out.println("-----------------------------------------------------------------------------\n");
                } else if (argument.equals("-D")) {
                    out.println("\n-----------------------------------------------------------------------------");
                    out.println("             Logging Information on " + new Date().toString());
                    out.println("-----------------------------------------------------------------------------");
                    this.logConfigurator.listLogsNames(out);
                    out.println("-----------------------------------------------------------------------------\n");
                } else if (argument.equals("-F")) {
                    out.println("\n-----------------------------------------------------------------------------");
                    out.println("             Logging Information on " + new Date().toString());
                    out.println("-----------------------------------------------------------------------------");
                    this.logConfigurator.listFormattersNames(out);
                    out.println("-----------------------------------------------------------------------------\n");
                } else if (argument.equals("-T")) {
                    LogConfigurator logConfigurator = this.logConfigurator;
                    synchronized (logConfigurator) {
                        out.println("\n-----------------------------------------------------------------------------");
                        out.println("             Logging Information on " + new Date().toString());
                        out.println("-----------------------------------------------------------------------------");
                        this.logConfigurator.listLogControllers(null, out);
                        this.logConfigurator.listLogs(null, out);
                        this.logConfigurator.listFormatters(null, out);
                        out.println("-----------------------------------------------------------------------------\n");
                    }
                } else {
                    err.println();
                    err.println("LOG_LIST command is used with incorrect argument: " + params[0] + " !!!");
                    err.println("Use: LOG_LIST -? for Help.");
                    err.println();
                }
                return;
            }
            case 2: {
                String argument = params[0].toUpperCase();
                if (argument.equals("-C")) {
                    if (params[1].equalsIgnoreCase("-T")) {
                        out.println("\n-----------------------------------------------------------------------------");
                        out.println("             Logging Information on " + new Date().toString());
                        out.println("-----------------------------------------------------------------------------");
                        this.logConfigurator.listLogControllers(null, out);
                        out.println("-----------------------------------------------------------------------------\n");
                    } else if (this.logConfigurator.existsLogController(params[1])) {
                        out.println("\n-----------------------------------------------------------------------------");
                        out.println("             Logging Information on " + new Date().toString());
                        out.println("-----------------------------------------------------------------------------");
                        this.logConfigurator.listLogControllers(new String[]{params[1]}, out);
                        out.println("-----------------------------------------------------------------------------\n");
                    } else {
                        err.println();
                        err.println("A log controller with name \"" + params[1] + "\" does NOT exist !!!");
                        err.println("Use: LOG_LIST -? for Help.");
                        err.println();
                    }
                } else if (argument.equals("-D")) {
                    if (params[1].equalsIgnoreCase("-T")) {
                        out.println("\n-----------------------------------------------------------------------------");
                        out.println("             Logging Information on " + new Date().toString());
                        out.println("-----------------------------------------------------------------------------");
                        this.logConfigurator.listLogs(null, out);
                        out.println("-----------------------------------------------------------------------------\n");
                    } else if (this.logConfigurator.existsLog(params[1])) {
                        out.println("\n-----------------------------------------------------------------------------");
                        out.println("             Logging Information on " + new Date().toString());
                        out.println("-----------------------------------------------------------------------------");
                        this.logConfigurator.listLogs(new String[]{params[1]}, out);
                        out.println("-----------------------------------------------------------------------------\n");
                    } else {
                        err.println();
                        err.println("A log destination with name \"" + params[1] + "\" does NOT exist !!!");
                        err.println("Use: LOG_LIST -? for Help.");
                        err.println();
                    }
                } else if (argument.equals("-F")) {
                    if (params[1].equalsIgnoreCase("-T")) {
                        out.println("\n-----------------------------------------------------------------------------");
                        out.println("             Logging Information on " + new Date().toString());
                        out.println("-----------------------------------------------------------------------------");
                        this.logConfigurator.listFormatters(null, out);
                        out.println("-----------------------------------------------------------------------------\n");
                    } else if (this.logConfigurator.existsFormatter(params[1])) {
                        out.println("\n-----------------------------------------------------------------------------");
                        out.println("             Logging Information on " + new Date().toString());
                        out.println("-----------------------------------------------------------------------------");
                        this.logConfigurator.listFormatters(new String[]{params[1]}, out);
                        out.println("-----------------------------------------------------------------------------\n");
                    } else {
                        err.println();
                        err.println("A log formatter with name \"" + params[1] + "\" does NOT exist !!!");
                        err.println("Use: LOG_LIST -? for Help.");
                        err.println();
                    }
                } else {
                    err.println();
                    err.println("LOG_LIST command is used with incorrect argument: " + params[0] + " !!!");
                    err.println("Use: LOG_LIST -? for Help.");
                    err.println();
                }
                return;
            }
        }
        err.println();
        err.println("LOG_LIST command is used with incorrect number of arguments !!!");
        err.println("Use: LOG_LIST -? for Help.");
        err.println();
    }
}

