/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.shell;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogControllerDescriptor;
import com.sap.engine.lib.logging.descriptors.LogDestinationDescriptor;
import com.sap.engine.lib.logging.descriptors.LogFormatterDescriptor;
import com.sap.engine.lib.util.Set;
import com.sap.engine.services.log_configurator.admin.LogConfigurator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public final class LogCreateCommand
implements Command {
    public static final String COMMAND_NAME = "LOG_CREATE";
    public static final String COMMAND_GROUP = "LOG";
    public static final String HELP_MESSAGE = "\nCreates and registers new objects into the logging service.\n\nUsage: LOG_CREATE [-? | -H]  [-C | -D | -F OID]\n\n  -? | -H          Displays this Help Message.\n  -C | -D | -F     Specifies the type of the object that is going\n                   to be created as log(C)ontroler, log (D)estination\n                   or (F)ormatter respectively.\n  OID              ID of the object that is going to be created.\n\nThe OID identifier must represent a unique Name for the logging service.\nOne can use the LOG_LIST command to obtain information about the existing\nobjects. To change the settings of this newly created object later one is\nentitled to use the LOG_EDIT command.\n";
    public static final String SAP_LOG_FORMATTERS = "ListFormatter, TraceFormatter, XMLFormatter";
    public static final String SAP_LOG_DESTINATIONS = "ConsoleLog, FileLog";
    public static final String SAP_LOG_SEVERITIES = "ALL, DEBUG, PATH, INFO, WARNING, ERROR, FATAL, MIN, MAX, GROUP, NONE";
    public static final String ASSOCIATION_TYPE_PUBLIC = "LOG";
    public static final String ASSOCIATION_TYPE_PRIVATE = "PRIVATE_LOG";
    public static final String ASSOCIATION_TYPE_LOCAL = "LOCAL_LOG";
    private LogConfigurator logConfigurator = null;

    public LogCreateCommand(LogConfigurator logConfigurator) {
        this.logConfigurator = logConfigurator;
    }

    public String getName() {
        return COMMAND_NAME;
    }

    public String getGroup() {
        return "LOG";
    }

    public String getHelpMessage() {
        return HELP_MESSAGE;
    }

    public String[] getSupportedShellProviderNames() {
        return null;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os, true);
        PrintStream err = new PrintStream(env.getErrorStream(), true);
        switch (params.length) {
            case 1: {
                String argument = params[0].toUpperCase();
                if (argument.equals("-?") || argument.equals("-H")) {
                    out.println(HELP_MESSAGE);
                } else if (argument.equals("-C") || argument.equals("-D") || argument.equals("-F")) {
                    err.println();
                    err.println("Required argument is missing !!!");
                    err.println("Use: LOG_CREATE -? for Help.");
                    err.println();
                } else {
                    err.println();
                    err.println("LOG_CREATE command is used with incorrect argument: " + params[0] + " !!!");
                    err.println("Use: LOG_CREATE -? for Help.");
                    err.println();
                }
                return;
            }
            case 2: {
                try {
                    String argument = params[0].toUpperCase();
                    LogConfiguration cfg = new LogConfiguration();
                    BufferedReader in = new BufferedReader(new InputStreamReader(is));
                    if (argument.equals("-C")) {
                        if (this.logConfigurator.existsLogController(params[1])) {
                            err.println();
                            err.println("A log controller with name \"" + params[1] + "\" already exists !!!");
                            err.println("Use LOG_EDIT command to adjust this object,");
                            err.println("or type \"LOG_CREATE -?\" for help on this command.");
                            err.println();
                            return;
                        }
                        LogControllerDescriptor controller = LogCreateCommand.acquireLogController(in, out, this.logConfigurator, params[1]);
                        LogDestinationDescriptor[] dests = (LogDestinationDescriptor[])controller.getAssociatedDestinations().getAllKeys((Object[])new LogDestinationDescriptor[0], 0);
                        int i = dests.length;
                        while (--i >= 0) {
                            LogFormatterDescriptor formatter = dests[i].getFormatter();
                            if (formatter != null && formatter.getName() != null) {
                                cfg.addLogFormatter(formatter);
                            }
                            if (dests[i].getName() == null) continue;
                            cfg.addLogDestination(dests[i]);
                        }
                        cfg.addLogController(controller);
                    } else if (argument.equals("-D")) {
                        if (this.logConfigurator.existsLog(params[1])) {
                            err.println();
                            err.println("A log destination with name \"" + params[1] + "\" already exists !!!");
                            err.println("Use LOG_EDIT command to adjust this object,");
                            err.println("or type \"LOG_CREATE -?\" for help on this command.");
                            err.println();
                            return;
                        }
                        LogDestinationDescriptor dest = LogCreateCommand.acquireLogDestination(in, out, this.logConfigurator, params[1]);
                        LogFormatterDescriptor formatter = dest.getFormatter();
                        if (formatter != null && formatter.getName() != null) {
                            cfg.addLogFormatter(formatter);
                        }
                        cfg.addLogDestination(dest);
                    } else if (argument.equals("-F")) {
                        if (this.logConfigurator.existsFormatter(params[1])) {
                            err.println();
                            err.println("A formatter with name \"" + params[1] + "\" already exists !!!");
                            err.println("Use LOG_EDIT command to adjust this object,");
                            err.println("or type \"LOG_CREATE -?\" for help on this command.");
                            err.println();
                            return;
                        }
                        cfg.addLogFormatter(LogCreateCommand.acquireLogFormatter(in, out, this.logConfigurator, params[1]));
                    } else {
                        err.println();
                        err.println("LOG_CREATE command is used with incorrect argument: " + params[0] + " !!!");
                        err.println("Use: LOG_CREATE -? for Help.");
                        err.println();
                        return;
                    }
                    out.println();
                    out.println("Store this configuration for future use ? (Y/N)");
                    out.println();
                    if (in.readLine().trim().equalsIgnoreCase("n")) {
                        this.logConfigurator.applyConfiguration(cfg);
                    } else {
                        this.logConfigurator.applyAndStoreConfiguration(cfg);
                    }
                    out.println();
                    out.println("The operation completed successfully.");
                    out.println();
                }
                catch (Exception exc) {
                    err.println();
                    err.println("  The following Exception has occurred: " + exc.toString());
                    err.println();
                }
                return;
            }
        }
        err.println();
        err.println("LOG_CREATE command is used with incorrect number of arguments !!!");
        err.println("Use: LOG_CREATE -? for Help.");
        err.println();
    }

    static LogFormatterDescriptor acquireLogFormatter(BufferedReader in, PrintStream out, LogConfigurator logConfigurator, String name) throws IOException {
        LogFormatterDescriptor existingFormatter;
        LogFormatterDescriptor formatter = new LogFormatterDescriptor();
        if (name == null) {
            out.println();
            out.println("Please type a name for the formatter. You may use any of the existing,");
            out.println("provide one of your own, or none for an anonymous formatter.");
            out.println();
            name = in.readLine().trim();
        }
        if (!name.equals("")) {
            formatter.setName(name);
        }
        if ((existingFormatter = logConfigurator.getFormatterDescriptor(name)) != null) {
            return existingFormatter;
        }
        String attrib = null;
        out.println();
        out.println("Please enter the type of the formatter. You may use any of the following:");
        out.println("  ListFormatter, TraceFormatter, XMLFormatter");
        out.println("or provide a fully qualified class name of your own.");
        out.println();
        attrib = in.readLine().trim();
        formatter.setType(attrib);
        if (attrib.equals("TraceFormatter")) {
            out.println();
            out.println("Please type a pattern for the formatter, if necessary,");
            out.println("or simply press Enter to try using the defaults.");
            out.println();
            attrib = in.readLine().trim();
            if (!attrib.equals("")) {
                formatter.setPattern(attrib);
            }
        }
        return formatter;
    }

    static LogDestinationDescriptor acquireLogDestination(BufferedReader in, PrintStream out, LogConfigurator logConfigurator, String name) throws IOException {
        LogDestinationDescriptor existingDestination;
        LogDestinationDescriptor destination = new LogDestinationDescriptor();
        if (name == null) {
            out.println();
            out.println("Please type a name for the log destination. You may use any of the existing,");
            out.println("provide one of your own, or none for an anonymous destination.");
            out.println();
            name = in.readLine().trim();
        }
        if (!name.equals("")) {
            destination.setName(name);
        }
        if ((existingDestination = logConfigurator.getLogDescriptor(name)) != null) {
            return existingDestination;
        }
        String attrib = null;
        out.println();
        out.println("Please enter the type of the destination. You may use any of the following:");
        out.println("  ConsoleLog, FileLog");
        out.println("or provide a fully qualified class name of your own.");
        out.println();
        attrib = in.readLine().trim();
        destination.setType(attrib);
        if (attrib.equals("FileLog")) {
            out.println();
            out.println("Please type a file pattern for the destination.");
            out.println();
            destination.setPattern(in.readLine());
            out.println();
            out.println("Please type a file length limit (in bytes), if necessary,");
            out.println("or simply press Enter to try using the defaults. The file length");
            out.println("limit works only in conjunction with a file count limit.");
            out.println();
            attrib = in.readLine().trim();
            if (!attrib.equals("")) {
                destination.setLimit(Integer.parseInt(attrib));
            }
            out.println();
            out.println("Please type a file count limit, if necessary,");
            out.println("or simply press Enter to try using the defaults. The file count");
            out.println("limit works only in conjunction with a file length limit.");
            out.println();
            attrib = in.readLine().trim();
            if (!attrib.equals("")) {
                destination.setCount(Integer.parseInt(attrib));
            }
        }
        out.println();
        out.println("Please type an encoding for the destination, if necessary,");
        out.println("or simply press Enter to try using the defaults.");
        out.println();
        attrib = in.readLine().trim();
        if (!attrib.equals("")) {
            destination.setEncoding(attrib);
        }
        out.println();
        out.println("Please type an effective severity for the destination, if necessary,");
        out.println("or simply press Enter to try using the defaults. The severity should");
        out.println("be any of the following strings:");
        out.println("  ALL, DEBUG, PATH, INFO, WARNING, ERROR, FATAL, MIN, MAX, GROUP, NONE");
        out.println();
        attrib = in.readLine().trim();
        if (!attrib.equals("")) {
            destination.setEffectiveSeverity(attrib);
        }
        out.println();
        out.println("Specify formatter for the destination ? (Y/N)");
        out.println();
        if (in.readLine().trim().equalsIgnoreCase("y")) {
            destination.setFormatter(LogCreateCommand.acquireLogFormatter(in, out, logConfigurator, null));
        }
        destination.addFilters(LogCreateCommand.acquireLogFilters(in, out));
        return destination;
    }

    static LogControllerDescriptor acquireLogController(BufferedReader in, PrintStream out, LogConfigurator logConfigurator, String name) throws IOException {
        LogControllerDescriptor controller = new LogControllerDescriptor();
        controller.setName(name);
        String attrib = null;
        out.println();
        out.println("Please type a ResourceBundle name for the controller, if necessary,");
        out.println("or simply press Enter to try using the defaults.");
        out.println();
        attrib = in.readLine().trim();
        if (!attrib.equals("")) {
            controller.setBundleName(attrib);
        }
        out.println();
        out.println("Please type a minimum severity for the controller, if necessary,");
        out.println("or simply press Enter to try using the defaults. The severity should");
        out.println("be any of the following strings:");
        out.println("  ALL, DEBUG, PATH, INFO, WARNING, ERROR, FATAL, MIN, MAX, GROUP, NONE");
        out.println();
        attrib = in.readLine().trim();
        if (!attrib.equals("")) {
            controller.setMinSeverity(attrib);
        }
        out.println();
        out.println("Please type a maximum severity for the controller, if necessary,");
        out.println("or simply press Enter to try using the defaults. The severity should");
        out.println("be any of the following strings:");
        out.println("  ALL, DEBUG, PATH, INFO, WARNING, ERROR, FATAL, MIN, MAX, GROUP, NONE");
        out.println();
        attrib = in.readLine().trim();
        if (!attrib.equals("")) {
            controller.setMaxSeverity(attrib);
        }
        out.println();
        out.println("Please type an effective severity for the controller, if necessary,");
        out.println("or simply press Enter to try using the defaults. The severity should");
        out.println("be any of the following strings:");
        out.println("  ALL, DEBUG, PATH, INFO, WARNING, ERROR, FATAL, MIN, MAX, GROUP, NONE");
        out.println();
        attrib = in.readLine().trim();
        if (!attrib.equals("")) {
            controller.setEffectiveSeverity(attrib);
        }
        out.println();
        out.println("Allow Database logging for the controller ? (Y/N)");
        out.println();
        if (in.readLine().trim().equalsIgnoreCase("n")) {
            controller.setDBLog(false);
        }
        out.println();
        out.println("Specify log destination(s) for the controller ? (Y/N)");
        out.println();
        while (in.readLine().trim().equalsIgnoreCase("y")) {
            out.println();
            out.println("Please specify the association type for the destination to be applied.");
            out.println("It should be any of the following strings:");
            out.println("  LOG, PRIVATE_LOG, LOCAL_LOG");
            out.println();
            attrib = in.readLine().trim();
            byte type = -1;
            if (attrib.equalsIgnoreCase("LOG")) {
                type = 0;
            } else if (attrib.equalsIgnoreCase(ASSOCIATION_TYPE_PRIVATE)) {
                type = 1;
            } else if (attrib.equalsIgnoreCase(ASSOCIATION_TYPE_LOCAL)) {
                type = 2;
            } else {
                throw new IllegalArgumentException("Invalid Association Type: " + attrib + " !!!");
            }
            controller.addDestination(LogCreateCommand.acquireLogDestination(in, out, logConfigurator, null), type);
            out.println();
            out.println("Add another log destination ? (Y/N)");
            out.println();
        }
        controller.addFilters(LogCreateCommand.acquireLogFilters(in, out));
        return controller;
    }

    static String[] acquireLogFilters(BufferedReader in, PrintStream out) throws IOException {
        Set filters = new Set();
        out.println();
        out.println("Add filter(s) to the object ? (Y/N)");
        out.println();
        while (in.readLine().trim().equalsIgnoreCase("y")) {
            out.println();
            out.println("Please type the fully qualified class name of the filter.");
            out.println();
            filters.add((Object)in.readLine().trim());
            out.println();
            out.println("Add another filter ? (Y/N)");
            out.println();
        }
        return (String[])filters.toArray((Object[])new String[filters.size()]);
    }
}

