/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.gui;

import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogControllerDescriptor;
import com.sap.engine.services.log_configurator.admin.gui.LogControllerPanel;
import com.sap.engine.services.log_configurator.admin.gui.RelativeControllersModel;
import com.sap.tc.logging.Severity;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class RelativeControllersDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private RelativeControllersModel model;
    private JTable table;
    private JButton okBtn;
    private JButton cancelBtn;
    private JButton addBtn;
    private JButton removeBtn;
    private static final String OK_CMD = "OK";
    private static final String CANCEL_CMD = "CANCEL";
    private static final String ADD_CMD = "ADD";
    private static final String REMOVE_CMD = "REMOVE";
    private boolean modalResult = false;
    private LogConfiguration config;
    private String controllerName;

    public RelativeControllersDialog(Frame mainFrame) {
        super(mainFrame, "Relative Controllers", true);
        this.init();
    }

    private void init() {
        ((Component)this).setSize(500, 300);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)this).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.model = new RelativeControllersModel();
        this.table = new JTable(this.model);
        this.table.setRowHeight(24);
        this.table.setBorder(BorderFactory.createLoweredBevelBorder());
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setSelectionMode(0);
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setBorder(BorderFactory.createEtchedBorder());
        JComboBox<String> comboBox = new JComboBox<String>(LogControllerPanel.severityArr);
        DefaultCellEditor editor = new DefaultCellEditor(comboBox);
        TableColumnModel columnModel = this.table.getColumnModel();
        this.initColumn(columnModel.getColumn(0), editor, "Controller name", 300, true);
        this.initColumn(columnModel.getColumn(1), editor, "Min", 100, false);
        this.initColumn(columnModel.getColumn(2), editor, "Max", 100, false);
        this.initColumn(columnModel.getColumn(3), editor, "Effective", 100, false);
        this.addBtn = new JButton("Add");
        this.addBtn.setActionCommand(ADD_CMD);
        this.addBtn.addActionListener(this);
        this.removeBtn = new JButton("Remove");
        this.removeBtn.setActionCommand(REMOVE_CMD);
        this.removeBtn.addActionListener(this);
        this.removeBtn.setEnabled(false);
        this.okBtn = new JButton(OK_CMD);
        this.okBtn.setActionCommand(OK_CMD);
        this.okBtn.addActionListener(this);
        this.okBtn.setPreferredSize(this.removeBtn.getPreferredSize());
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.setActionCommand(CANCEL_CMD);
        this.cancelBtn.addActionListener(this);
        this.cancelBtn.setPreferredSize(this.removeBtn.getPreferredSize());
        JPanel downBtnPanel = new JPanel(new FlowLayout(1, 50, 0));
        downBtnPanel.add(this.okBtn);
        downBtnPanel.add(this.cancelBtn);
        Container pane = this.getContentPane();
        pane.setLayout(new GridBagLayout());
        pane.add((Component)scroll, new GridBagConstraints(0, 0, 1, 3, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        pane.add((Component)this.addBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        pane.add((Component)this.removeBtn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        pane.add((Component)downBtnPanel, new GridBagConstraints(0, 3, 2, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void initColumn(TableColumn column, TableCellEditor editor, String name, int width, boolean resizable) {
        column.setCellEditor(editor);
        column.setHeaderValue(name);
        column.setPreferredWidth(width);
        column.setResizable(resizable);
    }

    public void show(LogConfiguration config, String name, Object[] initialValues) {
        if (initialValues != null) {
            this.model.setLogConfiguration(config, name);
            this.model.setAllData(initialValues);
        } else {
            this.model.clear();
            this.model.setLogConfiguration(config, name);
            LogControllerDescriptor lcd = config.getLogController(name);
            String[] names = lcd.getRelativeControllersNames();
            int i = 0;
            while (i < names.length) {
                this.model.addElement(new Object[]{names[i], Severity.toString((int)lcd.getMinRelativeSeverity(names[i])), Severity.toString((int)lcd.getMaxRelativeSeverity(names[i])), null});
                ++i;
            }
        }
        this.config = config;
        this.controllerName = name;
        this.modalResult = false;
        ((Component)this).setVisible(true);
    }

    public boolean getModalResult() {
        return this.modalResult;
    }

    public Object[] getResult() {
        return this.model.getAllData();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(OK_CMD)) {
            this.modalResult = true;
            ((Component)this).setVisible(false);
        } else if (e.getActionCommand().equals(CANCEL_CMD)) {
            ((Component)this).setVisible(false);
        } else if (e.getActionCommand().equals(ADD_CMD)) {
            String name;
            LogControllerDescriptor[] lcds = this.config.getLogControllers();
            JComboBox<String> controllers = new JComboBox<String>();
            boolean isCategory = this.controllerName.startsWith("/");
            int i = 0;
            while (i < lcds.length) {
                if (lcds[i].getName().startsWith("/") != isCategory) {
                    controllers.addItem(lcds[i].getName());
                }
                ++i;
            }
            controllers.setEditable(true);
            controllers.setSelectedItem("");
            if (JOptionPane.showConfirmDialog(this, controllers, "Relative controller name", 2, 3) == 0 && (name = (String)controllers.getSelectedItem()) != null && !name.trim().equals("")) {
                Object[] relation = new Object[4];
                relation[0] = name;
                relation[1] = "Debug";
                relation[2] = "None";
                int position = this.model.addElement(relation);
                this.table.getSelectionModel().setSelectionInterval(position, position);
            }
        } else if (e.getActionCommand().equals(REMOVE_CMD)) {
            if (this.table.getEditingColumn() != -1) {
                this.table.setEditingColumn(-1);
            }
            if (this.table.getSelectedRow() != -1) {
                this.model.removeElementAt(this.table.getSelectedRow());
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        this.removeBtn.setEnabled(this.table.getSelectedRow() != -1);
    }
}

