/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.gui;

import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogControllerDescriptor;
import com.sap.engine.lib.logging.descriptors.LogDestinationDescriptor;
import com.sap.engine.services.log_configurator.admin.LogConfiguratorManagementInterface;
import com.sap.engine.services.log_configurator.admin.gui.GeneralLogControllerPanel;
import com.sap.engine.services.log_configurator.admin.gui.LogControllerPanel;
import com.sap.engine.services.log_configurator.admin.gui.LogControllersTreeModel;
import com.sap.engine.services.log_configurator.admin.gui.LogControllersTreeRenderer;
import com.sap.engine.services.log_configurator.admin.gui.RelativeControllersDialog;
import com.sap.tc.logging.Severity;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class LogControllerPanelLogical
extends JPanel
implements TreeSelectionListener,
ActionListener,
DocumentListener {
    protected LogControllerPanel logController = null;
    private static final String NEW_CMD = "NEW_CMD";
    private static final String RESET_TO_DEFAULT_CMD = "RESET_TO_DEFAULT_CMD";
    private static final String RESET_TO_DEFAULT_CURRENT_CONTROLLER_CMD = "RESET_TO_DEFAULT_CURRENT_CONTROLLER_CMD";
    private static final String RESET_TO_DEFAULT_SUBTREE_CMD = "RESET_TO_DEFAULT_SUBTREE_CMD";
    private static final String REMOVE_CMD = "REMOVE_CMD";
    private JButton newButton;
    private JButton removeButton;
    private JButton resetToDefaultButton;
    protected JTree logTree;
    protected LogControllersTreeModel logModel;
    protected LogControllersTreeRenderer logRenderer;
    private JPopupMenu resetToDefaultPopupMenu;
    private JMenuItem resetToDefaultCurrentControllerMenuItem;
    private JMenuItem resetToDefaultSubtreeMenuItem;
    protected LogConfiguration logConfig = null;
    protected LogConfiguration addEditElements = null;
    protected LogConfiguration removedElements = null;
    private TreePath lastSelectedPath = null;
    private boolean inChangeSelection = false;
    private LogConfiguratorManagementInterface managementInterface;
    private JScrollPane logControllerScrollPane;

    public LogControllerPanelLogical(Frame frame, boolean hasIcons, GeneralLogControllerPanel mainPanel) {
        this.logController = new LogControllerPanel(frame, hasIcons, mainPanel);
    }

    public void init(boolean hasIcons) {
        this.logController.minSeverityComboBox.setActionCommand("MIN_SEVERITY_CMD");
        this.logController.minSeverityComboBox.addActionListener(this);
        this.logController.maxSeverityComboBox.setActionCommand("MAX_SEVERITY_CMD");
        this.logController.maxSeverityComboBox.addActionListener(this);
        this.logController.effectiveSeverityComboBox.setActionCommand("EFF_SEVERITY_CMD");
        this.logController.effectiveSeverityComboBox.addActionListener(this);
        this.logController.relativeSeveritiesButton.setActionCommand("RELATIVES_CMD");
        this.logController.relativeSeveritiesButton.addActionListener(this);
        this.logController.copyToSubtreeButton.setActionCommand("COPY_TO_SUBTREE_CMD");
        this.logController.copyToSubtreeButton.addActionListener(this);
        this.resetToDefaultButton = new JButton("Reset to default");
        this.resetToDefaultButton.setMnemonic('d');
        this.resetToDefaultButton.setActionCommand(RESET_TO_DEFAULT_CMD);
        this.resetToDefaultButton.addActionListener(this);
        this.newButton = new JButton("New");
        this.newButton.setMnemonic('n');
        this.newButton.setActionCommand(NEW_CMD);
        this.newButton.addActionListener(this);
        this.newButton.setPreferredSize(this.resetToDefaultButton.getPreferredSize());
        this.removeButton = new JButton("Remove");
        this.removeButton.setMnemonic('r');
        this.removeButton.setActionCommand(REMOVE_CMD);
        this.removeButton.addActionListener(this);
        this.removeButton.setPreferredSize(this.resetToDefaultButton.getPreferredSize());
        this.logController.buttonsPanel.add(this.newButton);
        this.logController.buttonsPanel.add(this.resetToDefaultButton);
        this.logController.buttonsPanel.add(this.removeButton);
        this.resetToDefaultPopupMenu = new JPopupMenu();
        this.resetToDefaultCurrentControllerMenuItem = new JMenuItem("Selected controller");
        this.resetToDefaultCurrentControllerMenuItem.setActionCommand(RESET_TO_DEFAULT_CURRENT_CONTROLLER_CMD);
        this.resetToDefaultCurrentControllerMenuItem.addActionListener(this);
        this.resetToDefaultPopupMenu.add(this.resetToDefaultCurrentControllerMenuItem);
        this.resetToDefaultSubtreeMenuItem = new JMenuItem("Subtree");
        this.resetToDefaultSubtreeMenuItem.setActionCommand(RESET_TO_DEFAULT_SUBTREE_CMD);
        this.resetToDefaultSubtreeMenuItem.addActionListener(this);
        this.resetToDefaultPopupMenu.add(this.resetToDefaultSubtreeMenuItem);
        JPanel logPanel = new JPanel(new BorderLayout());
        logPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Log Controllers"));
        this.logRenderer = new LogControllersTreeRenderer(this.logModel);
        this.logTree = new JTree(this.logModel);
        this.logTree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                Object lastPathComponent = path.getLastPathComponent();
                TreeModel model = LogControllerPanelLogical.this.logTree.getModel();
                int c = model.getChildCount(lastPathComponent);
                if (c == 1) {
                    LogControllerPanelLogical.this.logTree.expandPath(path.pathByAddingChild(model.getChild(lastPathComponent, 0)));
                }
            }
        });
        this.logTree.setCellRenderer(this.logRenderer);
        this.logTree.getSelectionModel().setSelectionMode(1);
        this.logTree.setShowsRootHandles(true);
        this.logTree.addTreeSelectionListener(this);
        logPanel.add((Component)new JScrollPane(this.logTree), "Center");
        JSplitPane splitter = new JSplitPane();
        splitter.setLeftComponent(logPanel);
        this.logControllerScrollPane = new JScrollPane(this.logController);
        splitter.setRightComponent(this.logControllerScrollPane);
        splitter.setDividerLocation(300);
        this.setLayout(new BorderLayout());
        this.add((Component)splitter, "Center");
        this.removeButton.setEnabled(false);
        this.resetToDefaultButton.setEnabled(false);
        this.checkEnable();
    }

    private void checkEnable() {
        String name;
        boolean isExisting = false;
        TreePath selectionPath = this.logTree.getSelectionPath();
        if (selectionPath != null && (name = this.logModel.pathToName(selectionPath.getPath())) != null && this.logConfig.getLogController(name) != null) {
            isExisting = true;
        }
        this.logController.bundleTextField.setEnabled(isExisting);
        this.logController.minSeverityComboBox.setEnabled(isExisting);
        this.logController.maxSeverityComboBox.setEnabled(isExisting);
        this.logController.effectiveSeverityComboBox.setEnabled(selectionPath != null);
        this.logController.relativeSeveritiesButton.setEnabled(isExisting);
        this.logController.filterPanel.setEnabled(isExisting);
        this.logController.destinationPanel.setEnabled(isExisting);
        this.logController.dbCheckBox.setEnabled(isExisting);
        this.removeButton.setEnabled(isExisting);
        this.resetToDefaultButton.setEnabled(selectionPath != null);
        this.logController.copyToSubtreeButton.setEnabled(selectionPath != null && ((TreeNode)selectionPath.getLastPathComponent()).getChildCount() > 0 && (isExisting || this.logController.effectiveSeverityComboBox.getSelectedIndex() != -1));
    }

    public abstract void setDescriptor(LogConfiguration var1, LogConfiguration var2, LogConfiguration var3);

    public void clear() {
        this.logController.clear();
        this.logTree.clearSelection();
        this.removeButton.setEnabled(false);
        this.resetToDefaultButton.setEnabled(false);
        this.checkEnable();
    }

    private void updateTreePath(TreePath path) {
        Object lastPathComponent;
        if (path != null && (lastPathComponent = path.getLastPathComponent()) instanceof TreeNode) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LogControllerPanelLogical.this.logModel.nodeChanged((TreeNode)lastPathComponent);
                }
            });
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (e != null) {
            this.updateTreePath(e.getOldLeadSelectionPath());
        }
        this.inChangeSelection = true;
        this.applyChangesToLastSelectionPath();
        this.lastSelectedPath = this.logTree.getSelectionPath();
        if (!this.logTree.isSelectionEmpty()) {
            String name = this.logModel.pathToName(this.lastSelectedPath.getPath());
            if (name != null) {
                this.logController.setDescriptor(this.logConfig.getLogController(name));
            }
        } else {
            this.clear();
        }
        this.checkEnable();
        this.inChangeSelection = false;
    }

    private void applyChangesToLastSelectionPath() {
        String name;
        LogControllerDescriptor oldLogController = null;
        if (this.lastSelectedPath != null && this.logTree.getSelectionPath() != null && (name = this.logModel.pathToName(this.lastSelectedPath.getPath())) != null) {
            oldLogController = this.logConfig.getLogController(name);
        }
        LogControllerDescriptor newLogController = this.logController.getDescriptor(oldLogController);
        if (oldLogController != null && newLogController != null && newLogController.getName() != null && !oldLogController.equals((Object)newLogController)) {
            newLogController.setStateOwner(oldLogController.getStateOwner());
            newLogController.setState(oldLogController.getState());
            this.addToRemoved(oldLogController, newLogController);
            this.logConfig.removeLogController(newLogController.getName());
            this.logConfig.addLogController(newLogController);
            this.addEditElements.removeLogController(newLogController.getName());
            this.addEditElements.addLogController(newLogController);
        }
        if (this.lastSelectedPath != null) {
            this.logModel.nodeChanged((TreeNode)this.lastSelectedPath.getLastPathComponent());
        }
    }

    private void addToRemoved(LogControllerDescriptor oldLCD, LogControllerDescriptor newLCD) {
        if (!this.removedElements.containsLogController(newLCD.getName())) {
            Object[] destinations = oldLCD.getAssociatedDestinations().getAllKeys();
            int i = 0;
            while (i < destinations.length) {
                if (!newLCD.containsDestination((LogDestinationDescriptor)destinations[i])) {
                    this.removedElements.addLogController(newLCD);
                    return;
                }
                ++i;
            }
            String[] relations = oldLCD.getRelativeControllersNames();
            int i2 = 0;
            while (i2 < relations.length) {
                if (!newLCD.getMaxRelativeSeverities().containsKey((Object)relations[i2])) {
                    this.removedElements.addLogController(newLCD);
                    return;
                }
                ++i2;
            }
            String[] filters = oldLCD.getFilters();
            int i3 = 0;
            while (i3 < filters.length) {
                if (!newLCD.containsFilter(filters[i3])) {
                    this.removedElements.addLogController(newLCD);
                    return;
                }
                ++i3;
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals(NEW_CMD)) {
            this.addAction();
        } else if (actionCommand.equals(REMOVE_CMD)) {
            this.removeAction();
            this.clear();
        } else if (actionCommand.equals(RESET_TO_DEFAULT_CMD)) {
            this.resetToDefaultAction();
        } else if (actionCommand.equals(RESET_TO_DEFAULT_CURRENT_CONTROLLER_CMD)) {
            this.resetToDefaultCurrentControllerAction();
        } else if (actionCommand.equals(RESET_TO_DEFAULT_SUBTREE_CMD)) {
            this.resetToDefaultSubtreeAction();
        } else if (actionCommand.equals("MIN_SEVERITY_CMD") && !this.inChangeSelection) {
            this.inChangeSelection = true;
            int position = this.logController.minSeverityComboBox.getSelectedIndex();
            if (this.logController.maxSeverityComboBox.getSelectedIndex() < position) {
                this.logController.maxSeverityComboBox.setSelectedIndex(position);
            }
            this.calcCurrentEffectiveSeverity();
            this.inChangeSelection = false;
        } else if (actionCommand.equals("MAX_SEVERITY_CMD") && !this.inChangeSelection) {
            this.inChangeSelection = true;
            int position = this.logController.maxSeverityComboBox.getSelectedIndex();
            if (this.logController.minSeverityComboBox.getSelectedIndex() > position) {
                this.logController.minSeverityComboBox.setSelectedIndex(position);
            }
            this.calcCurrentEffectiveSeverity();
            this.inChangeSelection = false;
        } else if (actionCommand.equals("EFF_SEVERITY_CMD") && !this.inChangeSelection) {
            this.inChangeSelection = true;
            int position = this.logController.effectiveSeverityComboBox.getSelectedIndex();
            if (position == -1) {
                position = 0;
            }
            this.logController.minSeverityComboBox.setSelectedIndex(position);
            this.logController.maxSeverityComboBox.setSelectedIndex(position);
            this.checkEnable();
            this.inChangeSelection = false;
        } else if (actionCommand.equals("RELATIVES_CMD")) {
            RelativeControllersDialog dlg = new RelativeControllersDialog(this.logController.mainFrame);
            dlg.show(this.logConfig, this.logController.nameTextField.getText(), this.logController.relationsData);
            if (dlg.getModalResult()) {
                this.logController.relationsData = dlg.getResult();
            }
        } else if (actionCommand.equals("COPY_TO_SUBTREE_CMD")) {
            TreePath path = this.logTree.getSelectionPath();
            String severity = (String)this.logController.effectiveSeverityComboBox.getSelectedItem();
            int x = JOptionPane.showConfirmDialog(this, "Are you sure you want to set severity \"" + severity + "\"\n to all controllers under \"" + this.logModel.pathToName(path.getPath()) + "\"?", "Copy severity to subtree", 0, 3);
            if (x == 0) {
                ArrayList listOfDescriptors = new ArrayList();
                ArrayList listOfNodes = new ArrayList();
                this.traverseSubtree(path, listOfDescriptors, listOfNodes, null);
                LogControllerDescriptor[] descriptors = listOfDescriptors.toArray(new LogControllerDescriptor[listOfDescriptors.size()]);
                TreeNode[] nodes = listOfNodes.toArray(new TreeNode[listOfNodes.size()]);
                this.addEditElements.addLogControllers(descriptors);
                int i = 0;
                while (i < descriptors.length) {
                    descriptors[i].setMinSeverity(severity);
                    descriptors[i].setMaxSeverity(severity);
                    descriptors[i].setEffectiveSeverity(severity);
                    this.logModel.nodeChanged(nodes[i]);
                    ++i;
                }
            }
        }
    }

    private void traverseSubtree(TreePath path, ArrayList listOfDescriptors, ArrayList listOfNodes, ArrayList listOfPaths) {
        LogControllerDescriptor descriptor;
        TreeNode node = (TreeNode)path.getLastPathComponent();
        String name = this.logModel.pathToName(path.getPath());
        if (name != null && (descriptor = this.logConfig.getLogController(name)) != null) {
            if (listOfDescriptors != null) {
                listOfDescriptors.add(descriptor);
            }
            if (listOfNodes != null) {
                listOfNodes.add(node);
            }
            if (listOfPaths != null) {
                listOfPaths.add(path);
            }
        }
        int nChildren = node.getChildCount();
        int i = 0;
        while (i < nChildren) {
            TreePath child = path.pathByAddingChild(node.getChildAt(i));
            this.traverseSubtree(child, listOfDescriptors, listOfNodes, listOfPaths);
            ++i;
        }
    }

    private void calcCurrentEffectiveSeverity() {
        LogControllerDescriptor lcd = this.logConfig.getLogController(this.logController.nameTextField.getText());
        if (lcd == null) {
            this.logController.effectiveSeverityComboBox.setSelectedIndex(7);
            return;
        }
        int parentSeverity = this.logConfig.calculateEffectiveSeverity(LogControllerDescriptor.getParentName((String)lcd.getName()));
        if (parentSeverity < Severity.parse((String)((String)this.logController.minSeverityComboBox.getSelectedItem()))) {
            this.logController.effectiveSeverityComboBox.setSelectedItem(this.logController.minSeverityComboBox.getSelectedItem());
        } else if (parentSeverity < Severity.parse((String)((String)this.logController.maxSeverityComboBox.getSelectedItem()))) {
            this.logController.effectiveSeverityComboBox.setSelectedItem(Severity.toString((int)parentSeverity));
        } else {
            this.logController.effectiveSeverityComboBox.setSelectedItem(this.logController.maxSeverityComboBox.getSelectedItem());
        }
    }

    protected abstract String checkName(String var1);

    private void addAction() {
        String selectedName = null;
        if (this.logTree.getSelectionPath() != null) {
            selectedName = this.logModel.pathToName(this.logTree.getSelectionPath().getPath());
        }
        this.logTree.clearSelection();
        String newName = (String)JOptionPane.showInputDialog(this.logController, "New controller name:", "New controller", 3, null, null, selectedName);
        if (newName != null && (newName = this.checkName(newName)) != null) {
            if (this.logConfig.containsLogController(newName)) {
                JOptionPane.showMessageDialog(this.logController, "Log controller '" + newName + "' already exists!", "Error", 0);
                return;
            }
            this.logController.nameTextField.setText(newName);
            LogControllerDescriptor controller = this.logController.getDescriptor(null);
            this.addEditElements.addLogController(controller);
            this.logConfig.addLogController(controller);
            this.logModel.add(controller.getName());
            this.logTree.repaint();
            TreePath path = new TreePath(this.logModel.nameToPath(newName));
            this.logTree.setSelectionPath(path);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            LogControllerDescriptor firstConfiguredParent = null;
            while (firstConfiguredParent == null) {
                if ((node = (DefaultMutableTreeNode)node.getParent()) == null) {
                    return;
                }
                firstConfiguredParent = this.logConfig.getLogController(this.logModel.pathToName(node.getPath()));
            }
            if (firstConfiguredParent != null) {
                controller.setState(firstConfiguredParent.getState());
                controller.setStateOwner(firstConfiguredParent.getStateOwner());
            }
        }
    }

    private void removeAction() {
        int x = JOptionPane.showConfirmDialog(this, "Are you sure you want to remove the selected controller?", "Remove", 0);
        if (x != 0) {
            return;
        }
        if (!this.logTree.isSelectionEmpty()) {
            Object[] selectedPath = this.logTree.getSelectionPath().getPath();
            LogControllerDescriptor removedController = this.logConfig.getLogController(this.logModel.pathToName(selectedPath));
            if (removedController == null) {
                return;
            }
            this.addEditElements.removeLogController(removedController.getName());
            this.logConfig.removeLogController(removedController.getName());
            this.removedElements.addLogController(removedController);
            this.lastSelectedPath = null;
            this.logModel.remove(this.logConfig, (DefaultMutableTreeNode)selectedPath[selectedPath.length - 1]);
        }
    }

    private void resetToDefaultAction() {
        this.resetToDefaultPopupMenu.show(this.resetToDefaultButton, 0, this.resetToDefaultButton.getHeight());
    }

    private void resetToDefaultCurrentControllerAction() {
        TreePath path = this.logTree.getSelectionPath();
        this.logTree.setSelectionPath(null);
        this.resetToDefalt(path);
        this.checkDisabled();
        this.logTree.setSelectionPath(path);
    }

    private void resetToDefalt(TreePath path) {
        if (path == null) {
            return;
        }
        Object[] selectedPath = path.getPath();
        String name = this.logModel.pathToName(selectedPath);
        LogControllerDescriptor currentLCD = this.logConfig.getLogController(name);
        LogControllerDescriptor defaultLCD = this.managementInterface.getDefaultConfigurationPerController(name);
        if (defaultLCD == null) {
            if (currentLCD == null) {
                return;
            }
            defaultLCD = currentLCD;
            defaultLCD.setEffectiveSeverity(name.startsWith("/") ? 300 : 500);
        }
        this.logConfig.addLogController(defaultLCD);
        this.removedElements.addLogController(currentLCD);
        this.addEditElements.addLogController(defaultLCD);
        this.logModel.nodeChanged((TreeNode)path.getLastPathComponent());
    }

    private void resetToDefaultSubtreeAction() {
        TreePath path = this.logTree.getSelectionPath();
        this.logTree.setSelectionPath(null);
        if (path == null) {
            return;
        }
        String controllerName = this.logModel.pathToName(path.getPath());
        if (controllerName == null) {
            return;
        }
        int x = JOptionPane.showConfirmDialog(this, "Are you sure you want to reset to default\nall controllers under \"" + controllerName + "\"?", "Reset subtree to default", 0);
        if (x != 0) {
            return;
        }
        ArrayList listOfPaths = new ArrayList();
        this.traverseSubtree(path, null, null, listOfPaths);
        TreePath[] paths = listOfPaths.toArray(new TreePath[listOfPaths.size()]);
        int i = 0;
        while (i < paths.length) {
            this.resetToDefalt(paths[i]);
            ++i;
        }
        this.logTree.setSelectionPath(path);
    }

    public void insertUpdate(DocumentEvent e) {
        if (!this.logController.setText) {
            this.checkDisabled();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.logController.setText) {
            this.checkDisabled();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        if (!this.logController.setText) {
            this.checkDisabled();
        }
    }

    private void checkDisabled() {
        String entryName = this.logController.nameTextField.getText();
        this.checkEnable();
        this.logController.selectWithMouse = false;
        this.lastSelectedPath = null;
        this.logTree.clearSelection();
        this.logTree.setSelectionPath(new TreePath(this.logModel.nameToPath(entryName)));
        if (!entryName.trim().equals("")) {
            this.logController.initAdvancePanel();
            this.removeButton.setEnabled(true);
            this.resetToDefaultButton.setEnabled(true);
        } else {
            this.logController.destinationPanel.initList(new Object[0]);
            this.removeButton.setEnabled(false);
            this.resetToDefaultButton.setEnabled(false);
        }
        this.logController.selectWithMouse = true;
    }

    public void setFrame(Frame frame) {
        this.logController.setFrame(frame);
    }

    public void setManagementInterface(LogConfiguratorManagementInterface managementInterface) {
        this.managementInterface = managementInterface;
    }

    public void setChangeStatePossible(boolean csp) {
    }

    public void setResetToDefaultVisible(boolean visible) {
        this.resetToDefaultButton.setVisible(visible);
    }

    public void commitChange() {
        this.updateTreePath(this.logTree.getSelectionPath());
        this.valueChanged(null);
    }

    public void setAdvancedMode(boolean mode) {
        this.logController.bundleNameLabel.setVisible(mode);
        this.logController.bundleTextField.setVisible(mode);
        this.logController.minLabel.setVisible(mode);
        this.logController.minSeverityComboBox.setVisible(mode);
        this.logController.maxLabel.setVisible(mode);
        this.logController.maxSeverityComboBox.setVisible(mode);
        this.logController.relativeSeveritiesButton.setVisible(mode);
        this.logController.dbCheckBox.setVisible(mode);
        ((JComponent)((Object)this.logController.destinationPanel)).setVisible(mode);
        this.logController.associationLabel.setVisible(mode);
        this.logController.associationComboBox.setVisible(mode);
        this.newButton.setVisible(mode);
        this.removeButton.setVisible(mode);
        this.logController.destinationPanel.setAdvancetMode(mode);
        this.logController.editorPane.getParent().getParent().setVisible(!mode);
    }
}

