/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin.gui;

import com.sap.engine.gui.SimpleListPanel;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.logging.descriptors.LogControllerDescriptor;
import com.sap.engine.lib.util.HashMapObjectByte;
import com.sap.engine.services.log_configurator.admin.gui.AdvanceListPanel;
import com.sap.engine.services.log_configurator.admin.gui.GeneralLogControllerPanel;
import com.sap.tc.logging.Severity;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class LogControllerPanel
extends JPanel {
    protected Frame mainFrame = null;
    protected GeneralLogControllerPanel mainPanel;
    protected final String[] type = new String[]{"Location", "Category"};
    public static final String MIN_SEVERITY_CMD = "MIN_SEVERITY_CMD";
    public static final String MAX_SEVERITY_CMD = "MAX_SEVERITY_CMD";
    public static final String EFF_SEVERITY_CMD = "EFF_SEVERITY_CMD";
    public static final String RELATIVES_CMD = "RELATIVES_CMD";
    public static final String DBLOG_CMD = "DBLOG_CMD";
    public static final String COPY_TO_SUBTREE_CMD = "COPY_TO_SUBTREE_CMD";
    public JPanel buttonsPanel = new JPanel();
    public JLabel nameLabel = new JLabel("Name:");
    public JTextField nameTextField = new JTextField();
    public JTextField bundleTextField = new JTextField();
    public JLabel bundleNameLabel = new JLabel("Bundle:");
    public static final String[] severityArr = new String[]{"All", "Debug", "Path", "Info", "Warning", "Error", "Fatal", "None"};
    public JComboBox minSeverityComboBox = new JComboBox<String>(severityArr);
    public JComboBox maxSeverityComboBox = new JComboBox<String>(severityArr);
    public JComboBox effectiveSeverityComboBox = new JComboBox<String>(severityArr);
    public JButton relativeSeveritiesButton = new JButton("Relative controllers");
    public SimpleListPanel filterPanel;
    public AdvanceListPanel destinationPanel;
    public Object[] relationsData;
    public JCheckBox dbCheckBox = new JCheckBox("Write to database");
    public JLabel minLabel = new JLabel("Min:");
    public JLabel maxLabel = new JLabel("Max:");
    public JButton copyToSubtreeButton;
    public JEditorPane editorPane;
    static final String[] ASSOCIATION_VALUES = new String[]{"PUBLIC", "PRIVATE", "LOCAL"};
    protected JComboBox associationComboBox = new JComboBox<String>(ASSOCIATION_VALUES);
    protected JLabel associationLabel = new JLabel("Association");
    private LogConfiguration logConfig = null;
    public boolean selectWithMouse = true;
    public boolean setText = false;
    static /* synthetic */ Class class$com$sap$engine$services$log_configurator$admin$gui$LogControllerPanel;

    public LogControllerPanel(Frame frame, boolean hasIcons, GeneralLogControllerPanel mainPanel) {
        this.mainFrame = frame;
        this.mainPanel = mainPanel;
        try {
            this.initPanel(hasIcons);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void initPanel(boolean hasIcons) throws Exception {
        this.setLayout(new GridBagLayout());
        this.buttonsPanel.setLayout(new FlowLayout());
        this.filterPanel = new SimpleListPanel("Filters");
        this.filterPanel.setParentComponent((Component)this.mainFrame);
        this.filterPanel.setPreferredSize(new Dimension(200, 115));
        this.destinationPanel = new AdvanceListPanel("Destinations", this.mainFrame, 0, hasIcons, this.mainPanel);
        ((JComponent)((Object)this.destinationPanel)).setPreferredSize(new Dimension(200, 150));
        this.destinationPanel.setComboBox(this.associationComboBox);
        Dimension comboBoxSize = this.relativeSeveritiesButton.getPreferredSize();
        this.minSeverityComboBox.setPreferredSize(comboBoxSize);
        this.maxSeverityComboBox.setPreferredSize(comboBoxSize);
        this.effectiveSeverityComboBox.setPreferredSize(comboBoxSize);
        this.associationComboBox.setEnabled(false);
        this.associationComboBox.setSelectedIndex(-1);
        this.nameTextField.setEditable(false);
        JLabel severityLabel = new JLabel("Severity:");
        severityLabel.setDisplayedMnemonic('s');
        severityLabel.setLabelFor(this.effectiveSeverityComboBox);
        this.nameLabel.setDisplayedMnemonic('m');
        this.nameLabel.setLabelFor(this.nameTextField);
        this.bundleNameLabel.setDisplayedMnemonic('b');
        this.bundleNameLabel.setLabelFor(this.bundleTextField);
        this.minLabel.setDisplayedMnemonic('i');
        this.minLabel.setLabelFor(this.minSeverityComboBox);
        this.maxLabel.setDisplayedMnemonic('x');
        this.maxLabel.setLabelFor(this.maxSeverityComboBox);
        this.copyToSubtreeButton = new JButton("Copy severity to subtree");
        this.copyToSubtreeButton.setMnemonic('u');
        this.associationLabel.setDisplayedMnemonic('a');
        this.associationLabel.setLabelFor(this.associationComboBox);
        this.dbCheckBox.setMnemonic('w');
        this.editorPane = new JEditorPane((class$com$sap$engine$services$log_configurator$admin$gui$LogControllerPanel == null ? (class$com$sap$engine$services$log_configurator$admin$gui$LogControllerPanel = LogControllerPanel.class$("com.sap.engine.services.log_configurator.admin.gui.LogControllerPanel")) : class$com$sap$engine$services$log_configurator$admin$gui$LogControllerPanel).getResource("help/index.html"));
        this.editorPane.setEditable(false);
        JScrollPane editorPaneScrollPane = new JScrollPane(this.editorPane);
        editorPaneScrollPane.setPreferredSize(new Dimension(1, 1));
        int i = 0;
        int inset = 3;
        Insets insets = new Insets(inset, inset, inset, inset);
        this.add((Component)this.nameLabel, new GridBagConstraints(0, i, 1, 1, 0.0, 0.03, 14, 0, new Insets(0, inset, inset, inset), 0, 0));
        this.add((Component)this.nameTextField, new GridBagConstraints(1, i, 3, 1, 0.1, 0.0, 15, 2, insets, 0, 0));
        this.add((Component)this.bundleNameLabel, new GridBagConstraints(0, ++i, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add((Component)this.bundleTextField, new GridBagConstraints(1, i, 3, 1, 0.1, 0.0, 10, 2, insets, 0, 0));
        this.add((Component)this.minLabel, new GridBagConstraints(0, ++i, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add((Component)this.minSeverityComboBox, new GridBagConstraints(1, i, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        this.add((Component)this.maxLabel, new GridBagConstraints(2, i, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add((Component)this.maxSeverityComboBox, new GridBagConstraints(3, i, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        this.add((Component)severityLabel, new GridBagConstraints(0, ++i, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add((Component)this.effectiveSeverityComboBox, new GridBagConstraints(1, i, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        this.add((Component)this.copyToSubtreeButton, new GridBagConstraints(3, i, 1, 1, 0.1, 0.0, 10, 2, insets, 0, 0));
        this.add((Component)this.relativeSeveritiesButton, new GridBagConstraints(1, ++i, 0, 1, 0.1, 0.0, 10, 2, insets, 0, 0));
        this.add((Component)((Object)this.destinationPanel), new GridBagConstraints(0, ++i, 4, 1, 0.1, 1.0, 10, 1, new Insets(inset, inset, inset, 0), 0, 0));
        this.add((Component)this.associationLabel, new GridBagConstraints(0, ++i, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add((Component)this.associationComboBox, new GridBagConstraints(1, i, 1, 1, 0.1, 0.0, 10, 2, insets, 0, 0));
        this.add((Component)this.dbCheckBox, new GridBagConstraints(3, i, 3, 1, 0.1, 0.0, 10, 2, insets, 0, 0));
        this.add((Component)this.buttonsPanel, new GridBagConstraints(0, ++i, 4, 1, 0.0, 0.03, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)editorPaneScrollPane, new GridBagConstraints(0, ++i, 0, 1, 1.0, 0.1, 15, 1, insets, 0, 0));
        this.setDescriptor(new LogControllerDescriptor());
    }

    public void clear() {
        this.setDescriptor((LogControllerDescriptor)null);
    }

    public void setDescriptor(LogControllerDescriptor descriptor0) {
        LogControllerDescriptor descriptor = descriptor0;
        if (descriptor == null) {
            descriptor = new LogControllerDescriptor();
        }
        if (this.selectWithMouse) {
            this.setText = true;
            this.nameTextField.setText(descriptor.getName());
            this.setText = false;
        }
        this.bundleTextField.setText(descriptor.getBundleName());
        this.maxSeverityComboBox.setSelectedItem(descriptor.getMaxSeverity());
        this.minSeverityComboBox.setSelectedItem(descriptor.getMinSeverity());
        if (descriptor0 == null) {
            this.effectiveSeverityComboBox.setSelectedIndex(-1);
        } else {
            this.effectiveSeverityComboBox.setSelectedItem(Severity.toString((int)this.logConfig.calculateEffectiveSeverity(descriptor.getName())));
        }
        this.filterPanel.initList(descriptor.getFilters());
        this.destinationPanel.initList(descriptor.getAssociatedDestinations());
        this.dbCheckBox.setSelected(descriptor.hasDBLog());
        this.relationsData = null;
        this.initAdvancePanel();
    }

    public void initAdvancePanel() {
        this.destinationPanel.setDescriptor(this.logConfig);
    }

    public LogControllerDescriptor getDescriptor(LogControllerDescriptor oldDescriptor) {
        LogControllerDescriptor descr = new LogControllerDescriptor();
        if (oldDescriptor != null) {
            descr.setPersistenceAdapter(oldDescriptor.getPersistenceAdapter());
        }
        descr.setName(this.nameTextField.getText().trim());
        descr.setBundleName(this.bundleTextField.getText().trim().equals("") ? null : this.bundleTextField.getText().trim());
        descr.setMinSeverity((String)this.minSeverityComboBox.getSelectedItem());
        descr.setMaxSeverity((String)this.maxSeverityComboBox.getSelectedItem());
        descr.setFilters(this.filterPanel.getListDataArray());
        descr.setAssociatedDestinations((HashMapObjectByte)this.destinationPanel.getDescriptor());
        descr.setDBLog(this.dbCheckBox.isSelected());
        if (this.relationsData != null) {
            int i = 0;
            while (i < this.relationsData.length) {
                Object[] relation = (Object[])this.relationsData[i];
                String relativeControllerName = (String)relation[0];
                descr.setMinRelativeSeverity(relativeControllerName, (String)relation[1]);
                descr.setMaxRelativeSeverity(relativeControllerName, (String)relation[2]);
                ++i;
            }
        } else {
            LogControllerDescriptor oldLCD = this.logConfig.getLogController(descr.getName());
            if (oldLCD != null) {
                descr.setMinRelativeSeverities(oldLCD.getMinRelativeSeverities());
                descr.setMaxRelativeSeverities(oldLCD.getMaxRelativeSeverities());
            }
        }
        return descr;
    }

    public void setFrame(Frame frame) {
        this.mainFrame = frame;
        this.filterPanel.setParentComponent((Component)frame);
        this.destinationPanel.setParentComponent(frame);
    }

    public void setDescriptor(LogConfiguration descr) {
        this.logConfig = descr;
        if (this.destinationPanel != null) {
            this.destinationPanel.setDescriptor(this.logConfig);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

