/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator.admin;

import com.sap.engine.lib.logging.descriptors.LogDestinationDescriptor;
import com.sap.engine.services.log_configurator.admin.LogConfigurator;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Archivator {
    private static final Location TRACER = Location.getLocation((Class)(class$com$sap$engine$services$log_configurator$admin$Archivator == null ? (class$com$sap$engine$services$log_configurator$admin$Archivator = Archivator.class$("com.sap.engine.services.log_configurator.admin.Archivator")) : class$com$sap$engine$services$log_configurator$admin$Archivator));
    public static final String DEFAULT_ARCHIVE_DIR = "./log/archive/";
    private boolean dumps;
    private PrintStream out;
    private PrintStream err;
    private StringBuffer output;
    private LogConfigurator logConfigurator;
    static /* synthetic */ Class class$com$sap$engine$services$log_configurator$admin$Archivator;

    public Archivator(LogConfigurator logConfigurator) {
        this.logConfigurator = logConfigurator;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String archive(LogDestinationDescriptor[] logDestinationDescriptors, boolean defaultTracesSelected, String archiveDir, boolean dumps, PrintStream out, PrintStream err) {
        if (dumps && err != null && out != null) {
            this.dumps = true;
            this.err = err;
            this.out = out;
        } else {
            this.dumps = false;
        }
        this.output = new StringBuffer();
        archiveDir = archiveDir.replace('\\', '/');
        if (!archiveDir.endsWith("/")) {
            archiveDir = archiveDir + "/";
        }
        zout = null;
        dir = new File(archiveDir);
        if (!dir.exists() && !dir.mkdirs()) {
            this.printError("Can't create archive directory!");
            return this.output.toString();
        }
        name = archiveDir + "LogArchive_" + new Date(System.currentTimeMillis()).toString().replace(':', '.').replace(' ', '_') + ".zip";
        try {
            zout = new ZipOutputStream(new FileOutputStream(name));
        }
        catch (FileNotFoundException e) {
            this.printError("Can't create archive file!");
            return this.output.toString();
        }
        this.addMessage("Creating archive '" + name + "':\r\n");
        try {
            try {
                if (defaultTracesSelected) {
                    this.addMessage("Adding default traces\r\n");
                    defaultTraceFile = this.logConfigurator.getDefaultTraceFile();
                    if (defaultTraceFile != null) {
                        fileNames = defaultTraceFile.calculateFileNames();
                        i = fileNames.size();
                        while (--i >= 0) {
                            this.archive((String)fileNames.get(i), zout, true);
                        }
                    }
                }
                i = logDestinationDescriptors.length;
                block11: while (true) {
                    if (--i < 0) {
                        var11_14 = this.output.toString();
                        var15_19 = null;
                        break;
                    }
                    dst = logDestinationDescriptors[i] == null ? null : logDestinationDescriptors[i].getRealLog();
                    if (!(dst instanceof FileLog)) continue;
                    fileNames = ((FileLog)dst).calculateFileNames();
                    j = fileNames.size();
                    while (true) {
                        if (--j >= 0) ** break;
                        continue block11;
                        this.archive((String)fileNames.get(j), zout, true);
                    }
                    break;
                }
            }
            catch (IOException e) {
                this.printError("Can't write to zip file!");
                var11_15 = this.output.toString();
                var15_20 = null;
                try {
                    zout.close();
                    return var11_15;
                }
                catch (Exception e) {
                    Archivator.TRACER.traceThrowableT(500, "Failed to close archive file \"" + name + "\"!", (Throwable)e);
                }
                return var11_15;
            }
        }
        catch (Throwable var14_25) {
            var15_21 = null;
            try {}
            catch (Exception e) {
                Archivator.TRACER.traceThrowableT(500, "Failed to close archive file \"" + name + "\"!", (Throwable)e);
                throw var14_25;
            }
            zout.close();
            throw var14_25;
        }
        ** try [egrp 3[TRYBLOCK] [3 : 464->472)] { 
lbl75:
        // 1 sources

        zout.close();
        return var11_14;
lbl77:
        // 1 sources

        catch (Exception e) {
            Archivator.TRACER.traceThrowableT(500, "Failed to close archive file \"" + name + "\"!", (Throwable)e);
        }
        return var11_14;
    }

    private void archive(String fileName, ZipOutputStream zout, boolean dump) throws IOException {
        try {
            File f = new File(fileName);
            if (f.length() == 0L) {
                return;
            }
            FileInputStream in = new FileInputStream(f);
            if (dump) {
                this.addMessage("Adding \"" + fileName + "\"\r\n");
            }
            zout.putNextEntry(new ZipEntry(f.getPath()));
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = in.read(buffer)) != -1) {
                zout.write(buffer, 0, bytesRead);
            }
            in.close();
        }
        catch (Exception e) {
            TRACER.traceThrowableT(500, "Failed to archive \"" + fileName + "\" file!", (Throwable)e);
            this.printError("Failed to archive \"" + fileName + "\" file due to: " + e + "\n");
        }
    }

    public void addMessage(String message) {
        if (this.dumps) {
            this.out.print(message);
        } else {
            this.output.append(message);
        }
    }

    public void printError(String error) {
        if (this.dumps) {
            this.err.println("[Shell -> LOG_ARCHIVE] " + error);
        } else {
            this.output.append(error);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

