/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator;

import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.CommunicationServiceFrame;
import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.ServiceRuntimeException;
import com.sap.engine.frame.cluster.ClusterContext;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.frame.container.event.ContainerEventListenerAdapter;
import com.sap.engine.frame.container.monitor.DescriptorContainer;
import com.sap.engine.frame.container.monitor.InterfaceMonitor;
import com.sap.engine.frame.container.monitor.LibraryMonitor;
import com.sap.engine.frame.container.monitor.ServiceMonitor;
import com.sap.engine.frame.container.monitor.SystemMonitor;
import com.sap.engine.frame.container.registry.ObjectRegistry;
import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.frame.state.PersistentContainer;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.services.log_configurator.LogInterfaceImpl;
import com.sap.engine.services.log_configurator.admin.LogConfigurator;
import com.sap.engine.services.log_configurator.admin.LogXMLParser;
import com.sap.engine.services.log_configurator.admin.PersistenceAdapterExt;
import com.sap.engine.services.log_configurator.admin.shell.ArchiveCommand;
import com.sap.engine.services.log_configurator.admin.shell.LogCreateCommand;
import com.sap.engine.services.log_configurator.admin.shell.LogDumpsCommand;
import com.sap.engine.services.log_configurator.admin.shell.LogEditCommand;
import com.sap.engine.services.log_configurator.admin.shell.LogListCommand;
import com.sap.engine.services.log_configurator.admin.shell.LogRemoveCommand;
import com.sap.engine.services.log_configurator.archive.Archivator;
import com.sap.tc.logging.EventDispatcherFactory;
import com.sap.tc.logging.EventListener;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashSet;

public class LogConfiguratorServiceFrameImpl
extends ContainerEventListenerAdapter
implements CommunicationServiceFrame {
    protected final Location TRACER = Location.getLocation(((Object)((Object)this)).getClass());
    private LogInterfaceImpl logInterface = null;
    private ShellInterface shell = null;
    private int commandsId = -1;
    LogConfigurator logConfigurator = null;
    ServiceContext serviceContext = null;
    ClusterContext clusterContext = null;
    ObjectRegistry objectRegistry = null;
    SystemMonitor systemMonitor = null;
    Archivator archivator = null;

    public void start(CommunicationServiceContext serviceContext) throws ServiceException {
        this.serviceContext = serviceContext;
        this.clusterContext = serviceContext.getClusterContext();
        this.objectRegistry = serviceContext.getContainerContext().getObjectRegistry();
        this.systemMonitor = serviceContext.getContainerContext().getSystemMonitor();
        this.init();
    }

    public void stop() throws ServiceRuntimeException {
        if (this.shell != null) {
            this.shell.unregisterCommands(this.commandsId);
            this.commandsId = -1;
            this.shell = null;
        }
        this.objectRegistry.unregisterInterfaceProvider("log");
        this.objectRegistry.unregisterInterface();
        this.serviceContext.getServiceState().unregisterManagementInterface();
        this.serviceContext.getServiceState().unregisterContainerEventListener();
        EventDispatcherFactory.getEventDispatcher().removeListener((EventListener)this.archivator);
        this.clusterContext.getMessageContext().unregisterListener();
    }

    void init() throws ServiceException {
        this.archivator = new Archivator(this.serviceContext);
        EventDispatcherFactory.getEventDispatcher().addListener((EventListener)this.archivator);
        this.logInterface = new LogInterfaceImpl();
        this.checkUpgrade();
        this.logConfigurator = new LogConfigurator(this.serviceContext, this.clusterContext, this.archivator);
        this.objectRegistry.registerInterfaceProvider("log", (Object)this.logInterface);
        this.objectRegistry.registerInterface((Object)this.logConfigurator);
        int mask = 192;
        HashSet<String> names = new HashSet<String>(2);
        names.add("shell");
        names.add("container");
        this.serviceContext.getServiceState().registerContainerEventListener(mask, names, (ContainerEventListener)this);
        this.serviceContext.getServiceState().registerManagementInterface((ManagementInterface)this.logConfigurator);
        ServiceMonitor thisService = this.systemMonitor.getService(this.serviceContext.getServiceState().getServiceName());
        this.activateLogger(thisService);
        ServiceMonitor[] services = this.systemMonitor.getServices();
        int i = services.length;
        while (--i >= 0) {
            if (services[i] == thisService) continue;
            this.activateLogger(services[i]);
        }
        LibraryMonitor[] libraries = this.systemMonitor.getLibraries();
        int i2 = libraries.length;
        while (--i2 >= 0) {
            this.activateLogger(libraries[i2]);
        }
        try {
            this.clusterContext.getMessageContext().registerListener((MessageListener)this.logConfigurator);
        }
        catch (Throwable t) {
            this.TRACER.traceThrowableT(500, "Unable to register listener in the message context!", t);
        }
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        try {
            if (interfaceName.equals("shell")) {
                this.shell = (ShellInterface)interfaceImpl;
                this.commandsId = this.shell.registerCommands(new Command[]{new LogCreateCommand(this.logConfigurator), new LogRemoveCommand(this.logConfigurator), new LogDumpsCommand(this.logConfigurator), new LogListCommand(this.logConfigurator), new LogEditCommand(this.logConfigurator), new ArchiveCommand(this.logConfigurator)});
            }
        }
        catch (Throwable t) {
            this.TRACER.traceThrowableT(500, "interfaceAvailable(" + interfaceName + ")", t);
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
        if (interfaceName.equals("shell")) {
            this.shell = null;
            this.commandsId = -1;
        }
    }

    public void activateLogger(ServiceMonitor serviceMonitor) {
        try {
            this.TRACER.logT(200, "activateLogger(..)", "Obtaining log configuration for service " + serviceMonitor.getComponentName());
            LogConfiguration configuration = LogXMLParser.extractConfiguration(new PersistenceAdapterExt(serviceMonitor.getDescriptorContainer()), "service_" + serviceMonitor.getComponentName() + "_");
            this.TRACER.logT(200, "activateLogger(..)", "Applying log configuration for service " + serviceMonitor.getComponentName());
            this.logConfigurator.applyConfiguration(configuration);
        }
        catch (Throwable exc) {
            System.out.println(" Could not configure logging for service : " + serviceMonitor.getComponentName() + ". The reason is : " + exc);
            this.TRACER.traceThrowableT(500, "activateLogger(service " + serviceMonitor.getComponentName() + ")", exc);
        }
    }

    public void activateLogger(LibraryMonitor libraryMonitor) {
        try {
            this.TRACER.logT(200, "activateLogger(..)", "Obtaining log configuration for library " + libraryMonitor.getComponentName());
            LogConfiguration configuration = LogXMLParser.extractConfiguration(new PersistenceAdapterExt(libraryMonitor.getDescriptorContainer()), "library_" + libraryMonitor.getComponentName() + "_");
            this.TRACER.logT(200, "activateLogger(..)", "Applying log configuration for library " + libraryMonitor.getComponentName());
            this.logConfigurator.applyConfiguration(configuration);
        }
        catch (Throwable exc) {
            System.out.println(" Could not configure logging for library : " + libraryMonitor.getComponentName() + ". The reason is : " + exc);
            this.TRACER.traceThrowableT(500, "activateLogger(library " + libraryMonitor.getComponentName() + ")", exc);
        }
    }

    public void activateLogger(InterfaceMonitor interfaceMonitor) {
        try {
            this.TRACER.logT(200, "activateLogger(..)", "Obtaining log configuration for interface " + interfaceMonitor.getComponentName());
            LogConfiguration configuration = LogXMLParser.extractConfiguration(new PersistenceAdapterExt(interfaceMonitor.getDescriptorContainer()), "interface_" + interfaceMonitor.getComponentName() + "_");
            this.TRACER.logT(200, "activateLogger(..)", "Applying log configuration for interface " + interfaceMonitor.getComponentName());
            this.logConfigurator.applyConfiguration(configuration);
        }
        catch (Throwable exc) {
            System.out.println(" Could not configure logging for interface : " + interfaceMonitor.getComponentName() + ". The reason is : " + exc);
            this.TRACER.traceThrowableT(500, "activateLogger(interface " + interfaceMonitor.getComponentName() + ")", exc);
        }
    }

    private void checkUpgrade() {
        try {
            PersistentContainer persistentContainer = this.serviceContext.getServiceState().getPersistentContainer();
            if (persistentContainer.getPersistentEntryStream("log-configuration.xml", true) != null) {
                return;
            }
            ServiceMonitor[] services = this.systemMonitor.getServices();
            int i = services.length;
            while (--i >= 0) {
                this.upgradeCustomSettings(services[i].getDescriptorContainer());
            }
            LibraryMonitor[] libraries = this.systemMonitor.getLibraries();
            int i2 = libraries.length;
            while (--i2 >= 0) {
                this.upgradeCustomSettings(libraries[i2].getDescriptorContainer());
            }
            this.upgradeCustomSettings(this.serviceContext.getCoreContext().getCoreMonitor().getDescriptorContainer());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LogXMLParser.writeToXml(out, new LogConfiguration(), false);
            persistentContainer.setPersistentEntryStream("log-configuration.xml", (InputStream)new ByteArrayInputStream(out.toByteArray()), true);
        }
        catch (Throwable exc) {
            System.out.println(" Failed to complete the upgrade checking! The reason is : " + exc);
            this.TRACER.traceThrowableT(500, "Failed to complete the upgrade checking!", exc);
        }
    }

    private void upgradeCustomSettings(DescriptorContainer descriptorContainer) throws Exception {
        InputStream customChanges = descriptorContainer.getLocalPersistentEntryStream("log-configuration.xml");
        if (customChanges != null) {
            descriptorContainer.setPersistentEntryStream("custom-log-configuration.xml", customChanges, false);
            descriptorContainer.removePersistentEntry("log-configuration.xml", false);
        }
    }
}

