/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.services.deploy.container.AdditionalAppInfo;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ContainerDeploymentInfo;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ExportInfo;
import com.sap.engine.services.deploy.container.FileUpdateInfo;
import com.sap.engine.services.deploy.container.ProgressListener;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.log_configurator.admin.LogConfigurator;
import com.sap.engine.services.log_configurator.admin.LogXMLParser;
import com.sap.engine.services.log_configurator.admin.PersistenceAdapterExt;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

public class LogConfiguratorContainer
implements ContainerInterface {
    private static final Location TRACER = Location.getLocation((Class)(class$com$sap$engine$services$log_configurator$LogConfiguratorContainer == null ? (class$com$sap$engine$services$log_configurator$LogConfiguratorContainer = LogConfiguratorContainer.class$("com.sap.engine.services.log_configurator.LogConfiguratorContainer")) : class$com$sap$engine$services$log_configurator$LogConfiguratorContainer));
    public static final String OLD_DEFAULT_CONFIG_FILE_NAME = "default-log-configuration.xml";
    public static final String DEFAULT_CONFIG_FILE_NAME = "log-configuration.xml";
    public static final String CONFIG_FILE_NAME = "custom-log-configuration.xml";
    public static final String CONFIG_FILE_PATH = "META-INF/";
    public static final String CONTAINER_NAME = "Log Configurator";
    public static final String MODULE_NAME = "Logging Configuration";
    private final ContainerInfo info;
    private final ServiceContext serviceContext;
    private final LogConfigurator logConfigurator;
    private final ConfigurationHandlerFactory factory;
    private final ConcurrentHashMapObjectObject appliedSettings;
    private final ConcurrentHashMapObjectObject notAppliedSettings;
    static /* synthetic */ Class class$com$sap$engine$services$log_configurator$LogConfiguratorContainer;

    public LogConfiguratorContainer(ServiceContext serviceContext, LogConfigurator logConfigurator) {
        this.factory = serviceContext.getCoreContext().getConfigurationHandlerFactory();
        this.notAppliedSettings = new ConcurrentHashMapObjectObject();
        this.appliedSettings = new ConcurrentHashMapObjectObject();
        this.logConfigurator = logConfigurator;
        this.serviceContext = serviceContext;
        this.info = new ContainerInfo();
        this.info.setFileExtensions(null);
        this.info.setFileNames(new String[]{"META-INF/log-configuration.xml", DEFAULT_CONFIG_FILE_NAME});
        this.info.setJ2EEContainer(false);
        this.info.setJ2EEModuleName(null);
        this.info.setModuleName(MODULE_NAME);
        this.info.setName(CONTAINER_NAME);
        this.info.setResourceTypes(null);
        this.info.setServiceName(serviceContext.getServiceState().getServiceName());
        this.info.setSupportingSingleFileUpdate(false);
        this.info.setPriority(100);
    }

    public ContainerInfo getContainerInfo() {
        return this.info;
    }

    public String getApplicationName(File standaloneFile) throws DeploymentException {
        throw new DeploymentException();
    }

    public ApplicationDeployInfo deploy(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        String applicationName = dInfo.getApplicationName();
        TRACER.logT(200, "deploy(..)", "ApplicationName is " + applicationName + " --> Entering method.");
        try {
            FileInputStream input = new FileInputStream(archiveFiles[0]);
            LogConfiguration cfg = new LogXMLParser().parse(input);
            input.close();
            TRACER.logT(200, "deploy(..)", "Storing xml into the database.");
            dInfo.getConfiguration().createSubConfiguration(CONTAINER_NAME).addFileEntryByKey(DEFAULT_CONFIG_FILE_NAME, archiveFiles[0]);
            String[] deployedComponentNames = cfg.getLogControllersNames();
            if (deployedComponentNames.length == 0) {
                deployedComponentNames = new String[]{"Additional Settings"};
            }
            ApplicationDeployInfo appDeployInfo = new ApplicationDeployInfo();
            appDeployInfo.setDeployedComponentNames(deployedComponentNames);
            appDeployInfo.setOptionalContainer(true);
            TRACER.logT(200, "deploy(..)", "ApplicationName is " + applicationName + " --> Exiting method. Return value is: " + appDeployInfo);
            return appDeployInfo;
        }
        catch (Throwable e) {
            TRACER.traceThrowableT(400, "deploy(..)", "Deployment of logging configuration for application " + applicationName + " failed!", e);
            return new ApplicationDeployInfo();
        }
    }

    public void notifyDeployedComponents(String applicationName, Properties props) throws WarningException {
    }

    public void prepareDeploy(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
    }

    public void commitDeploy(String applicationName) throws WarningException {
        TRACER.logT(200, "commitDeploy(..)", "ApplicationName is " + applicationName + ".");
    }

    public void rollbackDeploy(String applicationName) throws WarningException {
        TRACER.logT(200, "rollbackDeploy(..)", "ApplicationName is " + applicationName + ".");
    }

    public boolean needUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        TRACER.logT(200, "needUpdate(..)", "ApplicationName is " + dInfo.getApplicationName() + " --> Entering method.");
        try {
            TRACER.logT(200, "needUpdate(..)", "Getting xml from the DB.");
            try {
                LogConfiguration current = new LogXMLParser().parse(dInfo.getConfiguration().getSubConfiguration(CONTAINER_NAME).getFile(DEFAULT_CONFIG_FILE_NAME));
                TRACER.logT(200, "needUpdate(..)", "ApplicationName is " + dInfo.getApplicationName() + " --> Cheking for equality and exiting.");
                return !current.equals((Object)new LogXMLParser().parse(new FileInputStream(archiveFiles[0])));
            }
            catch (NameNotFoundException nexc) {
                TRACER.logT(200, "needUpdate(..)", "No log-configuration.xml exists in the DB.");
                dInfo.getConfiguration().createSubConfiguration(CONTAINER_NAME);
                return true;
            }
        }
        catch (Throwable e) {
            TRACER.traceThrowableT(400, "needUpdate(..)", "Update checking of logging configuration for application " + dInfo.getApplicationName() + " failed!", e);
            throw new WarningException("Update checking of logging configuration for application " + dInfo.getApplicationName() + " failed!", null, e);
        }
    }

    public boolean needStopOnUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return true;
    }

    public ApplicationDeployInfo makeUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        String appName = dInfo.getApplicationName();
        TRACER.logT(200, "makeUpdate(..)", "ApplicationName is " + appName + " --> Entering method.");
        try {
            FileInputStream input = new FileInputStream(archiveFiles[0]);
            LogConfiguration cfg = new LogXMLParser().parse(input);
            String[] deployedComponentNames = cfg.getLogControllersNames();
            ((InputStream)input).close();
            if (deployedComponentNames.length == 0) {
                deployedComponentNames = new String[]{"Additional Settings"};
            }
            TRACER.logT(200, "makeUpdate(..)", "Storing xml into the database.");
            Configuration config = dInfo.getConfiguration().getSubConfiguration(CONTAINER_NAME);
            config.updateFileByKey(DEFAULT_CONFIG_FILE_NAME, archiveFiles[0], true);
            try {
                config.deleteFile(OLD_DEFAULT_CONFIG_FILE_NAME);
            }
            catch (NameNotFoundException nexc) {
                TRACER.traceThrowableT(200, "", (Throwable)nexc);
            }
            ApplicationDeployInfo appDeployInfo = new ApplicationDeployInfo();
            appDeployInfo.setDeployedComponentNames(deployedComponentNames);
            TRACER.logT(200, "makeUpdate(..)", "ApplicationName is " + appName + " --> Exiting method. Return value is: " + appDeployInfo);
            return appDeployInfo;
        }
        catch (Throwable e) {
            TRACER.traceThrowableT(400, "makeUpdate(..)", "Update of logging configuration for application " + appName + " failed!", e);
            return new ApplicationDeployInfo();
        }
    }

    public void notifyUpdatedComponents(String applicationName, Configuration applicationConfig, Properties props) throws WarningException {
    }

    public void prepareUpdate(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitUpdate(String applicationName) throws WarningException {
        TRACER.logT(200, "commitUpdate(..)", "ApplicationName is " + applicationName + ".");
        return new ApplicationDeployInfo();
    }

    public void rollbackUpdate(String applicationName, Configuration applicationConfig, Properties props) throws WarningException {
        TRACER.logT(200, "rollbackUpdate(..)", "ApplicationName is " + applicationName + ".");
    }

    public void remove(String applicationName) throws DeploymentException, WarningException {
        TRACER.logT(200, "remove(..)", "ApplicationName is " + applicationName + ".");
    }

    public void downloadApplicationFiles(String applicationName, Configuration applicationConfig) throws DeploymentException, WarningException {
    }

    public void prepareStart(String applicationName, Configuration applicationConfig) throws DeploymentException, WarningException {
        TRACER.logT(200, "prepareStart(..)", "ApplicationName is " + applicationName + " --> Entering method.");
        try {
            TRACER.logT(200, "prepareStart(..)", "reading xml from database.");
            applicationConfig = applicationConfig.getSubConfiguration(CONTAINER_NAME);
            InputStream defaultSettings = applicationConfig.getFile(DEFAULT_CONFIG_FILE_NAME);
            InputStream customSettings = null;
            try {
                customSettings = applicationConfig.getFile(CONFIG_FILE_NAME);
            }
            catch (NameNotFoundException nex) {
                // empty catch block
            }
            LogConfiguration config = LogXMLParser.extractConfiguration(defaultSettings, customSettings, new PersistenceAdapterExt(applicationConfig.getPath(), this.factory), "application_" + applicationName + "_");
            this.logConfigurator.applyConfiguration(config, null);
            this.appliedSettings.put((Object)applicationName, (Object)config);
        }
        catch (Throwable e) {
            TRACER.traceThrowableT(400, "prepareStart(..)", "Preparation of logging configuration for application " + applicationName + " failed!", e);
            throw new WarningException("Preparation of logging configuration for application " + applicationName + " failed!", null, e);
        }
        TRACER.logT(200, "prepareStart(..)", "ApplicationName is " + applicationName + " --> Exiting method.");
    }

    public void commitStart(String applicationName) throws WarningException {
    }

    public void rollbackStart(String applicationName) throws WarningException {
        TRACER.logT(200, "rollbackStart(..)", "ApplicationName is " + applicationName + ".");
        this.commitStop(applicationName);
    }

    public void prepareStop(String applicationName, Configuration applicationConfig) throws DeploymentException, WarningException {
    }

    public void commitStop(String applicationName) throws WarningException {
        try {
            TRACER.logT(200, "commitStop(..)", "ApplicationName is " + applicationName + " --> Entering method.");
            this.logConfigurator.applyConfiguration(null, (LogConfiguration)this.appliedSettings.remove((Object)applicationName));
            TRACER.logT(200, "commitStop(..)", "ApplicationName is " + applicationName + " --> Exiting method.");
        }
        catch (Throwable e) {
            TRACER.traceThrowableT(400, "commitStop(..)", "Unconfiguring logging / tracing for application " + applicationName + " failed!", e);
            throw new WarningException("Unconfiguring logging / tracing for application " + applicationName + " failed!", null, e);
        }
    }

    public void rollbackStop(String applicationName) throws WarningException {
        TRACER.logT(200, "rollbackStop(..)", "ApplicationName is " + applicationName + ".");
    }

    public void notifyRuntimeChanges(String applicationName, Configuration applicationConfig) throws WarningException {
    }

    public void prepareRuntimeChanges(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitRuntimeChanges(String applicationName) throws WarningException {
        return null;
    }

    public void rollbackRuntimeChanges(String applicationName) throws WarningException {
    }

    public File[] getClientJar(String applicationName) {
        return null;
    }

    public void addProgressListener(ProgressListener listener) {
    }

    public void removeProgressListener(ProgressListener listener) {
    }

    public ExportInfo[] getCurrentStatus(String applicationName) throws WarningException {
        return null;
    }

    public boolean needStopOnSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return false;
    }

    public ApplicationDeployInfo makeSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        return null;
    }

    public void notifySingleFileUpdate(String applicationName, Configuration config, Properties props) throws WarningException {
    }

    public void prepareSingleFileUpdate(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitSingleFileUpdate(String applicationName) throws WarningException {
        return null;
    }

    public void rollbackSingleFileUpdate(String applicationName, Configuration config) throws WarningException {
    }

    public void applicationStatusChanged(String applicationName, byte status) {
    }

    public String[] getResourcesForTempLoader(String applicationName) throws DeploymentException {
        return null;
    }

    public boolean acceptedAppInfoChange(String appName, AdditionalAppInfo addAppInfo) throws DeploymentException {
        return false;
    }

    public boolean needStopOnAppInfoChanged(String appName, AdditionalAppInfo addAppInfo) {
        return false;
    }

    public void makeAppInfoChange(String appName, AdditionalAppInfo addAppInfo, Configuration configuration) throws WarningException, DeploymentException {
    }

    public void appInfoChangedCommit(String appName) throws WarningException {
    }

    public void appInfoChangedRollback(String appName) throws WarningException {
    }

    public void notifyAppInfoChanged(String appName) throws WarningException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

