/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.ServiceRuntimeException;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.ContainerManagement;
import com.sap.engine.services.log_configurator.LogConfiguratorContainer;
import com.sap.engine.services.log_configurator.LogConfiguratorServiceFrameImpl;

public class LogConfiguratorApplicationServiceFrame
extends LogConfiguratorServiceFrameImpl
implements ApplicationServiceFrame {
    private ContainerManagement deployService = null;
    private LogConfiguratorContainer logContainer = null;

    public void start(ApplicationServiceContext serviceContext) throws ServiceException {
        this.serviceContext = serviceContext;
        this.clusterContext = serviceContext.getClusterContext();
        this.objectRegistry = serviceContext.getContainerContext().getObjectRegistry();
        this.systemMonitor = serviceContext.getContainerContext().getSystemMonitor();
        this.init();
    }

    public void stop() throws ServiceRuntimeException {
        super.stop();
        if (this.deployService != null) {
            this.deployService.unregisterContainer(this.logContainer.getContainerInfo().getName());
            this.deployService = null;
            this.logContainer = null;
        }
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if ("container".equals(interfaceName)) {
            try {
                this.deployService = (ContainerManagement)interfaceImpl;
                this.logContainer = new LogConfiguratorContainer(this.serviceContext, this.logConfigurator);
                this.deployService.registerContainer(this.logContainer.getContainerInfo().getName(), (ContainerInterface)this.logContainer);
            }
            catch (Exception ex) {
                this.TRACER.traceThrowableT(500, "interfaceAvailable(\"container\")", "", (Throwable)ex);
            }
        } else {
            super.interfaceAvailable(interfaceName, interfaceImpl);
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
        if ("container".equals(interfaceName)) {
            this.deployService = null;
            this.logContainer = null;
        } else {
            super.interfaceNotAvailable(interfaceName);
        }
    }
}

