/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.log_configurator;

import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ArchiveThread
implements Runnable {
    private static final int BUFFER_LENGTH = 10000;
    private static final Location CLASS_LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$log_configurator$OverwriteLogfileListenerImpl == null ? (class$com$sap$engine$services$log_configurator$OverwriteLogfileListenerImpl = ArchiveThread.class$("com.sap.engine.services.log_configurator.OverwriteLogfileListenerImpl")) : class$com$sap$engine$services$log_configurator$OverwriteLogfileListenerImpl));
    private long[] fileTimes;
    private String[] fileNames;
    private String zipFileName;
    static /* synthetic */ Class class$com$sap$engine$services$log_configurator$OverwriteLogfileListenerImpl;

    public ArchiveThread(String[] fileNames, String zipFileName, long[] fileTimes) {
        this.fileNames = fileNames;
        this.zipFileName = zipFileName;
        this.fileTimes = fileTimes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            Thread.currentThread().setPriority(4);
            byte[] buffer = new byte[10000];
            ZipOutputStream zout = null;
            ZipEntry zipEntry = null;
            try {
                zout = new ZipOutputStream(new FileOutputStream(this.zipFileName));
            }
            catch (FileNotFoundException e) {
                CLASS_LOCATION.logT(500, "Can't create '" + this.zipFileName + "': " + e.getMessage());
                this.deleteFiles();
                Object var11_6 = null;
                Thread.currentThread().setPriority(5);
                return;
            }
            int i = 0;
            while (true) {
                block15: {
                    if (i >= this.fileNames.length) {
                        try {
                            zout.close();
                        }
                        catch (IOException e) {
                            CLASS_LOCATION.logT(400, "Can't close zipfile '" + this.zipFileName + "'.");
                        }
                        break;
                    }
                    if (this.fileNames[i] != null) {
                        Object var9_14;
                        try {
                            try {
                                CLASS_LOCATION.logT(300, "Adding '" + this.fileNames[i] + "' to '" + this.zipFileName + "'.");
                                int lastIndex = this.fileNames[i].lastIndexOf(47);
                                zipEntry = lastIndex > 0 ? new ZipEntry(this.fileNames[i].substring(lastIndex + 1)) : new ZipEntry(this.fileNames[i]);
                                zipEntry.setTime(this.fileTimes[i]);
                                zout.putNextEntry(zipEntry);
                                FileInputStream in = new FileInputStream(this.fileNames[i]);
                                while (in.available() != 0) {
                                    int readed = in.read(buffer);
                                    if (readed <= 0) continue;
                                    zout.write(buffer, 0, readed);
                                }
                                in.close();
                            }
                            catch (IOException e) {
                                CLASS_LOCATION.logT(500, "I/O error occurs when adding'" + this.fileNames[i] + "':" + e.getMessage());
                                var9_14 = null;
                                if (!new File(this.fileNames[i]).delete()) {
                                    CLASS_LOCATION.logT(400, "Can't delete '" + this.fileNames[i] + "'.");
                                }
                                break block15;
                            }
                            var9_14 = null;
                            if (new File(this.fileNames[i]).delete()) break block15;
                        }
                        catch (Throwable throwable) {
                            var9_14 = null;
                            if (new File(this.fileNames[i]).delete()) throw throwable;
                            CLASS_LOCATION.logT(400, "Can't delete '" + this.fileNames[i] + "'.");
                            throw throwable;
                        }
                        CLASS_LOCATION.logT(400, "Can't delete '" + this.fileNames[i] + "'.");
                    }
                }
                ++i;
            }
            Object var11_7 = null;
            Thread.currentThread().setPriority(5);
            return;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            Thread.currentThread().setPriority(5);
            throw throwable;
        }
    }

    private void deleteFiles() {
        int i = 0;
        while (i < this.fileNames.length) {
            if (this.fileNames[i] != null && !new File(this.fileNames[i]).delete()) {
                CLASS_LOCATION.logT(400, "Can't delete '" + this.fileNames[i] + "'.");
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

