/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.internal.Timer;
import org.eclipse.gef.ui.parts.AbstractEditPartViewer;
import org.eclipse.gef.ui.parts.RootTreeEditPart;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeViewer
extends AbstractEditPartViewer {
    private boolean ignore = false;
    private EventDispatcher dispatcher = new EventDispatcher();

    public TreeViewer() {
        RootTreeEditPart rep = new RootTreeEditPart();
        this.setRootEditPart(rep);
    }

    public Control createControl(Composite parent) {
        Tree tree = new Tree(parent, 770);
        this.setControl((Control)tree);
        return tree;
    }

    public EditPart findObjectAt(Point pt) {
        return this.findObjectAtExcluding(pt, Collections.EMPTY_SET);
    }

    public EditPart findObjectAtExcluding(Point pt, Collection exclude) {
        if (this.getControl() == null) {
            return null;
        }
        Tree tree = (Tree)this.getControl();
        Rectangle area = tree.getClientArea();
        if (pt.x < 0 || pt.y < 0 || pt.x >= area.width || pt.y >= area.height) {
            return null;
        }
        EditPart result = null;
        TreeItem tie = tree.getItem(new org.eclipse.swt.graphics.Point(pt.x, pt.y));
        result = tie != null ? (EditPart)tie.getData() : (EditPart)tree.getData();
        return exclude.contains(result) ? null : result;
    }

    protected void fireSelectionChanged() {
        super.fireSelectionChanged();
        this.showSelectionInTree();
    }

    protected void hookControl() {
        if (this.getControl() == null) {
            return;
        }
        BehaviourCustomizer customizer = new BehaviourCustomizer();
        final Tree tree = (Tree)this.getControl();
        tree.addFocusListener((FocusListener)this.dispatcher);
        tree.addMouseListener((MouseListener)customizer);
        tree.addMouseMoveListener((MouseMoveListener)customizer);
        tree.addMouseTrackListener((MouseTrackListener)customizer);
        tree.addMouseListener((MouseListener)this.dispatcher);
        tree.addMouseMoveListener((MouseMoveListener)this.dispatcher);
        tree.addKeyListener((KeyListener)this.dispatcher);
        tree.addMouseTrackListener((MouseTrackListener)this.dispatcher);
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] ties = tree.getSelection();
                Object[] newSelection = new Object[ties.length];
                int i = 0;
                while (i < ties.length) {
                    newSelection[i] = ties[i].getData();
                    ++i;
                }
                TreeViewer.this.ignore = true;
                TreeViewer.this.setSelection((ISelection)new StructuredSelection(newSelection));
                TreeViewer.this.ignore = false;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        TreeEditPart tep = (TreeEditPart)((Object)this.getRootEditPart());
        tep.setWidget((Widget)tree);
        super.hookControl();
    }

    protected void hookDragSource() {
        this.getDragSource().addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                Tree tree = (Tree)TreeViewer.this.getControl();
                TreeItem[] items = tree.getSelection();
                ArrayList<Object> newSelection = new ArrayList<Object>();
                int i = 0;
                while (i < items.length) {
                    newSelection.add(items[i].getData());
                    ++i;
                }
                TreeViewer.this.setSelection((ISelection)new StructuredSelection(newSelection));
            }
        });
        super.hookDragSource();
    }

    private void showSelectionInTree() {
        if (this.ignore || this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        List selection = this.getSelectedEditParts();
        Tree tree = (Tree)this.getControl();
        ArrayList<TreeEditPart> treeParts = new ArrayList<TreeEditPart>();
        int i = 0;
        while (i < selection.size()) {
            TreeEditPart part = (TreeEditPart)selection.get(i);
            if (part.getWidget() instanceof TreeItem) {
                treeParts.add(part);
            }
            ++i;
        }
        TreeItem[] treeItems = new TreeItem[treeParts.size()];
        int i2 = 0;
        while (i2 < treeParts.size()) {
            TreeEditPart part = (TreeEditPart)treeParts.get(i2);
            treeItems[i2] = (TreeItem)part.getWidget();
            ++i2;
        }
        tree.setSelection(treeItems);
    }

    protected void unhookControl() {
        if (this.getControl() == null) {
            return;
        }
        super.unhookControl();
        TreeEditPart tep = (TreeEditPart)((Object)this.getRootEditPart());
        tep.setWidget(null);
    }

    class EventDispatcher
    implements MouseListener,
    MouseMoveListener,
    KeyListener,
    MouseTrackListener,
    FocusListener {
        protected static final int ANY_BUTTON = 0x380000;
        private boolean dragInProgress = false;

        EventDispatcher() {
        }

        public void keyPressed(KeyEvent kee) {
            TreeViewer.this.getEditDomain().keyDown(kee, TreeViewer.this);
        }

        public void keyReleased(KeyEvent kee) {
            TreeViewer.this.getEditDomain().keyUp(kee, TreeViewer.this);
        }

        public void mouseDoubleClick(MouseEvent me) {
            TreeViewer.this.getEditDomain().mouseDoubleClick(me, TreeViewer.this);
        }

        public void mouseDown(MouseEvent me) {
            this.dragInProgress = true;
            TreeViewer.this.getEditDomain().mouseDown(me, TreeViewer.this);
        }

        public void mouseEnter(MouseEvent me) {
            TreeViewer.this.getEditDomain().viewerEntered(me, TreeViewer.this);
        }

        public void mouseExit(MouseEvent me) {
            TreeViewer.this.getEditDomain().viewerExited(me, TreeViewer.this);
            this.mouseMove(me);
        }

        public void mouseHover(MouseEvent me) {
            TreeViewer.this.getEditDomain().mouseHover(me, TreeViewer.this);
        }

        public void mouseMove(MouseEvent me) {
            if ((me.stateMask & 0x380000) != 0) {
                TreeViewer.this.getEditDomain().mouseDrag(me, TreeViewer.this);
            } else {
                TreeViewer.this.getEditDomain().mouseMove(me, TreeViewer.this);
            }
        }

        public void mouseUp(MouseEvent me) {
            this.dragInProgress = false;
            TreeViewer.this.getEditDomain().mouseUp(me, TreeViewer.this);
        }

        public void focusGained(FocusEvent event) {
            TreeViewer.this.getEditDomain().focusGained(event, TreeViewer.this);
        }

        public void focusLost(FocusEvent event) {
            TreeViewer.this.getEditDomain().focusLost(event, TreeViewer.this);
        }
    }

    class BehaviourCustomizer
    extends MouseTrackAdapter
    implements MouseListener,
    MouseMoveListener {
        int autoScrollPixelLength = 6;
        boolean top;
        boolean bottom;
        boolean dragInProgress;
        boolean expansionInProgress;
        private final Tree tree;
        private final ScrollBar hBar;
        private final ScrollBar vBar;
        private final Display display;
        private Timer topTimer;
        private Timer bottomTimer;
        private Timer autoExpandTimer;
        private TreeItem itemToBeExpanded;

        BehaviourCustomizer() {
            this.tree = (Tree)TreeViewer.this.getControl();
            this.hBar = this.tree.getHorizontalBar();
            this.vBar = this.tree.getVerticalBar();
            this.display = this.tree.getDisplay();
            this.topTimer = new Timer();
            this.bottomTimer = new Timer();
            this.autoExpandTimer = new Timer();
        }

        private TreeItem getNextItem(TreeItem item, boolean includeChildren) {
            TreeItem[] children;
            if (item == null) {
                return null;
            }
            if (includeChildren && item.getExpanded() && (children = item.getItems()) != null && children.length > 0) {
                return children[0];
            }
            TreeItem parent = item.getParentItem();
            TreeItem[] siblings = parent == null ? this.tree.getItems() : parent.getItems();
            if (siblings != null && siblings.length <= 1) {
                return this.getNextItem(parent, false);
            }
            int i = 0;
            while (i < siblings.length) {
                if (siblings[i] == item && i < siblings.length - 1) {
                    return siblings[i + 1];
                }
                ++i;
            }
            return this.getNextItem(parent, false);
        }

        private TreeItem getPreviousItem(TreeItem item) {
            TreeItem parent = item.getParentItem();
            TreeItem[] siblings = parent == null ? this.tree.getItems() : parent.getItems();
            if (siblings.length == 0 || siblings[0] == item) {
                return parent;
            }
            TreeItem previous = siblings[0];
            int i = 1;
            while (i < siblings.length) {
                if (siblings[i] == item) {
                    return this.rightMostVisibleDescendent(previous);
                }
                previous = siblings[i];
                ++i;
            }
            return null;
        }

        private void launchAutoExpandTimer() {
            if (this.itemToBeExpanded == null) {
                return;
            }
            this.expansionInProgress = true;
            this.autoExpandTimer = new Timer();
            this.autoExpandTimer.scheduleRepeatedly(new Runnable(this){
                private final /* synthetic */ BehaviourCustomizer this$1;
                {
                    this.this$1 = behaviourCustomizer;
                }

                public void run() {
                    BehaviourCustomizer.access$0(this.this$1).syncExec(new Runnable(this){
                        private final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public void run() {
                            if (BehaviourCustomizer.access$1(1.access$0(this.this$2)) != null) {
                                BehaviourCustomizer.access$1(1.access$0(this.this$2)).setExpanded(true);
                            }
                            BehaviourCustomizer.access$2(1.access$0(this.this$2));
                        }
                    });
                }

                static /* synthetic */ BehaviourCustomizer access$0(1 var0) {
                    return var0.this$1;
                }
            }, 500, 100000);
        }

        private void launchBottomTimer() {
            if (this.vBar == null || !this.vBar.isEnabled() || this.bottom) {
                return;
            }
            this.bottomTimer = new Timer();
            this.bottomTimer.scheduleRepeatedly(new Runnable(this){
                private final /* synthetic */ BehaviourCustomizer this$1;
                {
                    this.this$1 = behaviourCustomizer;
                }

                public void run() {
                    BehaviourCustomizer.access$0(this.this$1).syncExec(new Runnable(this){
                        private final /* synthetic */ 3 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public void run() {
                            BehaviourCustomizer.access$3(3.access$0(this.this$2));
                        }
                    });
                }

                static /* synthetic */ BehaviourCustomizer access$0(3 var0) {
                    return var0.this$1;
                }
            }, 400, 300);
            this.bottom = true;
        }

        private void launchTopTimer() {
            if (this.vBar == null || !this.vBar.isEnabled() || this.top) {
                return;
            }
            this.topTimer = new Timer();
            this.topTimer.scheduleRepeatedly(new Runnable(this){
                private final /* synthetic */ BehaviourCustomizer this$1;
                {
                    this.this$1 = behaviourCustomizer;
                }

                public void run() {
                    BehaviourCustomizer.access$0(this.this$1).syncExec(new Runnable(this){
                        private final /* synthetic */ 5 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public void run() {
                            BehaviourCustomizer.access$4(5.access$0(this.this$2));
                        }
                    });
                }

                static /* synthetic */ BehaviourCustomizer access$0(5 var0) {
                    return var0.this$1;
                }
            }, 400, 300);
            this.top = true;
        }

        public void mouseDoubleClick(MouseEvent me) {
        }

        public void mouseDown(MouseEvent me) {
            TreeViewer.this.getControl().setFocus();
            this.dragInProgress = true;
        }

        public void mouseEnter(MouseEvent me) {
            if ((me.stateMask & 0x380000) != 0) {
                TreeViewer.this.getControl().setFocus();
                this.dragInProgress = true;
            }
        }

        public void mouseExit(MouseEvent me) {
            this.stopBottomTimer();
            this.stopTopTimer();
            this.stopAutoExpandTimer();
            this.mouseUp(me);
        }

        public void mouseMove(MouseEvent me) {
            Rectangle area = ((Tree)TreeViewer.this.getControl()).getClientArea();
            if (area.width < 2 * this.autoScrollPixelLength || area.height < 2 * this.autoScrollPixelLength) {
                return;
            }
            org.eclipse.swt.graphics.Point point = new org.eclipse.swt.graphics.Point(me.x, me.y);
            Rectangle topEdge = new Rectangle(area.x, area.y, area.width, this.autoScrollPixelLength);
            Rectangle bottomEdge = new Rectangle(area.x, area.y + area.height - this.autoScrollPixelLength, area.width, this.autoScrollPixelLength);
            if (this.dragInProgress) {
                if (topEdge.contains(point)) {
                    this.launchTopTimer();
                } else {
                    this.stopTopTimer();
                }
                if (bottomEdge.contains(point)) {
                    this.launchBottomTimer();
                } else {
                    this.stopBottomTimer();
                }
                if (this.expansionInProgress) {
                    if (this.itemToBeExpanded != this.tree.getItem(point)) {
                        this.stopAutoExpandTimer();
                        this.itemToBeExpanded = this.tree.getItem(point);
                        this.launchAutoExpandTimer();
                    }
                } else {
                    this.itemToBeExpanded = this.tree.getItem(point);
                    this.launchAutoExpandTimer();
                }
            } else {
                this.stopAutoExpandTimer();
                this.stopTopTimer();
                this.stopBottomTimer();
            }
        }

        public void mouseUp(MouseEvent me) {
            this.dragInProgress = false;
            this.stopAutoExpandTimer();
            this.stopTopTimer();
            this.stopBottomTimer();
        }

        private TreeItem rightMostVisibleDescendent(TreeItem item) {
            TreeItem[] children = item.getItems();
            if (item.getExpanded() && children != null && children.length > 0) {
                return this.rightMostVisibleDescendent(children[children.length - 1]);
            }
            return item;
        }

        /*
         * Unable to fully structure code
         */
        private void scrollDown() {
            xInterval = 10;
            yPoint = this.tree.getClientArea().height - 1;
            width = this.tree.getClientArea().width;
            height = this.tree.getClientArea().height;
            point = new org.eclipse.swt.graphics.Point(xInterval, yPoint);
            item = this.tree.getItem(point);
            ** GOTO lbl14
            {
                point.x += xInterval;
                item = this.tree.getItem(point);
                do {
                    if (item == null && point.x < width) continue block0;
                    --point.y;
                    point.x = xInterval;
lbl14:
                    // 2 sources

                } while (item == null && point.y < height);
            }
            if ((item = this.getNextItem(item, true)) != null && this.bottom) {
                this.tree.showItem(item);
            }
        }

        /*
         * Unable to fully structure code
         */
        private void scrollUp() {
            xInterval = 10;
            yPoint = 1;
            width = this.tree.getClientArea().width;
            height = this.tree.getClientArea().height;
            point = new org.eclipse.swt.graphics.Point(xInterval, yPoint);
            item = this.tree.getItem(point);
            ** GOTO lbl14
            {
                point.x += xInterval;
                item = this.tree.getItem(point);
                do {
                    if (item == null && point.x < width) continue block0;
                    ++point.y;
                    point.x = xInterval;
lbl14:
                    // 2 sources

                } while (item == null && point.y < height);
            }
            if ((item = this.getPreviousItem(item)) != null && this.top) {
                this.tree.showItem(item);
            }
        }

        private void stopAutoExpandTimer() {
            this.autoExpandTimer.cancel();
            this.expansionInProgress = false;
            this.itemToBeExpanded = null;
        }

        private void stopBottomTimer() {
            this.bottomTimer.cancel();
            this.bottom = false;
        }

        private void stopTopTimer() {
            this.topTimer.cancel();
            this.top = false;
        }

        static /* synthetic */ Display access$0(BehaviourCustomizer behaviourCustomizer) {
            return behaviourCustomizer.display;
        }

        static /* synthetic */ TreeItem access$1(BehaviourCustomizer behaviourCustomizer) {
            return behaviourCustomizer.itemToBeExpanded;
        }

        static /* synthetic */ void access$2(BehaviourCustomizer behaviourCustomizer) {
            behaviourCustomizer.stopAutoExpandTimer();
        }

        static /* synthetic */ void access$3(BehaviourCustomizer behaviourCustomizer) {
            behaviourCustomizer.scrollDown();
        }

        static /* synthetic */ void access$4(BehaviourCustomizer behaviourCustomizer) {
            behaviourCustomizer.scrollUp();
        }
    }
}

