/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionSynchronizer
implements ISelectionChangedListener {
    private List viewers = new ArrayList();
    private boolean isDispatching = false;

    public void addViewer(EditPartViewer viewer) {
        viewer.addSelectionChangedListener(this);
        this.viewers.add(viewer);
    }

    protected EditPart convert(EditPartViewer viewer, EditPart part) {
        Object temp = viewer.getEditPartRegistry().get(part.getModel());
        EditPart newPart = null;
        if (temp != null) {
            newPart = (EditPart)temp;
        }
        return newPart;
    }

    public void removeViewer(EditPartViewer viewer) {
        viewer.removeSelectionChangedListener(this);
        this.viewers.remove(viewer);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.isDispatching) {
            return;
        }
        this.isDispatching = true;
        EditPartViewer source = (EditPartViewer)event.getSelectionProvider();
        ISelection selection = event.getSelection();
        int i = 0;
        while (i < this.viewers.size()) {
            if (this.viewers.get(i) != source) {
                EditPartViewer viewer = (EditPartViewer)this.viewers.get(i);
                this.setViewerSelection(viewer, selection);
            }
            ++i;
        }
        this.isDispatching = false;
    }

    private void setViewerSelection(EditPartViewer viewer, ISelection selection) {
        ArrayList<EditPart> result = new ArrayList<EditPart>();
        Iterator iter = ((IStructuredSelection)selection).iterator();
        while (iter.hasNext()) {
            EditPart part = this.convert(viewer, (EditPart)iter.next());
            if (part == null) continue;
            result.add(part);
        }
        viewer.setSelection((ISelection)new StructuredSelection(result));
    }
}

