/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.ui.parts.GraphicalViewerImpl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ScrollingGraphicalViewer
extends GraphicalViewerImpl {
    public final Control createControl(Composite parent) {
        FigureCanvas canvas = new FigureCanvas(parent);
        super.setControl((Control)canvas);
        this.installRootFigure();
        return canvas;
    }

    protected void expose(EditPart part) {
        super.expose(part);
        Viewport port = this.getFigureCanvas().getViewport();
        IFigure target = ((GraphicalEditPart)part).getFigure();
        Rectangle exposeRegion = target.getBounds().getExpanded(5, 5);
        target = target.getParent();
        while (target != null && target != port) {
            target.translateToParent((Translatable)exposeRegion);
            target = target.getParent();
        }
        Dimension viewportSize = port.getClientArea().getSize();
        Point topLeft = exposeRegion.getTopLeft();
        Point bottomRight = exposeRegion.getBottomRight().translate(viewportSize.negate());
        Point finalLocation = Point.min((Point)topLeft, (Point)Point.max((Point)bottomRight, (Point)port.getViewLocation()));
        this.getFigureCanvas().scrollSmoothTo(finalLocation.x, finalLocation.y);
    }

    private FigureCanvas getFigureCanvas() {
        return (FigureCanvas)this.getControl();
    }

    protected LightweightSystem getLightweightSystem() {
        if (this.getControl() == null) {
            return super.getLightweightSystem();
        }
        return this.getFigureCanvas().getLightweightSystem();
    }

    private void installRootFigure() {
        if (this.getFigureCanvas() == null) {
            return;
        }
        if (this.rootFigure instanceof Viewport) {
            this.getFigureCanvas().setViewport((Viewport)this.rootFigure);
        } else {
            this.getFigureCanvas().setContents(this.rootFigure);
        }
    }

    protected void setRootFigure(IFigure figure) {
        this.rootFigure = figure;
        this.installRootFigure();
    }
}

