/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.palette.CategoryEditPart;
import org.eclipse.gef.ui.palette.EntryEditPart;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.swt.events.KeyEvent;

public class PaletteViewerKeyHandler
extends GraphicalViewerKeyHandler {
    public PaletteViewerKeyHandler(PaletteViewer viewer) {
        super(viewer);
    }

    private boolean acceptCollapseCategory(KeyEvent event) {
        return event.keyCode == 0x1000003 && this.isExpandedCategory(this.getFocus());
    }

    private boolean acceptExpandCategory(KeyEvent event) {
        return event.keyCode == 0x1000004 && this.isCollapsedCategory(this.getFocus());
    }

    private boolean acceptIntoExpandedCategory(KeyEvent event) {
        return (event.keyCode == 0x1000002 || event.keyCode == 0x1000004) && this.isExpandedCategory(this.getFocus());
    }

    private boolean acceptSetFocusOnCategory(KeyEvent event) {
        return event.keyCode == 0x1000003;
    }

    private void buildNavigationList(EditPart palettePart, EditPart exclusion, ArrayList navList) {
        if (palettePart != exclusion) {
            if (this.isCollapsedCategory(palettePart)) {
                navList.add(palettePart);
                return;
            }
            if (palettePart instanceof EntryEditPart || palettePart instanceof CategoryEditPart) {
                navList.add(palettePart);
            }
        }
        int k = 0;
        while (k < palettePart.getChildren().size()) {
            EditPart ep = (EditPart)palettePart.getChildren().get(k);
            this.buildNavigationList(ep, exclusion, navList);
            ++k;
        }
    }

    private void collapseCategory() {
        CategoryEditPart category = (CategoryEditPart)this.getFocus();
        category.setExpanded(false);
    }

    private void expandCategory() {
        CategoryEditPart category = (CategoryEditPart)this.getFocus();
        category.setExpanded(true);
    }

    Point getInterestingPoint(IFigure figure) {
        return figure.getBounds().getTop();
    }

    List getNavigationSiblings() {
        ArrayList siblingsList = new ArrayList();
        this.buildNavigationList(this.getViewer().getContents(), null, siblingsList);
        return siblingsList;
    }

    boolean isCollapsedCategory(EditPart part) {
        return part instanceof CategoryEditPart && !((CategoryEditPart)part).isExpanded();
    }

    boolean isExpandedCategory(EditPart part) {
        return part instanceof CategoryEditPart && ((CategoryEditPart)part).isExpanded();
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.acceptIntoExpandedCategory(event) && this.navigateIntoExpandedCategory(event)) {
            return true;
        }
        if (this.acceptCollapseCategory(event)) {
            this.collapseCategory();
            return true;
        }
        if (this.acceptExpandCategory(event)) {
            this.expandCategory();
            return true;
        }
        if (this.acceptSetFocusOnCategory(event) && this.navigateToCategory(event)) {
            return true;
        }
        return super.keyPressed(event);
    }

    private boolean navigateIntoExpandedCategory(KeyEvent event) {
        ArrayList potentials = new ArrayList();
        this.buildNavigationList(this.getFocus(), this.getFocus(), potentials);
        if (!potentials.isEmpty()) {
            this.navigateTo((EditPart)potentials.get(0), event);
            return true;
        }
        return false;
    }

    private boolean navigateToCategory(KeyEvent event) {
        boolean found = false;
        EditPart parent = this.getFocus().getParent();
        while (parent != null && !found) {
            if (parent instanceof CategoryEditPart) {
                this.navigateTo(parent, event);
                found = true;
            }
            parent = parent.getParent();
        }
        return false;
    }
}

